/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation.aggregator;

import cascading.flow.FlowProcess;
import cascading.operation.Aggregator;
import cascading.operation.AggregatorCall;
import cascading.operation.BaseOperation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.coerce.Coercions;
import cascading.tuple.type.CoercibleType;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;

public class Average
extends BaseOperation<Context>
implements Aggregator<Context> {
    public static final String FIELD_NAME = "average";
    private Type type = Double.class;
    private CoercibleType canonical;

    public Average() {
        super(1, new Fields((Comparable)((Object)FIELD_NAME), (Type)((Object)Double.class)));
        this.canonical = Coercions.coercibleTypeFor(this.type);
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public Average(Fields fieldDeclaration) {
        super(1, fieldDeclaration);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != 1) {
            throw new IllegalArgumentException("fieldDeclaration may only declare 1 field, got: " + fieldDeclaration.size());
        }
        if (fieldDeclaration.hasTypes()) {
            this.type = fieldDeclaration.getType(0);
        }
        this.canonical = Coercions.coercibleTypeFor(this.type);
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
        operationCall.setContext(new Context(this.canonical));
    }

    @Override
    public void start(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        ((Context)aggregatorCall.getContext()).reset();
    }

    @Override
    public void aggregate(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        Context context = (Context)aggregatorCall.getContext();
        TupleEntry arguments = aggregatorCall.getArguments();
        context.sum += arguments.getDouble(Integer.valueOf(0));
        ++context.count;
    }

    @Override
    public void complete(FlowProcess flowProcess, AggregatorCall<Context> aggregatorCall) {
        aggregatorCall.getOutputCollector().add(this.getResult(aggregatorCall));
    }

    private Tuple getResult(AggregatorCall<Context> aggregatorCall) {
        return ((Context)aggregatorCall.getContext()).result();
    }

    protected static class Context {
        private final CoercibleType canonical;
        Tuple tuple = Tuple.size(1);
        double sum = 0.0;
        long count = 0L;

        public Context(CoercibleType canonical) {
            this.canonical = canonical;
        }

        public Context reset() {
            this.sum = 0.0;
            this.count = 0L;
            return this;
        }

        public Tuple result() {
            this.tuple.set(0, this.canonical.canonical(this.sum / (double)this.count));
            return this.tuple;
        }
    }
}

