/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation;

import cascading.flow.FlowProcess;
import cascading.operation.BaseOperation;
import cascading.operation.Function;
import cascading.operation.FunctionCall;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.util.Util;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.util.Arrays;

public class Identity
extends BaseOperation<Functor>
implements Function<Functor> {
    private Type[] types = null;

    public Identity() {
        super(Fields.ARGS);
    }

    @ConstructorProperties(value={"types"})
    public Identity(Class ... types2) {
        super(Fields.ARGS);
        if (types2.length == 0) {
            throw new IllegalArgumentException("number of types must not be zero");
        }
        this.types = Arrays.copyOf(types2, types2.length);
    }

    @ConstructorProperties(value={"fieldDeclaration"})
    public Identity(Fields fieldDeclaration) {
        super(fieldDeclaration);
        this.types = fieldDeclaration.getTypes();
    }

    @ConstructorProperties(value={"fieldDeclaration", "types"})
    public Identity(Fields fieldDeclaration, Class ... types2) {
        super(fieldDeclaration);
        this.types = Arrays.copyOf(types2, types2.length);
        if (!fieldDeclaration.isSubstitution() && fieldDeclaration.size() != types2.length) {
            throw new IllegalArgumentException("fieldDeclaration and types must be the same size");
        }
    }

    public Type[] getTypes() {
        return Util.copy(this.types);
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Functor> operationCall) {
        Functor functor;
        if (this.types != null) {
            functor = new Functor(){
                Tuple result;
                {
                    this.result = Tuple.size(Identity.this.types.length);
                }

                @Override
                public void operate(FunctionCall<Functor> functionCall) {
                    TupleEntry input2 = functionCall.getArguments();
                    TupleEntryCollector outputCollector = functionCall.getOutputCollector();
                    outputCollector.add(input2.getCoercedTuple(Identity.this.types, this.result));
                }
            };
        } else {
            functor = new Functor(){

                @Override
                public void operate(FunctionCall<Functor> functionCall) {
                    TupleEntryCollector outputCollector = functionCall.getOutputCollector();
                    outputCollector.add(functionCall.getArguments().getTuple());
                }
            };
            operationCall.setContext(functor);
        }
        operationCall.setContext(functor);
    }

    @Override
    public void operate(FlowProcess flowProcess, FunctionCall<Functor> functionCall) {
        ((Functor)functionCall.getContext()).operate(functionCall);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Identity)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Identity identity = (Identity)object;
        return Arrays.equals(this.types, identity.types);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.types != null ? Arrays.hashCode(this.types) : 0);
        return result2;
    }

    static interface Functor {
        public void operate(FunctionCall<Functor> var1);
    }
}

