/*
 * Decompiled with CFR 0.152.
 */
package cascading.operation;

import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.operation.Assertion;
import cascading.operation.Filter;
import cascading.operation.Operation;
import cascading.operation.OperationCall;
import cascading.tuple.Fields;
import cascading.util.TraceUtil;
import cascading.util.Traceable;
import java.io.Serializable;

public abstract class BaseOperation<Context>
implements Serializable,
Operation<Context>,
Traceable {
    protected Fields fieldDeclaration;
    protected int numArgs = Integer.MAX_VALUE;
    protected String trace = TraceUtil.captureDebugTrace(this);

    protected BaseOperation() {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
    }

    protected BaseOperation(Fields fieldDeclaration) {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
        this.fieldDeclaration = fieldDeclaration;
        this.verify();
    }

    protected BaseOperation(int numArgs) {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
        this.numArgs = numArgs;
        this.verify();
    }

    protected BaseOperation(int numArgs, Fields fieldDeclaration) {
        this.fieldDeclaration = this instanceof Filter || this instanceof Assertion ? Fields.ALL : Fields.UNKNOWN;
        this.numArgs = numArgs;
        this.fieldDeclaration = fieldDeclaration;
        this.verify();
    }

    private final void verify() {
        if (this instanceof Filter && this.fieldDeclaration != Fields.ALL) {
            throw new IllegalArgumentException("fieldDeclaration must be set to Fields.ALL for filter operations");
        }
        if (this instanceof Assertion && this.fieldDeclaration != Fields.ALL) {
            throw new IllegalArgumentException("fieldDeclaration must be set to Fields.ALL for assertion operations");
        }
        if (this.fieldDeclaration == null) {
            throw new IllegalArgumentException("fieldDeclaration may not be null");
        }
        if (this.numArgs < 0) {
            throw new IllegalArgumentException("numArgs may not be negative");
        }
    }

    @Override
    public void prepare(FlowProcess flowProcess, OperationCall<Context> operationCall) {
    }

    @Override
    public void flush(FlowProcess flowProcess, OperationCall<Context> contextOperationCall) {
    }

    @Override
    public void cleanup(FlowProcess flowProcess, OperationCall<Context> operationCall) {
    }

    @Override
    public Fields getFieldDeclaration() {
        return this.fieldDeclaration;
    }

    @Override
    public int getNumArgs() {
        return this.numArgs;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public String getTrace() {
        return this.trace;
    }

    public String toString() {
        return BaseOperation.toStringInternal(this);
    }

    public static String toStringInternal(Operation operation) {
        StringBuilder buffer2 = new StringBuilder();
        Class<?> type = operation.getClass();
        if (type.getSimpleName().length() != 0) {
            buffer2.append(type.getSimpleName());
        } else {
            buffer2.append(type.getName());
        }
        if (operation.getFieldDeclaration() != null) {
            buffer2.append("[decl:").append(operation.getFieldDeclaration()).append("]");
        }
        if (operation.getNumArgs() != Integer.MAX_VALUE) {
            buffer2.append("[args:").append(operation.getNumArgs()).append("]");
        }
        return buffer2.toString();
    }

    public static void printOperationInternal(Operation operation, StringBuffer buffer2, Scope scope) {
        Class<?> type = operation.getClass();
        if (type.getSimpleName().length() != 0) {
            buffer2.append(type.getSimpleName());
        } else {
            buffer2.append(type.getName());
        }
        if (scope.getOperationDeclaredFields() != null) {
            buffer2.append("[decl:").append(scope.getOperationDeclaredFields().printVerbose()).append("]");
        }
        if (operation.getNumArgs() != Integer.MAX_VALUE) {
            buffer2.append("[args:").append(operation.getNumArgs()).append("]");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseOperation)) {
            return false;
        }
        BaseOperation that = (BaseOperation)object;
        if (this.numArgs != that.numArgs) {
            return false;
        }
        return !(this.fieldDeclaration != null ? !this.fieldDeclaration.equals(that.fieldDeclaration) : that.fieldDeclaration != null);
    }

    public int hashCode() {
        int result2 = this.fieldDeclaration != null ? this.fieldDeclaration.hashCode() : 0;
        result2 = 31 * result2 + this.numArgs;
        return result2;
    }
}

