/*
 * Decompiled with CFR 0.152.
 */
package cascading.management.state;

import cascading.management.CascadingServices;
import cascading.management.DocumentService;
import cascading.management.MetricsService;
import cascading.provider.CascadingService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseState
implements CascadingService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseState.class);
    private String id;
    MetricsService metricsService = new CascadingServices.NullMetricsService();
    DocumentService documentService = new CascadingServices.NullDocumentService();

    @Override
    public boolean isEnabled() {
        return this.metricsService.isEnabled() || this.documentService.isEnabled();
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
    }

    public void initialize(CascadingServices cascadingServices, String id) {
        this.id = id;
        if (cascadingServices == null) {
            return;
        }
        this.metricsService = cascadingServices.getMetricsService();
        this.documentService = cascadingServices.getDocumentService();
    }

    @Override
    public synchronized void startService() {
        if (!this.safelyStartService(this.metricsService)) {
            this.metricsService = new CascadingServices.NullMetricsService();
        }
        if (!this.safelyStartService(this.documentService)) {
            this.documentService = new CascadingServices.NullDocumentService();
        }
    }

    private boolean safelyStartService(CascadingService service) {
        try {
            service.startService();
            return true;
        }
        catch (Throwable throwable2) {
            LOG.warn("unable to start cascading service: {}, with message: {}", (Object)service.getClass().getName(), (Object)throwable2.getMessage());
            LOG.debug("with exception", throwable2);
            return false;
        }
    }

    @Override
    public void stopService() {
    }

    String[] getContext(Enum context) {
        return this.getContext(this.getGroup(context), context.toString());
    }

    String getGroup(Enum metric) {
        return metric.getClass().getSimpleName();
    }

    abstract String[] getContext(String var1, String var2);

    public String getID() {
        return this.id;
    }

    protected void store(String id, Object value2) {
        this.documentService.put(id, value2);
    }

    protected void setMetric(Enum metric, long value2) {
        this.metricsService.set(this.getContext(metric), value2);
    }

    protected void setMetric(String group2, String metric, long value2) {
        this.metricsService.set(this.getContext(group2, metric), value2);
    }

    protected void setMetric(String group2, String metric, String value2) {
        this.metricsService.set(this.getContext(group2, metric), value2);
    }

    private void incrementMetric(Enum metric, int value2) {
        this.metricsService.increment(this.getContext(metric), value2);
    }

    private void incrementMetric(String group2, String metric, int value2) {
        this.metricsService.increment(this.getContext(group2, metric), value2);
    }

    String[] asArray(String ... strings) {
        return strings;
    }
}

