/*
 * Decompiled with CFR 0.152.
 */
package cascading.management.annotation;

import cascading.management.annotation.Sanitizer;
import cascading.management.annotation.Visibility;
import cascading.util.Util;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URISanitizer
implements Sanitizer {
    private static final Logger LOG = LoggerFactory.getLogger(URISanitizer.class);
    public static final String PARAMETER_FILTER_PROPERTY = "cascading.management.annotation.urisanitizer.parameternames";
    public static final String FAILURE_MODE_PASS_THROUGH = "cascading.management.annotation.urisanitizer.failurepassthrough";
    private Set<String> parametersToFilter;

    public URISanitizer() {
        String parameterProperty = System.getProperty(PARAMETER_FILTER_PROPERTY);
        if (Util.isEmpty(parameterProperty)) {
            this.parametersToFilter = Collections.emptySet();
        } else {
            String[] parameterNames;
            this.parametersToFilter = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (String parameterName : parameterNames = parameterProperty.split(",")) {
                if (parameterName != null) {
                    parameterName = parameterName.trim();
                }
                if (Util.isEmpty(parameterName)) continue;
                this.parametersToFilter.add(parameterName);
            }
        }
    }

    @Override
    public String apply(Visibility visibility, Object value2) {
        URI uri;
        if (value2 == null) {
            return null;
        }
        if (value2 instanceof URI) {
            uri = (URI)value2;
        } else {
            try {
                uri = URI.create(value2.toString());
            }
            catch (IllegalArgumentException exception) {
                LOG.warn("failed to parse uri: {}", value2, (Object)exception);
                if (Boolean.parseBoolean(System.getProperty(FAILURE_MODE_PASS_THROUGH))) {
                    LOG.warn("ignoring failures, returning raw value");
                    return value2.toString();
                }
                return "";
            }
        }
        StringBuilder buffer2 = new StringBuilder();
        if (uri.getPath() != null) {
            buffer2.append(uri.getPath());
        }
        if ((visibility == Visibility.PROTECTED || visibility == Visibility.PRIVATE) && uri.getQuery() != null) {
            buffer2.append("?").append(this.sanitizeQuery(uri.getQuery()));
        }
        if (visibility == Visibility.PRIVATE) {
            String currentString = buffer2.toString();
            buffer2 = new StringBuilder();
            if (uri.getScheme() != null) {
                buffer2.append(uri.getScheme()).append("://");
            }
            if (uri.getAuthority() != null) {
                buffer2.append(uri.getAuthority());
            }
            buffer2.append(currentString);
        }
        return buffer2.toString();
    }

    private String sanitizeQuery(String query) {
        String[] parts;
        StringBuilder buffer2 = new StringBuilder();
        for (String part : parts = query.split("&")) {
            String[] keyValuePair = part.split("=");
            String key = keyValuePair[0];
            if (this.parametersToFilter.contains(key)) continue;
            buffer2.append(part).append("&");
        }
        return buffer2.toString();
    }
}

