/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowProcess;
import cascading.flow.StepCounters;
import cascading.flow.stream.DuctException;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.util.Util;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TrapHandler.class);
    static final Map<Tap, TupleEntryCollector> trapCollectors = new HashMap<Tap, TupleEntryCollector>();
    final FlowProcess flowProcess;
    final Tap trap;
    final String trapName;

    static TupleEntryCollector getTrapCollector(Tap trap, FlowProcess flowProcess) {
        TupleEntryCollector trapCollector = trapCollectors.get(trap);
        if (trapCollector == null) {
            try {
                trapCollector = flowProcess.openTrapForWrite(trap);
                trapCollectors.put(trap, trapCollector);
            }
            catch (IOException exception) {
                throw new DuctException(exception);
            }
        }
        return trapCollector;
    }

    static synchronized void closeTraps() {
        for (TupleEntryCollector trapCollector : trapCollectors.values()) {
            try {
                trapCollector.close();
            }
            catch (Exception exception) {}
        }
        trapCollectors.clear();
    }

    public TrapHandler(FlowProcess flowProcess) {
        this.flowProcess = flowProcess;
        this.trap = null;
        this.trapName = null;
    }

    public TrapHandler(FlowProcess flowProcess, Tap trap, String trapName) {
        this.flowProcess = flowProcess;
        this.trap = trap;
        this.trapName = trapName;
    }

    protected void handleReThrowableException(String message, Throwable throwable2) {
        LOG.error(message, throwable2);
        if (throwable2 instanceof Error) {
            throw (Error)throwable2;
        }
        if (throwable2 instanceof RuntimeException) {
            throw (RuntimeException)throwable2;
        }
        throw new DuctException(message, throwable2);
    }

    protected void handleException(Throwable exception, TupleEntry tupleEntry) {
        this.handleException(this.trapName, this.trap, exception, tupleEntry);
    }

    protected void handleException(String trapName, Tap trap, Throwable throwable2, TupleEntry tupleEntry) {
        Throwable cause = throwable2.getCause();
        if (cause instanceof OutOfMemoryError) {
            this.handleReThrowableException("caught OutOfMemoryException, will not trap, rethrowing", cause);
        }
        if (trap == null) {
            this.handleReThrowableException("caught Throwable, no trap available, rethrowing", throwable2);
        }
        if (cause instanceof TapException && ((TapException)cause).getPayload() != null) {
            TrapHandler.getTrapCollector(trap, this.flowProcess).add(((TapException)cause).getPayload());
        } else if (tupleEntry != null) {
            TrapHandler.getTrapCollector(trap, this.flowProcess).add(tupleEntry);
        } else {
            LOG.error("failure resolving tuple entry", throwable2);
            throw new DuctException("failure resolving tuple entry", throwable2);
        }
        this.flowProcess.increment(StepCounters.Tuples_Trapped, 1L);
        LOG.warn("exception trap on branch: '" + trapName + "', for " + Util.truncate(this.print(tupleEntry), 75), throwable2);
    }

    private String print(TupleEntry tupleEntry) {
        if (tupleEntry == null || tupleEntry.getFields() == null) {
            return "[uninitialized]";
        }
        if (tupleEntry.getTuple() == null) {
            return "fields: " + tupleEntry.getFields().printVerbose();
        }
        return "fields: " + tupleEntry.getFields().printVerbose() + " tuple: " + tupleEntry.getTuple().print();
    }
}

