/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.stream.CloseReducingDuct;
import cascading.flow.stream.Collapsing;
import cascading.flow.stream.Duct;
import cascading.flow.stream.DuctGraph;
import cascading.flow.stream.Fork;
import cascading.flow.stream.Gate;
import cascading.flow.stream.OpenDuct;
import cascading.flow.stream.OpenReducingDuct;
import cascading.flow.stream.OpenWindow;
import cascading.flow.stream.Reducing;
import cascading.flow.stream.Stage;
import cascading.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamGraph {
    public static final String ERROR_DOT_FILE_NAME = "cascading.stream.error.dotfile";
    public static final String DOT_FILE_PATH = "cascading.stream.dotfile.path";
    private static final Logger LOG = LoggerFactory.getLogger(StreamGraph.class);
    private final Duct HEAD = new Extent("head");
    private final Duct TAIL = new Extent("tail");
    private final DuctGraph graph = new DuctGraph();

    protected Object getProperty(String name2) {
        return null;
    }

    Duct getHEAD() {
        return this.HEAD;
    }

    Duct getTAIL() {
        return this.TAIL;
    }

    public void addHead(Duct head2) {
        this.addPath(this.getHEAD(), head2);
    }

    public void addTail(Duct tail) {
        this.addPath(tail, this.getTAIL());
    }

    public void addPath(Duct lhs, Duct rhs) {
        this.addPath(lhs, 0, rhs);
    }

    public void addPath(Duct lhs, int ordinal, Duct rhs) {
        if (lhs == null && rhs == null) {
            throw new IllegalArgumentException("both lhs and rhs may not be null");
        }
        if (lhs == this.getTAIL()) {
            throw new IllegalStateException("lhs may not be a TAIL");
        }
        if (rhs == this.getHEAD()) {
            throw new IllegalStateException("rhs may not be a HEAD");
        }
        if (lhs == null) {
            lhs = this.getHEAD();
        }
        if (rhs == null) {
            rhs = this.getTAIL();
        }
        try {
            this.graph.addVertex(lhs);
            this.graph.addVertex(rhs);
            this.graph.addEdge(lhs, rhs, this.graph.makeOrdinal(ordinal));
        }
        catch (RuntimeException exception) {
            LOG.error("unable to add path", exception);
            this.printGraphError();
            throw exception;
        }
    }

    public void bind() {
        TopologicalOrderIterator<Duct, Integer> iterator2 = this.getTopologicalOrderIterator();
        while (iterator2.hasNext()) {
            ((Duct)iterator2.next()).bind(this);
        }
        iterator2 = this.getReversedTopologicalOrderIterator();
        while (iterator2.hasNext()) {
            ((Duct)iterator2.next()).initialize();
        }
    }

    public void prepare() {
        TopologicalOrderIterator<Duct, Integer> iterator2 = this.getReversedTopologicalOrderIterator();
        while (iterator2.hasNext()) {
            ((Duct)iterator2.next()).prepare();
        }
    }

    public void cleanup() {
        TopologicalOrderIterator<Duct, Integer> iterator2 = this.getTopologicalOrderIterator();
        while (iterator2.hasNext()) {
            ((Duct)iterator2.next()).cleanup();
        }
    }

    public Collection<Duct> getHeads() {
        return Graphs.successorListOf(this.graph, this.getHEAD());
    }

    public Collection<Duct> getTails() {
        return Graphs.predecessorListOf(this.graph, this.getTAIL());
    }

    public Duct[] findAllNextFor(Duct current) {
        LinkedList<Duct> successors = new LinkedList<Duct>(Graphs.successorListOf(this.graph, current));
        ListIterator iterator2 = successors.listIterator();
        while (iterator2.hasNext()) {
            Duct successor = (Duct)iterator2.next();
            if (successor == this.getHEAD()) {
                throw new IllegalStateException("HEAD may not be next");
            }
            if (successor != this.getTAIL()) continue;
            iterator2.remove();
        }
        return successors.toArray(new Duct[successors.size()]);
    }

    public Duct[] findAllPreviousFor(Duct current) {
        LinkedList<Duct> predecessors2 = new LinkedList<Duct>(Graphs.predecessorListOf(this.graph, current));
        ListIterator iterator2 = predecessors2.listIterator();
        while (iterator2.hasNext()) {
            Duct successor = (Duct)iterator2.next();
            if (successor == this.getTAIL()) {
                throw new IllegalStateException("TAIL may not be successor");
            }
            if (successor != this.getHEAD()) continue;
            iterator2.remove();
        }
        return predecessors2.toArray(new Duct[predecessors2.size()]);
    }

    public Duct createNextFor(Duct current) {
        if (current == this.getHEAD() || current == this.getTAIL()) {
            return null;
        }
        Set edges2 = this.graph.outgoingEdgesOf(current);
        if (edges2.size() == 0) {
            throw new IllegalStateException("ducts must have an outgoing edge, current: " + current);
        }
        Duct next2 = (Duct)this.graph.getEdgeTarget(edges2.iterator().next());
        if (current instanceof Gate) {
            if (next2 instanceof OpenWindow) {
                return next2;
            }
            if (edges2.size() > 1) {
                return this.createOpenWindow(this.createFork(this.findAllNextFor(current)));
            }
            if (next2 instanceof Reducing) {
                return this.createOpenReducingWindow(next2);
            }
            return this.createOpenWindow(next2);
        }
        if (current instanceof Reducing) {
            if (next2 instanceof Reducing) {
                return next2;
            }
            if (edges2.size() > 1) {
                return this.createCloseWindow(this.createFork(this.findAllNextFor(current)));
            }
            return this.createCloseWindow(next2);
        }
        if (edges2.size() > 1) {
            return this.createFork(this.findAllNextFor(current));
        }
        if (next2 == this.getTAIL()) {
            throw new IllegalStateException("tail ducts should not bind to next");
        }
        return next2;
    }

    private Duct createCloseWindow(Duct next2) {
        return new CloseReducingDuct(next2);
    }

    protected Duct createOpenWindow(Duct next2) {
        return new OpenDuct(next2);
    }

    protected Duct createOpenReducingWindow(Duct next2) {
        return new OpenReducingDuct(next2);
    }

    protected Duct createFork(Duct[] allNext) {
        return new Fork(allNext);
    }

    public int countAllEventingPathsTo(Duct duct) {
        LinkedList<List<Duct>> allPaths2 = StreamGraph.asPathList(this.allPathsBetweenInclusive(this.getHEAD(), duct));
        HashSet<Duct> nearestCollapsed = new HashSet<Duct>();
        block0: for (List list2 : allPaths2) {
            Collections.reverse(list2);
            list2.remove(0);
            for (Duct element : list2) {
                if (!(element instanceof Collapsing)) continue;
                nearestCollapsed.add(element);
                continue block0;
            }
        }
        LinkedList<List<Duct>> collapsedPaths = new LinkedList<List<Duct>>(allPaths2);
        ListIterator listIterator = collapsedPaths.listIterator();
        while (listIterator.hasNext()) {
            List path = (List)listIterator.next();
            if (!Collections.disjoint(path, nearestCollapsed)) continue;
            listIterator.remove();
        }
        int collapsedPathsCount = 0;
        for (Duct collapsed : nearestCollapsed) {
            LinkedList<List<Duct>> subPaths = StreamGraph.asPathList(this.allPathsBetweenInclusive(collapsed, duct));
            for (List list3 : subPaths) {
                list3.remove(0);
                if (!Collections.disjoint(list3, nearestCollapsed)) continue;
                ++collapsedPathsCount;
            }
        }
        int nonCollapsedPathsCount = allPaths2.size() - collapsedPaths.size();
        return nonCollapsedPathsCount + collapsedPathsCount;
    }

    public int ordinalBetween(Duct lhs, Duct rhs) {
        return ((DuctGraph.Ordinal)this.graph.getEdge(lhs, rhs)).ordinal;
    }

    private List<GraphPath<Duct, DuctGraph.Ordinal>> allPathsBetweenInclusive(Duct from2, Duct to2) {
        return new KShortestPaths<Duct, DuctGraph.Ordinal>(this.graph, from2, Integer.MAX_VALUE).getPaths(to2);
    }

    public static LinkedList<List<Duct>> asPathList(List<GraphPath<Duct, DuctGraph.Ordinal>> paths) {
        LinkedList<List<Duct>> results2 = new LinkedList<List<Duct>>();
        if (paths == null) {
            return results2;
        }
        for (GraphPath<Duct, DuctGraph.Ordinal> path : paths) {
            results2.add(Graphs.getPathVertexList(path));
        }
        return results2;
    }

    public TopologicalOrderIterator<Duct, Integer> getTopologicalOrderIterator() {
        try {
            return new TopologicalOrderIterator<Duct, DuctGraph.Ordinal>(this.graph);
        }
        catch (RuntimeException exception) {
            LOG.error("failed creating topological iterator", exception);
            this.printGraphError();
            throw exception;
        }
    }

    public TopologicalOrderIterator<Duct, Integer> getReversedTopologicalOrderIterator() {
        try {
            return new TopologicalOrderIterator<Duct, Integer>(this.getReversedGraph());
        }
        catch (RuntimeException exception) {
            LOG.error("failed creating reversed topological iterator", exception);
            this.printGraphError();
            throw exception;
        }
    }

    public DirectedGraph getReversedGraph() {
        DuctGraph reversedGraph = new DuctGraph();
        Graphs.addGraphReversed(reversedGraph, this.graph);
        return reversedGraph;
    }

    public Collection<Duct> getAllDucts() {
        return this.graph.vertexSet();
    }

    public void printGraphError() {
        String filename = (String)this.getProperty(ERROR_DOT_FILE_NAME);
        if (filename == null) {
            return;
        }
        this.printGraph(filename);
    }

    public void printGraph(String id, String classifier, int discriminator) {
        String path = (String)this.getProperty(DOT_FILE_PATH);
        if (path == null) {
            return;
        }
        path = String.format("%s/streamgraph-%s-%s-%s.dot", path, id, classifier, discriminator);
        this.printGraph(path);
    }

    public void printGraph(String filename) {
        LOG.info("writing stream graph to {}", (Object)filename);
        Util.printGraph(filename, (SimpleDirectedGraph)this.graph);
    }

    private class Extent
    extends Stage {
        final String name;

        private Extent(String name2) {
            this.name = name2;
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

