/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.ElementGraphs;
import cascading.flow.planner.Scope;
import cascading.flow.stream.AggregatorEveryStage;
import cascading.flow.stream.BufferEveryWindow;
import cascading.flow.stream.Duct;
import cascading.flow.stream.ElementDuct;
import cascading.flow.stream.FilterEachStage;
import cascading.flow.stream.FunctionEachStage;
import cascading.flow.stream.Gate;
import cascading.flow.stream.GroupAssertionEveryStage;
import cascading.flow.stream.MemoryCoGroupGate;
import cascading.flow.stream.MemoryHashJoinGate;
import cascading.flow.stream.MergeStage;
import cascading.flow.stream.SinkStage;
import cascading.flow.stream.SourceStage;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StreamGraph;
import cascading.flow.stream.TrapHandler;
import cascading.flow.stream.ValueAssertionEachStage;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tap.Tap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jgrapht.GraphPath;

public abstract class StepStreamGraph
extends StreamGraph {
    protected FlowProcess flowProcess;
    protected final BaseFlowStep step;

    public StepStreamGraph(FlowProcess flowProcess, BaseFlowStep step) {
        this.flowProcess = flowProcess;
        this.step = step;
    }

    @Override
    protected Object getProperty(String name2) {
        return this.flowProcess.getProperty(name2);
    }

    protected void handleDuct(FlowElement lhsElement, Duct lhsDuct) {
        List<FlowElement> successors = this.step.getSuccessors(lhsElement);
        if (!this.stopOnElement(lhsElement, successors)) {
            this.handleSuccessors(lhsDuct, successors);
        } else {
            this.addTail(lhsDuct);
        }
    }

    protected abstract boolean stopOnElement(FlowElement var1, List<FlowElement> var2);

    private void handleSuccessors(Duct lhsDuct, List<FlowElement> successors) {
        for (FlowElement rhsElement : successors) {
            Duct newRhsDuct = this.createDuctFor(rhsElement);
            Duct rhsDuct = this.findExisting(newRhsDuct);
            int ordinal = this.findEdgeOrdinal(lhsDuct, rhsDuct);
            this.addPath(lhsDuct, ordinal, rhsDuct);
            if (rhsDuct != newRhsDuct) continue;
            this.handleDuct(rhsElement, rhsDuct);
        }
    }

    private int findEdgeOrdinal(Duct lhsDuct, Duct rhsDuct) {
        if (!(rhsDuct instanceof SpliceGate)) {
            return 0;
        }
        FlowElement lhsElement = ((ElementDuct)((Object)lhsDuct)).getFlowElement();
        Splice rhsElement = (Splice)((SpliceGate)rhsDuct).getFlowElement();
        List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllShortestPathsBetween(this.step.getGraph(), lhsElement, rhsElement);
        for (GraphPath<FlowElement, Scope> path : paths) {
            if (path.getEdgeList().size() != 1) continue;
            return rhsElement.getPipePos().get(path.getEdgeList().get(0).getName());
        }
        throw new IllegalStateException("could not find ordinal");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Duct createDuctFor(FlowElement element) {
        void var2_19;
        if (element instanceof Each) {
            Each eachElement = (Each)element;
            if (eachElement.isFunction()) {
                FunctionEachStage functionEachStage = new FunctionEachStage(this.flowProcess, eachElement);
                return var2_19;
            } else if (eachElement.isFilter()) {
                FilterEachStage filterEachStage = new FilterEachStage(this.flowProcess, eachElement);
                return var2_19;
            } else {
                if (!eachElement.isValueAssertion()) throw new IllegalStateException("unknown operation: " + eachElement.getOperation().getClass().getCanonicalName());
                ValueAssertionEachStage valueAssertionEachStage = new ValueAssertionEachStage(this.flowProcess, eachElement);
            }
            return var2_19;
        } else if (element instanceof Every) {
            Every everyElement = (Every)element;
            if (everyElement.isBuffer()) {
                BufferEveryWindow bufferEveryWindow = new BufferEveryWindow(this.flowProcess, everyElement);
                return var2_19;
            } else if (everyElement.isAggregator()) {
                AggregatorEveryStage aggregatorEveryStage = new AggregatorEveryStage(this.flowProcess, everyElement);
                return var2_19;
            } else {
                if (!everyElement.isGroupAssertion()) throw new IllegalStateException("unknown operation: " + everyElement.getOperation().getClass().getCanonicalName());
                GroupAssertionEveryStage groupAssertionEveryStage = new GroupAssertionEveryStage(this.flowProcess, everyElement);
            }
            return var2_19;
        } else if (element instanceof Splice) {
            Splice spliceElement = (Splice)element;
            if (spliceElement.isGroupBy()) {
                Gate gate = this.createGroupByGate((GroupBy)spliceElement);
                return var2_19;
            } else if (spliceElement.isCoGroup()) {
                Gate gate = this.createCoGroupGate((CoGroup)spliceElement);
                return var2_19;
            } else if (spliceElement.isMerge()) {
                Duct duct = this.createMergeStage((Merge)element);
                return var2_19;
            } else {
                Gate gate = this.createHashJoinGate((HashJoin)element);
            }
            return var2_19;
        } else {
            if (!(element instanceof Tap)) throw new IllegalStateException("unknown element type: " + element.getClass().getName());
            SinkStage sinkStage = this.createSinkStage((Tap)element);
        }
        return var2_19;
    }

    protected SinkStage createSinkStage(Tap element) {
        return new SinkStage(this.flowProcess, element);
    }

    protected abstract Gate createCoGroupGate(CoGroup var1);

    protected abstract Gate createGroupByGate(GroupBy var1);

    protected Duct createMergeStage(Merge merge2) {
        return new MergeStage(this.flowProcess, merge2);
    }

    protected Gate createHashJoinGate(HashJoin join2) {
        if (join2.getNumSelfJoins() != 0) {
            return this.createBlockingJoinGate(join2);
        }
        if (this.joinHasSameStreamedSource(join2)) {
            return this.createBlockingJoinGate(join2);
        }
        return this.createNonBlockingJoinGate(join2);
    }

    protected MemoryHashJoinGate createNonBlockingJoinGate(HashJoin join2) {
        return new MemoryHashJoinGate(this.flowProcess, join2);
    }

    protected MemoryCoGroupGate createBlockingJoinGate(HashJoin join2) {
        return new MemoryCoGroupGate(this.flowProcess, join2);
    }

    private boolean joinHasSameStreamedSource(HashJoin join2) {
        if (!this.step.getStreamedSourceByJoin().isEmpty()) {
            Tap tap = this.step.getStreamedSourceByJoin().get(join2);
            return this.getNumImmediateBranches(tap, join2) > 1;
        }
        for (Tap tap : this.step.getSources()) {
            if (this.getNumImmediateBranches(tap, join2) <= 1) continue;
            return true;
        }
        return false;
    }

    private int getNumImmediateBranches(FlowElement tap, HashJoin join2) {
        return ElementGraphs.getAllShortestPathsBetween(this.step.getGraph(), tap, join2).size();
    }

    protected Duct findExisting(Duct current) {
        Collection<Duct> allDucts = this.getAllDucts();
        for (Duct duct : allDucts) {
            if (!duct.equals(current)) continue;
            return duct;
        }
        return current;
    }

    protected void setTraps() {
        Collection<Duct> ducts = this.getAllDucts();
        for (Duct duct : ducts) {
            if (!(duct instanceof ElementDuct)) continue;
            ElementDuct elementDuct = (ElementDuct)((Object)duct);
            FlowElement flowElement = elementDuct.getFlowElement();
            TreeSet<String> branchNames = new TreeSet<String>();
            if (flowElement instanceof Pipe) {
                branchNames.add(((Pipe)flowElement).getName());
            } else if (flowElement instanceof Tap) {
                branchNames.addAll(this.getTapBranchNamesFor(duct));
            } else {
                throw new IllegalStateException("unexpected duct type" + duct.getClass().getCanonicalName());
            }
            elementDuct.setBranchNames(branchNames);
            for (String branchName : branchNames) {
                Tap trap = this.step.getTrap(branchName);
                if (trap == null) continue;
                elementDuct.setTrapHandler(new TrapHandler(this.flowProcess, trap, branchName));
                break;
            }
            if (elementDuct.hasTrapHandler()) continue;
            elementDuct.setTrapHandler(new TrapHandler(this.flowProcess));
        }
    }

    private Set<String> getTapBranchNamesFor(Duct duct) {
        if (duct instanceof SourceStage) {
            return this.step.getSourceName((Tap)((SourceStage)duct).getFlowElement());
        }
        if (duct instanceof SinkStage) {
            return this.step.getSinkName((Tap)((SinkStage)duct).getFlowElement());
        }
        throw new IllegalStateException("duct does not wrap a Tap: " + duct.getClass().getCanonicalName());
    }

    protected void setScopes() {
        Collection<Duct> ducts = this.getAllDucts();
        for (Duct duct : ducts) {
            if (!(duct instanceof ElementDuct)) continue;
            ElementDuct elementDuct = (ElementDuct)((Object)duct);
            elementDuct.getIncomingScopes().addAll(this.step.getPreviousScopes(elementDuct.getFlowElement()));
            elementDuct.getOutgoingScopes().addAll(this.step.getNextScopes(elementDuct.getFlowElement()));
        }
    }
}

