/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.Collapsing;
import cascading.flow.stream.Duct;
import cascading.flow.stream.ElementDuct;
import cascading.flow.stream.ElementFlowProcess;
import cascading.flow.stream.Gate;
import cascading.flow.stream.Grouping;
import cascading.flow.stream.StreamGraph;
import cascading.flow.stream.TrapHandler;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryChainIterator;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.Tuples;
import cascading.tuple.util.TupleBuilder;
import cascading.tuple.util.TupleViews;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpliceGate
extends Gate<TupleEntry, Grouping<TupleEntry, TupleEntryIterator>>
implements ElementDuct,
Collapsing {
    private static final Logger LOG = LoggerFactory.getLogger(SpliceGate.class);
    protected Duct[] orderedPrevious;
    protected final FlowProcess flowProcess;
    protected Role role = Role.both;
    private TrapHandler trapHandler;
    private Set<String> branchNames;
    protected final Splice splice;
    protected final List<Scope> incomingScopes = new ArrayList<Scope>();
    protected final List<Scope> outgoingScopes = new ArrayList<Scope>();
    protected Fields[] keyFields;
    protected Fields[] sortFields;
    protected Fields[] valuesFields;
    protected TupleBuilder[] keyBuilder;
    protected TupleBuilder[] valuesBuilder;
    protected TupleBuilder[] sortBuilder;
    protected Grouping<TupleEntry, TupleEntryIterator> grouping;
    protected TupleEntry keyEntry;
    protected TupleEntryChainIterator tupleEntryIterator;

    public SpliceGate(FlowProcess flowProcess, Splice splice) {
        this.splice = splice;
        Pipe element = splice;
        while (element != null) {
            if (element.hasConfigDef()) {
                flowProcess = new ElementFlowProcess(flowProcess, element.getConfigDef());
            }
            element = ((Pipe)element).getParent();
        }
        this.flowProcess = flowProcess;
    }

    public SpliceGate(FlowProcess flowProcess, Splice splice, Role role) {
        this.splice = splice;
        this.flowProcess = flowProcess;
        this.role = role;
    }

    @Override
    public void setBranchNames(Set<String> branchNames) {
        this.branchNames = branchNames;
    }

    @Override
    public Set<String> getBranchNames() {
        return this.branchNames;
    }

    @Override
    public void setTrapHandler(TrapHandler trapHandler) {
        this.trapHandler = trapHandler;
    }

    @Override
    public boolean hasTrapHandler() {
        return this.trapHandler != null;
    }

    protected void handleReThrowableException(String message, Throwable throwable2) {
        this.trapHandler.handleReThrowableException(message, throwable2);
    }

    protected void handleException(Throwable exception, TupleEntry tupleEntry) {
        this.trapHandler.handleException(exception, tupleEntry);
    }

    protected TupleBuilder createNarrowBuilder(final Fields incomingFields, final Fields narrowFields) {
        if (narrowFields.isNone()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return Tuple.NULL;
                }
            };
        }
        if (incomingFields.isUnknown()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return input2.get(incomingFields, narrowFields);
                }
            };
        }
        if (narrowFields.isAll()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return input2;
                }
            };
        }
        return this.createDefaultNarrowBuilder(incomingFields, narrowFields);
    }

    protected TupleBuilder createDefaultNarrowBuilder(final Fields incomingFields, final Fields narrowFields) {
        return new TupleBuilder(){
            Tuple result;
            {
                this.result = TupleViews.createNarrow(incomingFields.getPos(narrowFields));
            }

            @Override
            public Tuple makeResult(Tuple input2, Tuple output) {
                return TupleViews.reset(this.result, input2);
            }
        };
    }

    protected TupleBuilder createNulledBuilder(final Fields incomingFields, final Fields keyField) {
        if (incomingFields.isUnknown()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return Tuples.nulledCopy(incomingFields, input2, keyField);
                }
            };
        }
        if (keyField.isNone()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return input2;
                }
            };
        }
        if (keyField.isAll()) {
            return new TupleBuilder(){
                Tuple nullTuple;
                {
                    this.nullTuple = Tuple.size(incomingFields.size());
                }

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return this.nullTuple;
                }
            };
        }
        return new TupleBuilder(){
            Tuple nullTuple;
            Tuple result;
            {
                this.nullTuple = Tuple.size(keyField.size());
                this.result = TupleViews.createOverride(incomingFields, keyField);
            }

            @Override
            public Tuple makeResult(Tuple baseTuple, Tuple output) {
                return TupleViews.reset(this.result, baseTuple, this.nullTuple);
            }
        };
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.incomingScopes.size() == 0) {
            throw new IllegalStateException("incoming scopes may not be empty");
        }
        if (this.outgoingScopes.size() == 0) {
            throw new IllegalStateException("outgoing scope may not be empty");
        }
        int size2 = this.splice.isGroupBy() ? 1 : this.incomingScopes.size();
        this.keyFields = new Fields[size2];
        this.valuesFields = new Fields[size2];
        this.keyBuilder = new TupleBuilder[size2];
        this.valuesBuilder = new TupleBuilder[size2];
        if (this.splice.isSorted()) {
            this.sortFields = new Fields[size2];
            this.sortBuilder = new TupleBuilder[size2];
        }
        Scope outgoingScope = this.outgoingScopes.get(0);
        for (int i = 0; i < size2; ++i) {
            Scope incomingScope = this.incomingScopes.get(i);
            int pos = this.splice.isGroupBy() ? 0 : this.splice.getPipePos().get(incomingScope.getName());
            this.keyFields[pos] = outgoingScope.getKeySelectors().get(incomingScope.getName());
            this.valuesFields[pos] = incomingScope.getIncomingSpliceFields();
            this.keyBuilder[pos] = this.createNarrowBuilder(incomingScope.getIncomingSpliceFields(), this.keyFields[pos]);
            this.valuesBuilder[pos] = this.createNulledBuilder(incomingScope.getIncomingSpliceFields(), this.keyFields[pos]);
            if (this.sortFields != null) {
                this.sortFields[pos] = outgoingScope.getSortingSelectors().get(incomingScope.getName());
                this.sortBuilder[pos] = this.createNarrowBuilder(incomingScope.getIncomingSpliceFields(), this.sortFields[pos]);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("incomingScope: {}, in pos: {}", (Object)incomingScope.getName(), (Object)pos);
            LOG.debug("keyFields: {}", (Object)this.printSafe(this.keyFields[pos]));
            LOG.debug("valueFields: {}", (Object)this.printSafe(this.valuesFields[pos]));
            if (this.sortFields == null) continue;
            LOG.debug("sortFields: {}", (Object)this.printSafe(this.sortFields[pos]));
        }
        if (this.role == Role.sink) {
            return;
        }
        this.keyEntry = new TupleEntry(outgoingScope.getOutGroupingFields(), true);
        this.tupleEntryIterator = new TupleEntryChainIterator(outgoingScope.getOutValuesFields(), new Iterator[0]);
        this.grouping = new Grouping();
        this.grouping.key = this.keyEntry;
        this.grouping.joinIterator = this.tupleEntryIterator;
    }

    @Override
    public FlowElement getFlowElement() {
        return this.splice;
    }

    @Override
    public List<Scope> getOutgoingScopes() {
        return this.outgoingScopes;
    }

    @Override
    public List<Scope> getIncomingScopes() {
        return this.incomingScopes;
    }

    @Override
    public void addIncomingScope(Scope incomingScope) {
        this.incomingScopes.add(incomingScope);
    }

    @Override
    public void addOutgoingScope(Scope outgoingScope) {
        this.outgoingScopes.add(outgoingScope);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this.next == null) {
            TrapHandler.closeTraps();
        }
    }

    protected synchronized void orderDucts(StreamGraph streamGraph) {
        this.orderedPrevious = new Duct[this.incomingScopes.size()];
        if (this.incomingScopes.size() == 1 && this.splice.getPrevious().length == 1) {
            this.orderedPrevious[0] = this.allPrevious[0];
            return;
        }
        Duct[] arr$ = this.allPrevious;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Duct previous;
            this.orderedPrevious[streamGraph.ordinalBetween((Duct)previous, (Duct)this)] = previous = arr$[i$];
        }
    }

    protected void makePosMap(Map<Duct, Integer> posMap) {
        for (int i = 0; i < this.orderedPrevious.length; ++i) {
            if (this.orderedPrevious[i] == null) continue;
            posMap.put(this.orderedPrevious[i], i);
        }
    }

    private String printSafe(Fields fields2) {
        if (fields2 != null) {
            return fields2.printVerbose();
        }
        return "";
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SpliceGate)) {
            return false;
        }
        SpliceGate spliceGate = (SpliceGate)object;
        return !(this.splice != null ? this.splice != spliceGate.splice : spliceGate.splice != null);
    }

    public final int hashCode() {
        return this.splice != null ? System.identityHashCode(this.splice) : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{splice=").append(this.splice);
        sb.append('}');
        return sb.toString();
    }

    public static enum Role {
        sink,
        source,
        both;

    }
}

