/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import java.util.Comparator;

public class SparseTupleComparator
implements Comparator<Tuple> {
    private static final Comparator DEFAULT = new NaturalComparator();
    final Comparator[] comparators;
    final int[] posMap;

    public SparseTupleComparator(Fields valuesField, Fields sortFields) {
        this(valuesField, sortFields, null);
    }

    public SparseTupleComparator(Fields groupFields, Comparator defaultComparator) {
        this(groupFields, groupFields, defaultComparator);
    }

    public SparseTupleComparator(Fields valuesFields, Fields sortFields, Comparator defaultComparator) {
        if (defaultComparator == null) {
            defaultComparator = DEFAULT;
        }
        int size2 = valuesFields != null && !valuesFields.isUnknown() ? valuesFields.size() : sortFields.size();
        this.comparators = new Comparator[size2];
        this.posMap = new int[size2];
        Comparator[] sortFieldComparators = sortFields.getComparators();
        for (int i = 0; i < sortFields.size(); ++i) {
            Comparable field2 = sortFields.get(i);
            int pos = valuesFields != null ? valuesFields.getPos(field2) : i;
            this.comparators[i] = sortFieldComparators[i];
            this.posMap[i] = pos;
            if (this.comparators[i] != null) continue;
            this.comparators[i] = defaultComparator;
        }
    }

    public Comparator[] getComparators() {
        return this.comparators;
    }

    @Override
    public int compare(Tuple lhs, Tuple rhs) {
        for (int i = 0; i < this.comparators.length; ++i) {
            int pos;
            int c;
            Comparator comparator = this.comparators[i];
            if (comparator == null || (c = comparator.compare(lhs.getObject(pos = this.posMap[i]), rhs.getObject(pos))) == 0) continue;
            return c;
        }
        return 0;
    }

    private static class NaturalComparator
    implements Comparator<Object> {
        private NaturalComparator() {
        }

        @Override
        public int compare(Object lhs, Object rhs) {
            if (lhs == null && rhs == null) {
                return 0;
            }
            if (lhs == null) {
                return -1;
            }
            if (rhs == null) {
                return 1;
            }
            return ((Comparable)lhs).compareTo(rhs);
        }
    }
}

