/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.StepCounters;
import cascading.flow.stream.Duct;
import cascading.flow.stream.DuctException;
import cascading.flow.stream.ElementStage;
import cascading.tap.Tap;
import cascading.tuple.TupleEntry;
import java.io.Closeable;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceStage
extends ElementStage<Void, TupleEntry>
implements Callable<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(SourceStage.class);
    private final Tap source;

    public SourceStage(FlowProcess flowProcess, Tap source2) {
        super(flowProcess, source2);
        this.source = source2;
    }

    @Override
    public Throwable call() throws Exception {
        return this.map(null);
    }

    public void run(Object input2) throws Throwable {
        Throwable throwable2 = this.map(input2);
        if (throwable2 != null) {
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Throwable map(Object input2) {
        Throwable localThrowable = null;
        Closeable iterator2 = null;
        try {
            this.next.start(this);
            iterator2 = this.source.openForRead(this.flowProcess, input2);
            while (iterator2.hasNext()) {
                TupleEntry tupleEntry;
                try {
                    tupleEntry = (TupleEntry)iterator2.next();
                    this.flowProcess.increment(StepCounters.Tuples_Read, 1L);
                    this.flowProcess.increment(SliceCounters.Tuples_Read, 1L);
                }
                catch (OutOfMemoryError error2) {
                    this.handleReThrowableException("out of memory, try increasing task memory allocation", error2);
                    continue;
                }
                catch (CascadingException exception) {
                    this.handleException(exception, null);
                    continue;
                }
                catch (Throwable throwable2) {
                    this.handleException(new DuctException("internal error", throwable2), null);
                    continue;
                }
                this.next.receive(this, tupleEntry);
            }
            this.next.complete(this);
        }
        catch (Throwable throwable3) {
            if (!(throwable3 instanceof OutOfMemoryError)) {
                LOG.error("caught throwable", throwable3);
            }
            Throwable throwable4 = throwable3;
            return throwable4;
        }
        finally {
            try {
                if (iterator2 != null) {
                    iterator2.close();
                }
            }
            catch (Throwable currentThrowable) {
                if (!(currentThrowable instanceof OutOfMemoryError)) {
                    LOG.warn("failed closing iterator", currentThrowable);
                }
                localThrowable = currentThrowable;
            }
        }
        return localThrowable;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void receive(Duct previous, Void nada) {
        throw new UnsupportedOperationException("use call() instead");
    }
}

