/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.StepCounters;
import cascading.flow.stream.Duct;
import cascading.flow.stream.DuctException;
import cascading.flow.stream.ElementStage;
import cascading.flow.stream.StreamGraph;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import java.io.IOException;

public class SinkStage
extends ElementStage<TupleEntry, Void> {
    private final Tap sink;
    private TupleEntryCollector collector;

    public SinkStage(FlowProcess flowProcess, Tap sink2) {
        super(flowProcess, sink2);
        this.sink = sink2;
    }

    @Override
    public void bind(StreamGraph streamGraph) {
    }

    @Override
    public void prepare() {
        try {
            this.collector = this.sink.openForWrite(this.flowProcess, this.getOutput());
            if (this.sink.getSinkFields().isAll()) {
                Fields fields2 = this.getIncomingScopes().get(0).getIncomingTapFields();
                this.collector.setFields(fields2);
            }
        }
        catch (IOException exception) {
            throw new DuctException("failed opening sink", exception);
        }
    }

    protected Object getOutput() {
        return null;
    }

    @Override
    public void start(Duct previous) {
    }

    @Override
    public void receive(Duct previous, TupleEntry tupleEntry) {
        try {
            this.collector.add(tupleEntry);
            this.flowProcess.increment(StepCounters.Tuples_Written, 1L);
            this.flowProcess.increment(SliceCounters.Tuples_Written, 1L);
        }
        catch (OutOfMemoryError error2) {
            this.handleReThrowableException("out of memory, try increasing task memory allocation", error2);
        }
        catch (CascadingException exception) {
            this.handleException(exception, tupleEntry);
        }
        catch (Throwable throwable2) {
            this.handleException(new DuctException("internal error: " + tupleEntry.getTuple().print(), throwable2), tupleEntry);
        }
    }

    @Override
    public void complete(Duct previous) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        try {
            if (this.collector != null) {
                this.collector.close();
            }
            this.collector = null;
        }
        finally {
            super.cleanup();
        }
    }
}

