/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.Duct;
import cascading.flow.stream.ElementStage;
import cascading.operation.ConcreteCall;
import cascading.pipe.Operator;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.util.TupleBuilder;
import cascading.tuple.util.TupleViews;

public abstract class OperatorStage<Incoming>
extends ElementStage<Incoming, TupleEntry> {
    public static final String RETAIN_COLLECTOR = "cascading.compatibility.retain.collector";
    protected ConcreteCall operationCall;
    protected TupleEntry incomingEntry;
    protected Fields argumentsSelector;
    protected TupleEntry argumentsEntry;
    protected Fields remainderFields;
    protected Fields outgoingSelector;
    protected TupleEntry outgoingEntry;
    protected TupleBuilder argumentsBuilder;
    protected TupleBuilder outgoingBuilder;
    private final boolean retainCollector;
    protected TupleEntryCollector outputCollector;

    public OperatorStage(FlowProcess flowProcess, FlowElement flowElement) {
        super(flowProcess, flowElement);
        this.retainCollector = Boolean.parseBoolean(flowProcess.getStringProperty(RETAIN_COLLECTOR));
    }

    public abstract Operator getOperator();

    protected abstract Fields getOutgoingSelector();

    protected Fields getOperationDeclaredFields() {
        return ((Scope)this.outgoingScopes.get(0)).getOperationDeclaredFields();
    }

    protected abstract Fields getIncomingPassThroughFields();

    protected abstract Fields getIncomingArgumentsFields();

    protected TupleBuilder createArgumentsBuilder(final Fields incomingFields, final Fields argumentsSelector) {
        if (incomingFields.isUnknown()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return input2.get(incomingFields, argumentsSelector);
                }
            };
        }
        if (argumentsSelector.isAll()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return input2;
                }
            };
        }
        if (argumentsSelector.isNone()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return Tuple.NULL;
                }
            };
        }
        final Fields inputDeclarationFields = Fields.asDeclaration(incomingFields);
        return new TupleBuilder(){
            Tuple result;
            {
                this.result = TupleViews.createNarrow(inputDeclarationFields.getPos(argumentsSelector));
            }

            @Override
            public Tuple makeResult(Tuple input2, Tuple output) {
                return TupleViews.reset(this.result, input2);
            }
        };
    }

    protected TupleBuilder createOutgoingBuilder(final Operator operator, final Fields incomingFields, final Fields argumentSelector, final Fields remainderFields, final Fields declaredFields, final Fields outgoingSelector) {
        final Fields inputDeclarationFields = Fields.asDeclaration(incomingFields);
        if (operator.getOutputSelector().isResults()) {
            return new TupleBuilder(){

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return output;
                }
            };
        }
        if (operator.getOutputSelector().isAll() && !incomingFields.isUnknown() && !declaredFields.isUnknown()) {
            return new TupleBuilder(){
                Tuple result;
                {
                    this.result = TupleViews.createComposite(inputDeclarationFields, declaredFields);
                }

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return TupleViews.reset(this.result, input2, output);
                }
            };
        }
        if (operator.getOutputSelector().isReplace()) {
            if (incomingFields.isUnknown()) {
                return new TupleBuilder(){
                    Fields resultFields;
                    {
                        this.resultFields = operator.getFieldDeclaration().isArguments() ? argumentSelector : declaredFields;
                    }

                    @Override
                    public Tuple makeResult(Tuple input2, Tuple output) {
                        Tuple result2 = new Tuple(input2);
                        result2.set(Fields.UNKNOWN, this.resultFields, output);
                        return result2;
                    }
                };
            }
            return new TupleBuilder(){
                Fields resultFields;
                Tuple result;
                {
                    this.resultFields = operator.getFieldDeclaration().isArguments() ? argumentSelector : declaredFields;
                    this.result = TupleViews.createOverride(inputDeclarationFields, this.resultFields);
                }

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    return TupleViews.reset(this.result, input2, output);
                }
            };
        }
        if (operator.getOutputSelector().isSwap()) {
            if (remainderFields.size() == 0) {
                return new TupleBuilder(){

                    @Override
                    public Tuple makeResult(Tuple input2, Tuple output) {
                        return output;
                    }
                };
            }
            if (declaredFields.isUnknown()) {
                return new TupleBuilder(){

                    @Override
                    public Tuple makeResult(Tuple input2, Tuple output) {
                        return input2.get(incomingFields, remainderFields).append(output);
                    }
                };
            }
            return new TupleBuilder(){
                Tuple view;
                Tuple result;
                {
                    this.view = TupleViews.createNarrow(inputDeclarationFields.getPos(remainderFields));
                    this.result = TupleViews.createComposite(Fields.asDeclaration(remainderFields), declaredFields);
                }

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    TupleViews.reset(this.view, input2);
                    return TupleViews.reset(this.result, this.view, output);
                }
            };
        }
        if (incomingFields.isUnknown() || declaredFields.isUnknown()) {
            return new TupleBuilder(){
                Fields selector;
                TupleEntry incoming;
                TupleEntry declared;
                {
                    this.selector = outgoingSelector.isUnknown() ? Fields.ALL : outgoingSelector;
                    this.incoming = new TupleEntry(incomingFields, true);
                    this.declared = new TupleEntry(declaredFields, true);
                }

                @Override
                public Tuple makeResult(Tuple input2, Tuple output) {
                    this.incoming.setTuple(input2);
                    this.declared.setTuple(output);
                    return TupleEntry.select(this.selector, this.incoming, this.declared);
                }
            };
        }
        return new TupleBuilder(){
            Fields inputFields;
            Tuple appended;
            Fields allFields;
            Tuple result;
            {
                this.inputFields = operator.getFieldDeclaration().isArguments() ? Fields.mask(inputDeclarationFields, declaredFields) : inputDeclarationFields;
                this.appended = TupleViews.createComposite(this.inputFields, declaredFields);
                this.allFields = Fields.resolve(Fields.ALL, this.inputFields, declaredFields);
                this.result = TupleViews.createNarrow(this.allFields.getPos(outgoingSelector), this.appended);
            }

            @Override
            public Tuple makeResult(Tuple input2, Tuple output) {
                TupleViews.reset(this.appended, input2, output);
                return this.result;
            }
        };
    }

    @Override
    public void initialize() {
        Scope outgoingScope = (Scope)this.outgoingScopes.get(0);
        this.operationCall = new ConcreteCall(outgoingScope.getArgumentsDeclarator(), outgoingScope.getOperationDeclaredFields());
        this.argumentsSelector = outgoingScope.getArgumentsSelector();
        this.remainderFields = outgoingScope.getRemainderPassThroughFields();
        this.outgoingSelector = this.getOutgoingSelector();
        this.argumentsEntry = new TupleEntry(outgoingScope.getArgumentsDeclarator(), true);
        this.outgoingEntry = new TupleEntry(this.getOutgoingFields(), true);
        this.operationCall.setArguments(this.argumentsEntry);
        this.argumentsBuilder = this.createArgumentsBuilder(this.getIncomingArgumentsFields(), this.argumentsSelector);
        this.outgoingBuilder = this.createOutgoingBuilder(this.getOperator(), this.getIncomingPassThroughFields(), this.argumentsSelector, this.remainderFields, this.getOperationDeclaredFields(), this.outgoingSelector);
    }

    @Override
    public void prepare() {
        super.prepare();
        ((Operator)this.getFlowElement()).getOperation().prepare(this.flowProcess, this.operationCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Duct previous) {
        try {
            ((Operator)this.getFlowElement()).getOperation().flush(this.flowProcess, this.operationCall);
        }
        finally {
            super.complete(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        if (!this.retainCollector) {
            this.operationCall.setOutputCollector(null);
        }
        try {
            ((Operator)this.getFlowElement()).getOperation().cleanup(this.flowProcess, this.operationCall);
        }
        finally {
            super.cleanup();
        }
    }
}

