/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.Duct;
import cascading.flow.stream.MemoryCoGroupClosure;
import cascading.flow.stream.SparseTupleComparator;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StreamGraph;
import cascading.pipe.Splice;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.TupleBuilder;
import cascading.tuple.util.TupleHasher;
import cascading.tuple.util.TupleViews;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MemorySpliceGate
extends SpliceGate {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySpliceGate.class);
    protected final Map<Duct, Integer> posMap = new IdentityHashMap<Duct, Integer>();
    protected Comparator<Tuple>[] groupComparators;
    protected Comparator<Tuple>[] valueComparators;
    protected TupleHasher groupHasher;
    protected boolean nullsAreNotEqual;
    protected Set<Tuple> keys;
    protected Map<Tuple, Collection<Tuple>>[] keyValues;
    protected MemoryCoGroupClosure closure;
    protected int numIncomingPaths;
    protected final AtomicInteger count = new AtomicInteger(0);

    public MemorySpliceGate(FlowProcess flowProcess, Splice splice) {
        super(flowProcess, splice);
    }

    @Override
    public void bind(StreamGraph streamGraph) {
        super.bind(streamGraph);
        this.numIncomingPaths = streamGraph.countAllEventingPathsTo(this);
        this.orderDucts(streamGraph);
    }

    @Override
    protected TupleBuilder createDefaultNarrowBuilder(final Fields incomingFields, final Fields narrowFields) {
        return new TupleBuilder(){
            int[] pos;
            {
                this.pos = incomingFields.getPos(narrowFields);
            }

            @Override
            public Tuple makeResult(Tuple input2, Tuple output) {
                return TupleViews.createNarrow(this.pos, input2);
            }
        };
    }

    @Override
    public void initialize() {
        super.initialize();
        Comparator defaultComparator = (Comparator)this.flowProcess.newInstance((String)this.flowProcess.getProperty("cascading.flow.tuple.element.comparator"));
        Fields[] compareFields = new Fields[this.orderedPrevious.length];
        this.groupComparators = new Comparator[this.orderedPrevious.length];
        if (this.splice.isSorted()) {
            this.valueComparators = new Comparator[this.orderedPrevious.length];
        }
        int size2 = this.splice.isGroupBy() ? 1 : this.incomingScopes.size();
        for (int i = 0; i < size2; ++i) {
            Fields groupFields;
            Scope incomingScope = (Scope)this.incomingScopes.get(i);
            int pos = this.splice.isGroupBy() ? 0 : this.splice.getPipePos().get(incomingScope.getName());
            compareFields[pos] = groupFields = this.splice.getKeySelectors().get(incomingScope.getName());
            this.groupComparators[pos] = groupFields.size() == 0 ? groupFields : new SparseTupleComparator(Fields.asDeclaration(groupFields), defaultComparator);
            Comparator<Tuple> comparator = this.groupComparators[pos] = this.splice.isSortReversed() ? Collections.reverseOrder(this.groupComparators[pos]) : this.groupComparators[pos];
            if (this.sortFields == null) continue;
            Fields sortFields = this.splice.getSortingSelectors().get(incomingScope.getName());
            this.valueComparators[pos] = new SparseTupleComparator(this.valuesFields[pos], sortFields, defaultComparator);
            if (!this.splice.isSortReversed()) continue;
            this.valueComparators[pos] = Collections.reverseOrder(this.valueComparators[pos]);
        }
        boolean bl = this.nullsAreNotEqual = !this.areNullsEqual();
        if (this.nullsAreNotEqual) {
            LOG.debug("treating null values in Tuples at not equal during in memory grouping");
        }
        Comparator[] hashers = TupleHasher.merge(compareFields);
        this.groupHasher = defaultComparator != null || !TupleHasher.isNull(hashers) ? new TupleHasher(defaultComparator, hashers) : null;
        this.keys = this.createKeySet();
        this.count.set(this.numIncomingPaths);
    }

    private boolean areNullsEqual() {
        try {
            Tuple tupleWithNull = Tuple.size(1);
            return this.groupComparators[0].compare(tupleWithNull, tupleWithNull) == 0;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public void prepare() {
        super.prepare();
        this.keyValues = this.createKeyValuesArray();
        this.makePosMap(this.posMap);
        this.closure = new MemoryCoGroupClosure(this.flowProcess, this.splice.getNumSelfJoins(), this.keyFields, this.valuesFields);
        if (this.grouping != null && this.splice.getJoinDeclaredFields() != null && this.splice.getJoinDeclaredFields().isNone()) {
            this.grouping.joinerClosure = this.closure;
        }
    }

    protected Comparator getKeyComparator() {
        if (this.groupComparators.length > 0 && this.groupComparators[0] != null) {
            return this.groupComparators[0];
        }
        return new Comparator<Comparable>(){

            @Override
            public int compare(Comparable lhs, Comparable rhs) {
                return lhs.compareTo(rhs);
            }
        };
    }

    protected Set<Tuple> createKeySet() {
        return Collections.synchronizedSet(new TreeSet(this.getKeyComparator()));
    }

    protected Map<Tuple, Collection<Tuple>>[] createKeyValuesArray() {
        int start;
        Map[] valueMap = new Map[this.orderedPrevious.length];
        for (int i = start = this.isBlockingStreamed() ? 0 : 1; i < this.orderedPrevious.length; ++i) {
            if (this.orderedPrevious[i] == null) continue;
            valueMap[i] = this.createTupleMap();
        }
        return valueMap;
    }

    protected Map<Tuple, Collection<Tuple>> createTupleMap() {
        return new HashMap<Tuple, Collection<Tuple>>(){

            @Override
            public Collection<Tuple> get(Object object) {
                ArrayList value2 = (ArrayList)super.get(object);
                if (value2 == null) {
                    value2 = new ArrayList();
                    super.put((Tuple)object, value2);
                }
                return value2;
            }
        };
    }

    protected final Tuple getDelegatedTuple(Tuple object) {
        if (this.groupHasher == null) {
            return object;
        }
        return new DelegatedTuple(object);
    }

    protected abstract boolean isBlockingStreamed();

    protected class DelegatedTuple
    extends Tuple {
        public DelegatedTuple(Tuple wrapped) {
            super(Tuple.elements(wrapped));
        }

        @Override
        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        @Override
        public int compareTo(Object other) {
            return MemorySpliceGate.this.groupComparators[0].compare(this, (Tuple)other);
        }

        @Override
        public int hashCode() {
            return MemorySpliceGate.this.groupHasher.hashCode(this);
        }
    }
}

