/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowProcess;
import cascading.flow.stream.Duct;
import cascading.flow.stream.MemorySpliceGate;
import cascading.flow.stream.StreamGraph;
import cascading.pipe.HashJoin;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryHashJoinGate
extends MemorySpliceGate {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryHashJoinGate.class);
    protected CountDownLatch latch;
    private Collection<Tuple>[] collections;
    private ArrayList<Tuple> streamedCollection;

    public MemoryHashJoinGate(FlowProcess flowProcess, HashJoin join2) {
        super(flowProcess, join2);
    }

    @Override
    public void bind(StreamGraph streamGraph) {
        super.bind(streamGraph);
        this.count.set(this.numIncomingPaths);
        this.latch = new CountDownLatch(this.numIncomingPaths - 1);
    }

    @Override
    public void prepare() {
        super.prepare();
        this.streamedCollection = new ArrayList<Tuple>(Arrays.asList(new Tuple()));
        this.collections = new Collection[this.orderedPrevious.length];
        this.collections[0] = this.streamedCollection;
        if (this.nullsAreNotEqual) {
            LOG.warn("HashJoin does not fully support key comparators where null values are not treated equal");
        }
    }

    @Override
    public void receive(Duct previous, TupleEntry incomingEntry) {
        int pos = (Integer)this.posMap.get(previous);
        Tuple incomingTuple = pos != 0 ? incomingEntry.getTupleCopy() : incomingEntry.getTuple();
        Tuple keyTuple = this.keyBuilder[pos].makeResult(incomingTuple, null);
        keyTuple = this.getDelegatedTuple(keyTuple);
        if (pos != 0) {
            this.keys.add(keyTuple);
            ((Collection)this.keyValues[pos].get(keyTuple)).add(incomingTuple);
            return;
        }
        this.waitOnLatch();
        this.keys.remove(keyTuple);
        this.streamedCollection.set(0, incomingTuple);
        this.performJoinWith(keyTuple);
    }

    private void performJoinWith(Tuple keyTuple) {
        for (int i = 1; i < this.keyValues.length; ++i) {
            this.collections[i] = this.keyValues[i].containsKey(keyTuple) ? (Collection)this.keyValues[i].get(keyTuple) : Collections.EMPTY_LIST;
        }
        this.closure.reset(this.collections);
        this.keyEntry.setTuple(keyTuple);
        this.tupleEntryIterator.reset(this.splice.getJoiner().getIterator(this.closure));
        this.next.receive(this, this.grouping);
    }

    @Override
    public void complete(Duct previous) {
        this.countDownLatch();
        if (this.count.decrementAndGet() != 0) {
            return;
        }
        this.collections[0] = Collections.EMPTY_LIST;
        for (Tuple keyTuple : this.keys) {
            this.performJoinWith(keyTuple);
        }
        this.keys = this.createKeySet();
        this.keyValues = this.createKeyValuesArray();
        super.complete(previous);
    }

    protected void waitOnLatch() {
        try {
            this.latch.await();
        }
        catch (InterruptedException exception) {
            throw new RuntimeException("interrupted", exception);
        }
    }

    protected void countDownLatch() {
        this.latch.countDown();
    }

    @Override
    protected boolean isBlockingStreamed() {
        return false;
    }
}

