/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.FlowProcess;
import cascading.flow.stream.Duct;
import cascading.flow.stream.MemorySpliceGate;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.Tuples;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class MemoryCoGroupGate
extends MemorySpliceGate {
    public MemoryCoGroupGate(FlowProcess flowProcess, Splice splice) {
        super(flowProcess, splice);
    }

    @Override
    protected boolean isBlockingStreamed() {
        return true;
    }

    @Override
    public void start(Duct previous) {
    }

    @Override
    public void receive(Duct previous, TupleEntry incomingEntry) {
        int pos = (Integer)this.posMap.get(previous);
        Tuple valuesTuple = incomingEntry.getTupleCopy();
        Tuple groupTuple = this.keyBuilder[pos].makeResult(valuesTuple, null);
        groupTuple = this.getDelegatedTuple(groupTuple);
        this.keys.add(groupTuple);
        ((Collection)this.keyValues[pos].get(groupTuple)).add(valuesTuple);
    }

    @Override
    public void complete(Duct previous) {
        if (this.count.decrementAndGet() != 0) {
            return;
        }
        this.next.start(this);
        Collection[] collections = new Collection[this.orderedPrevious.length];
        Iterator keyIterator = this.keys.iterator();
        HashSet<Tuple> seenNulls = new HashSet<Tuple>();
        while (keyIterator.hasNext()) {
            int i;
            Tuple keysTuple = (Tuple)keyIterator.next();
            keyIterator.remove();
            if (this.nullsAreNotEqual && Tuples.frequency(keysTuple, null) != 0) {
                if (seenNulls.contains(keysTuple)) continue;
                seenNulls.add(keysTuple);
                for (i = 0; i < this.keyValues.length; ++i) {
                    Collection values2 = (Collection)this.keyValues[i].remove(keysTuple);
                    if (values2 == null) continue;
                    for (int j = 0; j < this.keyValues.length; ++j) {
                        collections[j] = Collections.EMPTY_LIST;
                    }
                    collections[i] = values2;
                    this.push(collections, keysTuple);
                }
                continue;
            }
            for (i = 0; i < this.keyValues.length; ++i) {
                collections[i] = (Collection)this.keyValues[i].remove(keysTuple);
                if (collections[i] != null) continue;
                collections[i] = Collections.EMPTY_LIST;
            }
            this.push(collections, keysTuple);
        }
        this.keys = this.createKeySet();
        this.keyValues = this.createKeyValuesArray();
        this.count.set(this.numIncomingPaths);
        this.next.complete(this);
    }

    private void push(Collection<Tuple>[] collections, Tuple keysTuple) {
        this.closure.reset(collections);
        this.keyEntry.setTuple(this.closure.getGroupTuple(keysTuple));
        this.tupleEntryIterator.reset(this.splice.getJoiner().getIterator(this.closure));
        this.next.receive(this, this.grouping);
    }
}

