/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.flow.stream.StreamGraph;

public abstract class Duct<Incoming, Outgoing> {
    protected Duct<Outgoing, ?> next;

    Duct() {
    }

    Duct(Duct<Outgoing, ?> next2) {
        this.next = next2;
    }

    public Duct getNext() {
        return this.next;
    }

    public void bind(StreamGraph streamGraph) {
        this.next = this.getNextFor(streamGraph);
    }

    protected Duct getNextFor(StreamGraph streamGraph) {
        return streamGraph.createNextFor(this);
    }

    public void initialize() {
    }

    public void prepare() {
    }

    public final void receiveFirst(Incoming incoming) {
        this.receive(null, incoming);
    }

    public void start(Duct previous) {
        this.next.start(this);
    }

    public abstract void receive(Duct var1, Incoming var2);

    public void complete(Duct previous) {
        this.next.complete(this);
    }

    public void cleanup() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

