/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.Duct;
import cascading.flow.stream.EveryStage;
import cascading.flow.stream.Grouping;
import cascading.flow.stream.OpenWindow;
import cascading.operation.Buffer;
import cascading.pipe.Every;
import cascading.pipe.OperatorException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.tuple.Tuples;
import java.io.IOException;
import java.util.Iterator;

public class BufferEveryWindow
extends EveryStage<Grouping<TupleEntry, TupleEntryIterator>>
implements OpenWindow {
    Buffer buffer;

    public BufferEveryWindow(FlowProcess flowProcess, Every every) {
        super(flowProcess, every);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.buffer = this.every.getBuffer();
        this.outputCollector = new TupleEntryCollector(this.getOperationDeclaredFields()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void collect(TupleEntry resultEntry) throws IOException {
                Tuple outgoing = BufferEveryWindow.this.outgoingBuilder.makeResult(BufferEveryWindow.this.incomingEntry.getTuple(), resultEntry.getTuple());
                BufferEveryWindow.this.outgoingEntry.setTuple(outgoing);
                try {
                    BufferEveryWindow.this.next.receive(BufferEveryWindow.this, BufferEveryWindow.this.outgoingEntry);
                }
                finally {
                    Tuples.asModifiable(outgoing);
                }
            }
        };
    }

    @Override
    protected Fields getIncomingPassThroughFields() {
        return ((Scope)this.incomingScopes.get(0)).getIncomingBufferPassThroughFields();
    }

    @Override
    protected Fields getIncomingArgumentsFields() {
        return ((Scope)this.incomingScopes.get(0)).getIncomingBufferArgumentFields();
    }

    @Override
    protected Fields getOutgoingSelector() {
        return ((Scope)this.outgoingScopes.get(0)).getOutGroupingSelector();
    }

    @Override
    public void start(Duct previous) {
        this.next.start(this);
    }

    @Override
    public void receive(Duct previous, Grouping<TupleEntry, TupleEntryIterator> grouping) {
        try {
            TupleEntry tupleEntry;
            this.incomingEntry = tupleEntry = ((TupleEntryIterator)grouping.joinIterator).getTupleEntry();
            if (!tupleEntry.getFields().isNone()) {
                Tuple valueNulledTuple = Tuples.setOnEmpty(tupleEntry, (TupleEntry)grouping.key);
                tupleEntry.setTuple(valueNulledTuple);
                this.operationCall.setArgumentsIterator(this.createArgumentsIterator(grouping, tupleEntry, valueNulledTuple));
            }
            this.operationCall.setOutputCollector(this.outputCollector);
            this.operationCall.setJoinerClosure(grouping.joinerClosure);
            this.operationCall.setGroup((TupleEntry)grouping.key);
            this.buffer.operate(this.flowProcess, this.operationCall);
        }
        catch (CascadingException exception) {
            this.handleException(exception, this.argumentsEntry);
        }
        catch (Throwable throwable2) {
            this.handleException(new OperatorException(this.every, "operator Every failed executing operation: " + this.every.getOperation(), throwable2), this.argumentsEntry);
        }
    }

    private Iterator<TupleEntry> createArgumentsIterator(final Grouping<TupleEntry, TupleEntryIterator> grouping, final TupleEntry tupleEntry, final Tuple valueNulledTuple) {
        return new Iterator<TupleEntry>(){

            @Override
            public boolean hasNext() {
                boolean hasNext = ((TupleEntryIterator)grouping.joinIterator).hasNext();
                if (!hasNext && !BufferEveryWindow.this.operationCall.isRetainValues()) {
                    tupleEntry.setTuple(valueNulledTuple);
                }
                return hasNext;
            }

            @Override
            public TupleEntry next() {
                BufferEveryWindow.this.argumentsEntry.setTuple(BufferEveryWindow.this.argumentsBuilder.makeResult(((TupleEntry)((TupleEntryIterator)grouping.joinIterator).next()).getTuple(), null));
                return BufferEveryWindow.this.argumentsEntry;
            }

            @Override
            public void remove() {
                ((TupleEntryIterator)grouping.joinIterator).remove();
            }
        };
    }
}

