/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.planner.Scope;
import cascading.flow.stream.Duct;
import cascading.flow.stream.EveryStage;
import cascading.flow.stream.Reducing;
import cascading.operation.Aggregator;
import cascading.pipe.Every;
import cascading.pipe.OperatorException;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.Tuples;
import java.io.IOException;

public class AggregatorEveryStage
extends EveryStage<TupleEntry>
implements Reducing<TupleEntry, TupleEntry> {
    private Aggregator aggregator;
    private Reducing reducing;

    public AggregatorEveryStage(FlowProcess flowProcess, Every every) {
        super(flowProcess, every);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aggregator = this.every.getAggregator();
        this.outputCollector = new TupleEntryCollector(this.getOperationDeclaredFields()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void collect(TupleEntry resultEntry) throws IOException {
                Tuple outgoing = AggregatorEveryStage.this.outgoingBuilder.makeResult(AggregatorEveryStage.this.incomingEntry.getTuple(), resultEntry.getTuple());
                AggregatorEveryStage.this.outgoingEntry.setTuple(outgoing);
                try {
                    AggregatorEveryStage.this.reducing.completeGroup(AggregatorEveryStage.this, AggregatorEveryStage.this.outgoingEntry);
                }
                finally {
                    Tuples.asModifiable(outgoing);
                }
            }
        };
        this.reducing = (Reducing)((Object)this.getNext());
    }

    @Override
    protected Fields getIncomingPassThroughFields() {
        return ((Scope)this.incomingScopes.get(0)).getIncomingAggregatorPassThroughFields();
    }

    @Override
    protected Fields getIncomingArgumentsFields() {
        return ((Scope)this.incomingScopes.get(0)).getIncomingAggregatorArgumentFields();
    }

    @Override
    protected Fields getOutgoingSelector() {
        return ((Scope)this.outgoingScopes.get(0)).getOutGroupingSelector();
    }

    @Override
    public void startGroup(Duct previous, TupleEntry groupEntry) {
        this.operationCall.setGroup(groupEntry);
        this.operationCall.setArguments(null);
        this.operationCall.setOutputCollector(null);
        try {
            this.aggregator.start(this.flowProcess, this.operationCall);
        }
        catch (CascadingException exception) {
            this.handleException(exception, groupEntry);
        }
        catch (Throwable throwable2) {
            this.handleException(new OperatorException(this.every, "operator Every failed starting operation: " + this.every.getOperation(), throwable2), groupEntry);
        }
        this.reducing.startGroup(this, groupEntry);
    }

    @Override
    public void receive(Duct previous, TupleEntry tupleEntry) {
        try {
            this.argumentsEntry.setTuple(this.argumentsBuilder.makeResult(tupleEntry.getTuple(), null));
            this.operationCall.setArguments(this.argumentsEntry);
            this.aggregator.aggregate(this.flowProcess, this.operationCall);
        }
        catch (CascadingException exception) {
            this.handleException(exception, this.argumentsEntry);
        }
        catch (Throwable throwable2) {
            this.handleException(new OperatorException(this.every, "operator Every failed executing operation: " + this.every.getOperation(), throwable2), this.argumentsEntry);
        }
        this.next.receive(this, tupleEntry);
    }

    @Override
    public void completeGroup(Duct previous, TupleEntry incomingEntry) {
        this.incomingEntry = incomingEntry;
        this.operationCall.setArguments(null);
        this.operationCall.setOutputCollector(this.outputCollector);
        try {
            this.aggregator.complete(this.flowProcess, this.operationCall);
        }
        catch (CascadingException exception) {
            this.handleException(exception, incomingEntry);
        }
        catch (Throwable throwable2) {
            this.handleException(new OperatorException(this.every, "operator Every failed completing operation: " + this.every.getOperation(), throwable2), incomingEntry);
        }
    }
}

