/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.tuple.Fields;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;

public class Scope
implements Serializable {
    private String name;
    private Kind kind;
    private Fields incomingPassThroughFields;
    private Fields remainderPassThroughFields;
    private Fields operationArgumentFields;
    private Fields operationDeclaredFields;
    private boolean isGroupBy;
    private Map<String, Fields> keySelectors;
    private Map<String, Fields> sortingSelectors;
    private Fields outGroupingSelector;
    private Fields outGroupingFields;
    private Fields outValuesSelector;
    private Fields outValuesFields;

    public Scope() {
    }

    public Scope(Scope scope) {
        this.name = scope.getName();
        this.copyFields(scope);
    }

    public Scope(Fields outFields2) {
        this.kind = Kind.TAP;
        if (outFields2 == null) {
            throw new IllegalArgumentException("fields may not be null");
        }
        this.outGroupingFields = outFields2;
        this.outValuesFields = outFields2;
    }

    public Scope(String name2, Kind kind, Fields incomingPassThroughFields, Fields remainderPassThroughFields, Fields operationArgumentFields, Fields operationDeclaredFields, Fields outGroupingFields, Fields outValuesFields) {
        this.name = name2;
        this.kind = kind;
        this.incomingPassThroughFields = incomingPassThroughFields;
        this.remainderPassThroughFields = remainderPassThroughFields;
        this.operationArgumentFields = operationArgumentFields;
        this.operationDeclaredFields = operationDeclaredFields;
        if (outGroupingFields == null) {
            throw new IllegalArgumentException("grouping may not be null");
        }
        if (outValuesFields == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (kind == Kind.EACH) {
            this.outGroupingSelector = outGroupingFields;
            this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
            this.outValuesSelector = outValuesFields;
            this.outValuesFields = Fields.asDeclaration(outValuesFields);
        } else if (kind == Kind.EVERY) {
            this.outGroupingSelector = outGroupingFields;
            this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
            this.outValuesSelector = outValuesFields;
            this.outValuesFields = Fields.asDeclaration(outValuesFields);
        } else {
            throw new IllegalArgumentException("may not use the constructor for kind: " + (Object)((Object)kind));
        }
    }

    public Scope(String name2, Fields operationDeclaredFields, Fields outGroupingFields, Map<String, Fields> keySelectors, Map<String, Fields> sortingSelectors, Fields outValuesFields, boolean isGroupBy) {
        this.name = name2;
        this.kind = Kind.GROUP;
        this.isGroupBy = isGroupBy;
        if (keySelectors == null) {
            throw new IllegalArgumentException("grouping may not be null");
        }
        if (outValuesFields == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        this.operationDeclaredFields = operationDeclaredFields;
        this.outGroupingFields = Fields.asDeclaration(outGroupingFields);
        this.keySelectors = keySelectors;
        this.sortingSelectors = sortingSelectors;
        this.outValuesFields = Fields.asDeclaration(outValuesFields);
    }

    public Scope(String name2) {
        this.name = name2;
    }

    public boolean isGroup() {
        return this.kind == Kind.GROUP;
    }

    public boolean isEach() {
        return this.kind == Kind.EACH;
    }

    public boolean isEvery() {
        return this.kind == Kind.EVERY;
    }

    public boolean isTap() {
        return this.kind == Kind.TAP;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name2) {
        this.name = name2;
    }

    public Fields getRemainderPassThroughFields() {
        return this.remainderPassThroughFields;
    }

    public Fields getArgumentsSelector() {
        return this.operationArgumentFields;
    }

    public Fields getArgumentsDeclarator() {
        return Fields.asDeclaration(this.operationArgumentFields);
    }

    public Fields getOperationDeclaredFields() {
        return this.operationDeclaredFields;
    }

    public Map<String, Fields> getKeySelectors() {
        return this.keySelectors;
    }

    public Map<String, Fields> getSortingSelectors() {
        return this.sortingSelectors;
    }

    public Fields getOutGroupingSelector() {
        return this.outGroupingSelector;
    }

    public Fields getIncomingTapFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingFunctionArgumentFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingFunctionPassThroughFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingAggregatorArgumentFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingAggregatorPassThroughFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutGroupingFields();
    }

    public Fields getIncomingBufferArgumentFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingBufferPassThroughFields() {
        if (this.isEach() || this.isTap()) {
            throw new IllegalStateException("Every cannot follow a Tap or an Each");
        }
        return this.getOutValuesFields();
    }

    public Fields getIncomingSpliceFields() {
        if (this.isEvery()) {
            return this.getOutGroupingFields();
        }
        return this.getOutValuesFields();
    }

    public Fields getOutGroupingFields() {
        if (!this.isGroup()) {
            return this.outGroupingFields;
        }
        Fields first2 = this.keySelectors.values().iterator().next();
        if (this.keySelectors.size() == 1 || this.isGroup() && this.isGroupBy) {
            return first2;
        }
        if (this.outGroupingFields != null) {
            return this.outGroupingFields;
        }
        HashSet<Fields> set2 = new HashSet<Fields>(this.keySelectors.values());
        if (set2.size() == 1) {
            return first2;
        }
        return Fields.size(first2.size());
    }

    public Fields getOutGroupingValueFields() {
        return this.getOutValuesFields().subtract(this.getOutGroupingFields());
    }

    public Fields getOutValuesSelector() {
        return this.outValuesSelector;
    }

    public Fields getOutValuesFields() {
        return this.outValuesFields;
    }

    public void copyFields(Scope scope) {
        this.kind = scope.kind;
        this.isGroupBy = scope.isGroupBy;
        this.incomingPassThroughFields = scope.incomingPassThroughFields;
        this.remainderPassThroughFields = scope.remainderPassThroughFields;
        this.operationArgumentFields = scope.operationArgumentFields;
        this.operationDeclaredFields = scope.operationDeclaredFields;
        this.keySelectors = scope.keySelectors;
        this.sortingSelectors = scope.sortingSelectors;
        this.outGroupingSelector = scope.outGroupingSelector;
        this.outGroupingFields = scope.outGroupingFields;
        this.outValuesSelector = scope.outValuesSelector;
        this.outValuesFields = scope.outValuesFields;
    }

    public String toString() {
        if (this.getOutValuesFields() == null) {
            return "";
        }
        StringBuffer buffer2 = new StringBuffer();
        if (this.keySelectors != null && !this.keySelectors.isEmpty()) {
            for (String name2 : this.keySelectors.keySet()) {
                if (buffer2.length() != 0) {
                    buffer2.append(",");
                }
                buffer2.append(name2).append(this.keySelectors.get(name2).printVerbose());
            }
            buffer2.append("\n");
        }
        if (this.outGroupingFields != null) {
            buffer2.append(this.getOutGroupingFields().printVerbose()).append("\n");
        }
        buffer2.append(this.getOutValuesFields().printVerbose());
        return buffer2.toString();
    }

    public static enum Kind {
        TAP,
        EACH,
        EVERY,
        GROUP,
        SPLICE;

    }
}

