/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.Flow;
import cascading.flow.FlowException;
import cascading.flow.FlowStepStrategy;
import cascading.flow.planner.BaseFlowStep;
import cascading.management.state.ClientState;
import cascading.stats.FlowStats;
import cascading.stats.FlowStepStats;
import cascading.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowStepJob<Config>
implements Callable<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowStepJob.class);
    protected final String stepName;
    protected long pollingInterval = 1000L;
    protected long statsStoreInterval = 60000L;
    protected List<FlowStepJob<Config>> predecessors;
    private final CountDownLatch latch = new CountDownLatch(1);
    private boolean stop = false;
    protected final BaseFlowStep<Config> flowStep;
    protected FlowStepStats flowStepStats;
    protected Throwable throwable;

    public FlowStepJob(ClientState clientState, BaseFlowStep flowStep, long pollingInterval, long statsStoreInterval) {
        this.flowStep = flowStep;
        this.stepName = flowStep.getName();
        this.pollingInterval = pollingInterval;
        this.statsStoreInterval = statsStoreInterval;
        this.flowStepStats = this.createStepStats(clientState);
        this.flowStepStats.prepare();
        this.flowStepStats.markPending();
    }

    public abstract Config getConfig();

    protected abstract FlowStepStats createStepStats(ClientState var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (this.flowStep.isInfoEnabled()) {
            this.flowStep.logInfo("stopping: " + this.stepName);
        }
        this.stop = true;
        if (!this.flowStepStats.isFinished()) {
            this.flowStepStats.markStopped();
        }
        try {
            this.internalBlockOnStop();
        }
        catch (IOException exception) {
            this.flowStep.logWarn("unable to kill job: " + this.stepName, exception);
        }
        finally {
            if (this.flowStepStats.isStopped()) {
                this.flowStep.rollbackSinks();
                this.flowStep.fireOnStopping();
            }
            this.flowStepStats.cleanup();
        }
    }

    protected abstract void internalBlockOnStop() throws IOException;

    public void setPredecessors(List<FlowStepJob<Config>> predecessors2) {
        this.predecessors = predecessors2;
    }

    @Override
    public Throwable call() {
        this.start();
        return this.throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        try {
            if (this.isSkipFlowStep()) {
                this.markSkipped();
                if (this.flowStep.isInfoEnabled() && this.flowStepStats.isSkipped()) {
                    this.flowStep.logInfo("skipping step: " + this.stepName);
                }
                return;
            }
            if (!this.markStarted()) {
                return;
            }
            this.blockOnPredecessors();
            this.applyFlowStepConfStrategy();
            this.blockOnJob();
        }
        catch (Throwable throwable2) {
            this.dumpDebugInfo();
            this.throwable = throwable2;
            this.flowStep.fireOnThrowable(throwable2);
        }
        finally {
            this.latch.countDown();
            this.flowStepStats.cleanup();
        }
    }

    private synchronized boolean markStarted() {
        if (this.flowStepStats.isFinished()) {
            return false;
        }
        this.flowStepStats.markStarted();
        return true;
    }

    private void applyFlowStepConfStrategy() {
        FlowStepStrategy flowStepStrategy = this.flowStep.getFlow().getFlowStepStrategy();
        if (flowStepStrategy == null) {
            return;
        }
        ArrayList predecessorSteps = new ArrayList();
        for (FlowStepJob<Config> predecessor : this.predecessors) {
            predecessorSteps.add(predecessor.flowStep);
        }
        flowStepStrategy.apply(this.flowStep.getFlow(), predecessorSteps, this.flowStep);
    }

    protected boolean isSkipFlowStep() throws IOException {
        if (this.flowStep.getFlow().getRunID() == null) {
            return false;
        }
        return this.flowStep.allSourcesExist() && !this.flowStep.areSourcesNewer(this.flowStep.getSinkModified());
    }

    protected void blockOnJob() throws IOException {
        if (this.stop) {
            return;
        }
        if (this.flowStep.isInfoEnabled()) {
            this.flowStep.logInfo("starting step: " + this.stepName);
        }
        this.internalNonBlockingStart();
        this.markSubmitted();
        this.flowStep.fireOnStarting();
        this.blockTillCompleteOrStopped();
        if (!this.stop && !this.internalNonBlockingIsSuccessful()) {
            if (!this.flowStepStats.isFinished()) {
                this.flowStep.rollbackSinks();
                this.flowStepStats.markFailed(this.getThrowable());
                this.flowStep.fireOnThrowable(this.getThrowable());
            }
            this.dumpDebugInfo();
            if (this.getThrowable() instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)this.getThrowable();
            }
            this.throwable = !this.isRemoteExecution() ? new FlowException("local step failed", this.getThrowable()) : new FlowException("step failed: " + this.stepName + ", with job id: " + this.internalJobId() + ", please see cluster logs for failure messages");
        } else if (this.internalNonBlockingIsSuccessful() && !this.flowStepStats.isFinished()) {
            this.throwable = this.flowStep.commitSinks();
            if (this.throwable != null) {
                this.flowStepStats.markFailed(this.throwable);
                this.flowStep.fireOnThrowable(this.throwable);
            } else {
                this.flowStepStats.markSuccessful();
                this.flowStep.fireOnCompleted();
            }
        }
        this.flowStepStats.recordChildStats();
    }

    protected abstract boolean isRemoteExecution();

    protected abstract String internalJobId();

    protected abstract boolean internalNonBlockingIsSuccessful() throws IOException;

    protected abstract Throwable getThrowable();

    protected abstract void internalNonBlockingStart() throws IOException;

    protected void blockTillCompleteOrStopped() throws IOException {
        int iterations = (int)Math.floor(this.statsStoreInterval / this.pollingInterval);
        int count2 = 0;
        while (true) {
            if (this.flowStepStats.isSubmitted() && this.isStarted()) {
                this.markRunning();
                this.flowStep.fireOnRunning();
            }
            if (this.stop || this.internalNonBlockingIsComplete()) break;
            this.sleepForPollingInterval();
            if (iterations != count2++) continue;
            count2 = 0;
            this.flowStepStats.recordStats();
            this.flowStepStats.recordChildStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void markSubmitted() {
        FlowStats flowStats;
        Flow<Config> flow;
        if (this.flowStepStats.isStarted()) {
            this.flowStepStats.markSubmitted();
        }
        if ((flow = this.flowStep.getFlow()) == null) {
            LOG.warn("no parent flow set");
            return;
        }
        FlowStats flowStats2 = flowStats = flow.getFlowStats();
        synchronized (flowStats2) {
            if (flowStats.isStarted()) {
                flowStats.markSubmitted();
            }
        }
    }

    private synchronized void markRunning() {
        this.flowStepStats.markRunning();
        this.markFlowRunning();
    }

    private synchronized void markSkipped() {
        if (this.flowStepStats.isFinished()) {
            return;
        }
        this.flowStepStats.markSkipped();
        this.markFlowRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void markFlowRunning() {
        FlowStats flowStats;
        Flow<Config> flow = this.flowStep.getFlow();
        if (flow == null) {
            LOG.warn("no parent flow set");
            return;
        }
        FlowStats flowStats2 = flowStats = flow.getFlowStats();
        synchronized (flowStats2) {
            if (flowStats.isStarted() || flowStats.isSubmitted()) {
                flowStats.markRunning();
            }
        }
    }

    protected abstract boolean internalNonBlockingIsComplete() throws IOException;

    protected void sleepForPollingInterval() {
        Util.safeSleep(this.pollingInterval);
    }

    protected void blockOnPredecessors() {
        for (FlowStepJob<Config> predecessor : this.predecessors) {
            if (predecessor.isSuccessful()) continue;
            this.flowStep.logWarn("abandoning step: " + this.stepName + ", predecessor failed: " + predecessor.stepName);
            this.stop();
        }
    }

    protected abstract void dumpDebugInfo();

    public boolean isSuccessful() {
        try {
            this.latch.await();
            return this.flowStepStats.isSuccessful() || this.flowStepStats.isSkipped();
        }
        catch (InterruptedException exception) {
            this.flowStep.logWarn("latch interrupted", exception);
            return false;
        }
        catch (NullPointerException exception) {
            throw new FlowException("Hadoop is not keeping a large enough job history, please increase the 'mapred.jobtracker.completeuserjobs.maximum' property", exception);
        }
    }

    public boolean isStarted() {
        return this.internalIsStarted();
    }

    protected abstract boolean internalIsStarted();

    public FlowStepStats getStepStats() {
        return this.flowStepStats;
    }
}

