/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.FlowElement;
import cascading.flow.FlowStep;
import cascading.flow.planner.ElementGraph;
import cascading.flow.planner.Scope;
import cascading.pipe.Group;
import cascading.tap.Tap;
import cascading.util.Util;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowStepGraph<Config>
extends SimpleDirectedGraph<FlowStep<Config>, Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowStepGraph.class);

    public FlowStepGraph() {
        super(Integer.class);
    }

    public FlowStepGraph(String flowName, ElementGraph elementGraph) {
        this();
        this.makeStepGraph(flowName, elementGraph);
    }

    protected FlowStep<Config> getCreateFlowStep(Map<Tap, FlowStep<Config>> steps, Tap sink2, int numJobs) {
        if (steps.containsKey(sink2)) {
            return steps.get(sink2);
        }
        LOG.debug("creating step: {}", (Object)sink2);
        int stepNum = steps.size() + 1;
        String stepName = this.makeStepName(sink2, numJobs, stepNum);
        FlowStep<Config> step = this.createFlowStep(stepName, stepNum);
        steps.put(sink2, step);
        return step;
    }

    protected abstract FlowStep<Config> createFlowStep(String var1, int var2);

    private String makeStepName(Tap sink2, int numJobs, int stepNum) {
        if (sink2.isTemporary()) {
            return String.format("(%d/%d)", stepNum, numJobs);
        }
        String identifier2 = sink2.getIdentifier();
        if (identifier2.length() > 25) {
            identifier2 = String.format("...%25s", identifier2.substring(identifier2.length() - 25));
        }
        return String.format("(%d/%d) %s", stepNum, numJobs, identifier2);
    }

    protected abstract void makeStepGraph(String var1, ElementGraph var2);

    protected boolean pathContainsTap(GraphPath<FlowElement, Scope> path) {
        List<FlowElement> flowElements = Graphs.getPathVertexList(path);
        int count2 = 0;
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof Tap)) continue;
            ++count2;
        }
        return count2 > 2;
    }

    public TopologicalOrderIterator<FlowStep<Config>, Integer> getTopologicalIterator() {
        return new TopologicalOrderIterator(this, new PriorityQueue(10, new Comparator<FlowStep<Config>>(){

            @Override
            public int compare(FlowStep<Config> lhs, FlowStep<Config> rhs) {
                return Integer.valueOf(lhs.getSubmitPriority()).compareTo(rhs.getSubmitPriority());
            }
        }));
    }

    public void writeDOT(String filename) {
        this.printElementGraph(filename);
    }

    protected void printElementGraph(String filename) {
        try {
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, this, new IntegerNameProvider(), new VertexNameProvider<FlowStep>(){

                @Override
                public String getVertexName(FlowStep flowStep) {
                    String sourceName = "";
                    for (Tap object : flowStep.getSources()) {
                        Tap source2 = object;
                        if (source2.isTemporary()) continue;
                        sourceName = sourceName + "[" + source2.getIdentifier() + "]";
                    }
                    String name2 = "[" + flowStep.getName() + "]";
                    if (sourceName.length() != 0) {
                        name2 = name2 + "\\nsrc:" + sourceName;
                    }
                    List<Group> groups = flowStep.getGroups();
                    for (Group group2 : groups) {
                        String groupName2 = group2.getName();
                        if (groupName2.length() == 0) continue;
                        name2 = name2 + "\\ngrp:" + groupName2;
                    }
                    Set<Tap> sinks = flowStep.getSinks();
                    for (Tap sink2 : sinks) {
                        String sinkName = sink2.isTemporary() ? "" : "[" + sink2.getIdentifier() + "]";
                        if (sinkName.length() == 0) continue;
                        name2 = name2 + "\\nsnk:" + sinkName;
                    }
                    return name2.replaceAll("\"", "'");
                }
            }, null);
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            LOG.error("failed printing graph to: {}, with exception: {}", (Object)filename, (Object)exception);
        }
    }
}

