/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.AssemblyPlanner;
import cascading.flow.Flow;
import cascading.flow.FlowConnector;
import cascading.flow.FlowDef;
import cascading.flow.FlowElement;
import cascading.flow.planner.AssemblyPlannerContext;
import cascading.flow.planner.ElementGraph;
import cascading.flow.planner.ElementGraphException;
import cascading.flow.planner.ElementGraphs;
import cascading.flow.planner.PlannerException;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.operation.AssertionLevel;
import cascading.operation.DebugLevel;
import cascading.pipe.Checkpoint;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.Group;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.pipe.OperatorException;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.pipe.SubAssembly;
import cascading.property.ConfigDef;
import cascading.property.PropertyUtil;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.TapException;
import cascading.tuple.Fields;
import cascading.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlowPlanner<F extends Flow, Config> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowPlanner.class);
    protected Map<Object, Object> properties;
    protected String checkpointRootPath = null;
    protected AssertionLevel assertionLevel;
    protected DebugLevel debugLevel;

    static AssertionLevel getAssertionLevel(Map<Object, Object> properties) {
        String assertionLevel = PropertyUtil.getProperty(properties, "cascading.flowconnector.assertionlevel", AssertionLevel.STRICT.name());
        return AssertionLevel.valueOf(assertionLevel);
    }

    static DebugLevel getDebugLevel(Map<Object, Object> properties) {
        String debugLevel = PropertyUtil.getProperty(properties, "cascading.flowconnector.debuglevel", DebugLevel.DEFAULT.name());
        return DebugLevel.valueOf(debugLevel);
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    public abstract Config getConfig();

    public abstract PlatformInfo getPlatformInfo();

    public void initialize(FlowConnector flowConnector, Map<Object, Object> properties) {
        this.properties = properties;
        this.assertionLevel = FlowPlanner.getAssertionLevel(properties);
        this.debugLevel = FlowPlanner.getDebugLevel(properties);
    }

    protected abstract Flow createFlow(FlowDef var1);

    public abstract F buildFlow(FlowDef var1);

    protected Pipe[] resolveTails(FlowDef flowDef, Flow<Config> flow) {
        Pipe[] tails2 = flowDef.getTailsArray();
        tails2 = this.resolveAssemblyPlanners(flowDef, flow, tails2);
        return tails2;
    }

    protected Pipe[] resolveAssemblyPlanners(FlowDef flowDef, Flow flow, Pipe[] pipes) {
        List<Pipe> tails2 = Arrays.asList(pipes);
        List<AssemblyPlanner> assemblyPlanners = flowDef.getAssemblyPlanners();
        for (AssemblyPlanner assemblyPlanner : assemblyPlanners) {
            tails2 = assemblyPlanner.resolveTails(new AssemblyPlannerContext(flowDef, flow, tails2));
            if (tails2.isEmpty()) {
                throw new PlannerException("assembly planner: " + assemblyPlanner + ", returned zero tails");
            }
            tails2 = Collections.unmodifiableList(tails2);
        }
        return tails2.toArray(new Pipe[tails2.size()]);
    }

    protected void verifyAssembly(FlowDef flowDef, Pipe[] tails2) {
        this.verifyPipeAssemblyEndPoints(flowDef, tails2);
        this.verifyTraps(flowDef, tails2);
        this.verifyCheckpoints(flowDef, tails2);
    }

    protected void verifyAllTaps(FlowDef flowDef) {
        this.verifySourceNotSinks(flowDef.getSources(), flowDef.getSinks());
        this.verifyTaps(flowDef.getSources(), true, true);
        this.verifyTaps(flowDef.getSinks(), false, true);
        this.verifyTaps(flowDef.getTraps(), false, false);
        this.verifyTaps(flowDef.getCheckpoints(), true, false);
        this.verifyTaps(flowDef.getCheckpoints(), false, false);
    }

    protected ElementGraph createElementGraph(FlowDef flowDef, Pipe[] flowTails) {
        Map<String, Tap> sources = flowDef.getSourcesCopy();
        Map<String, Tap> sinks = flowDef.getSinksCopy();
        Map<String, Tap> traps = flowDef.getTrapsCopy();
        Map<String, Tap> checkpoints = flowDef.getCheckpointsCopy();
        AssertionLevel assertionLevel = flowDef.getAssertionLevel() == null ? this.assertionLevel : flowDef.getAssertionLevel();
        DebugLevel debugLevel = flowDef.getDebugLevel() == null ? this.debugLevel : flowDef.getDebugLevel();
        this.checkpointRootPath = this.makeCheckpointRootPath(flowDef);
        return new ElementGraph(this.getPlatformInfo(), flowTails, sources, sinks, traps, checkpoints, this.checkpointRootPath != null, assertionLevel, debugLevel);
    }

    private String makeCheckpointRootPath(FlowDef flowDef) {
        String flowName = flowDef.getName();
        String runID = flowDef.getRunID();
        if (runID == null) {
            return null;
        }
        if (flowName == null) {
            throw new PlannerException("flow name is required when providing a run id");
        }
        return flowName + "/" + runID;
    }

    protected void verifySourceNotSinks(Map<String, Tap> sources, Map<String, Tap> sinks) {
        Collection<Tap> sourcesSet = sources.values();
        for (Tap tap : sinks.values()) {
            if (!sourcesSet.contains(tap)) continue;
            throw new PlannerException("tap may not be used as both source and sink in the same Flow: " + tap);
        }
    }

    protected void verifyTaps(Map<String, Tap> taps, boolean areSources, boolean mayNotBeEmpty) {
        if (mayNotBeEmpty && taps.isEmpty()) {
            throw new PlannerException((areSources ? "source" : "sink") + " taps are required");
        }
        for (String tapName : taps.keySet()) {
            if (areSources && !taps.get(tapName).isSource()) {
                throw new PlannerException("tap named: '" + tapName + "', cannot be used as a source: " + taps.get(tapName));
            }
            if (areSources || taps.get(tapName).isSink()) continue;
            throw new PlannerException("tap named: '" + tapName + "', cannot be used as a sink: " + taps.get(tapName));
        }
    }

    protected void verifyPipeAssemblyEndPoints(FlowDef flowDef, Pipe[] flowTails) {
        HashSet<String> tapNames = new HashSet<String>();
        tapNames.addAll(flowDef.getSources().keySet());
        tapNames.addAll(flowDef.getSinks().keySet());
        HashSet<Pipe> tails2 = new HashSet<Pipe>();
        HashSet<String> tailNames = new HashSet<String>();
        for (Pipe pipe : flowTails) {
            if (pipe instanceof SubAssembly) {
                for (Pipe tail : ((SubAssembly)pipe).getTails()) {
                    String tailName = tail.getName();
                    if (!tapNames.contains(tailName)) {
                        throw new PlannerException(tail, "pipe name not found in either sink or source map: '" + tailName + "'");
                    }
                    if (tailNames.contains(tailName) && !tails2.contains(tail)) {
                        LOG.warn("duplicate tail name found: '{}'", (Object)tailName);
                    }
                    tailNames.add(tailName);
                    tails2.add(tail);
                }
                continue;
            }
            String tailName = pipe.getName();
            if (!tapNames.contains(tailName)) {
                throw new PlannerException(pipe, "pipe name not found in either sink or source map: '" + tailName + "'");
            }
            if (tailNames.contains(tailName) && !tails2.contains(pipe)) {
                LOG.warn("duplicate tail name found: '{}'", (Object)tailName);
            }
            tailNames.add(tailName);
            tails2.add(pipe);
        }
        tailNames.removeAll(flowDef.getSinks().keySet());
        HashSet<String> remainingSinks = new HashSet<String>(flowDef.getSinks().keySet());
        remainingSinks.removeAll(tailNames);
        if (tailNames.size() != 0) {
            throw new PlannerException("not all tail pipes bound to sink taps, remaining tail pipe names: [" + Util.join(Util.quote(tailNames, "'"), ", ") + "], remaining sink tap names: [" + Util.join(Util.quote(remainingSinks, "'"), ", ") + "]");
        }
        remainingSinks = new HashSet<String>(flowDef.getSinks().keySet());
        remainingSinks.removeAll(Arrays.asList(Pipe.names(flowTails)));
        if (remainingSinks.size() != 0) {
            throw new PlannerException("not all sink taps bound to tail pipes, remaining sink tap names: [" + Util.join(Util.quote(remainingSinks, "'"), ", ") + "]");
        }
        HashSet<Pipe> heads2 = new HashSet<Pipe>();
        HashSet<String> headNames = new HashSet<String>();
        for (Pipe pipe : flowTails) {
            for (Pipe head2 : pipe.getHeads()) {
                String headName = head2.getName();
                if (!tapNames.contains(headName)) {
                    throw new PlannerException(head2, "pipe name not found in either sink or source map: '" + headName + "'");
                }
                if (headNames.contains(headName) && !heads2.contains(head2)) {
                    LOG.warn("duplicate head name found, not an error but heads should have unique names: '{}'", (Object)headName);
                }
                headNames.add(headName);
                heads2.add(head2);
            }
        }
        HashSet allHeadNames = new HashSet(headNames);
        headNames.removeAll(flowDef.getSources().keySet());
        HashSet<String> remainingSources = new HashSet<String>(flowDef.getSources().keySet());
        remainingSources.removeAll(headNames);
        if (headNames.size() != 0) {
            throw new PlannerException("not all head pipes bound to source taps, remaining head pipe names: [" + Util.join(Util.quote(headNames, "'"), ", ") + "], remaining source tap names: [" + Util.join(Util.quote(remainingSources, "'"), ", ") + "]");
        }
        remainingSources = new HashSet<String>(flowDef.getSources().keySet());
        remainingSources.removeAll(allHeadNames);
        if (remainingSources.size() != 0) {
            throw new PlannerException("not all source taps bound to head pipes, remaining source tap names: [" + Util.join(Util.quote(remainingSources, "'"), ", ") + "], remaining head pipe names: [" + Util.join(Util.quote(headNames, "'"), ", ") + "]");
        }
    }

    protected void verifyTraps(FlowDef flowDef, Pipe[] flowTails) {
        this.verifyNotSourcesSinks(flowDef.getTraps(), flowDef.getSources(), flowDef.getSinks(), "trap");
        HashSet<String> names2 = new HashSet<String>(Arrays.asList(Pipe.names(flowTails)));
        for (String name2 : flowDef.getTraps().keySet()) {
            if (names2.contains(name2)) continue;
            throw new PlannerException("trap name not found in assembly: '" + name2 + "'");
        }
    }

    protected void verifyCheckpoints(FlowDef flowDef, Pipe[] flowTails) {
        this.verifyNotSourcesSinks(flowDef.getCheckpoints(), flowDef.getSources(), flowDef.getSinks(), "checkpoint");
        for (Tap checkpointTap : flowDef.getCheckpoints().values()) {
            Scheme scheme = checkpointTap.getScheme();
            if (scheme.getSourceFields().equals(Fields.UNKNOWN) && scheme.getSinkFields().equals(Fields.ALL)) continue;
            throw new PlannerException("checkpoint tap scheme must be undeclared, source fields must be UNKNOWN, and sink fields ALL, got: " + scheme.toString());
        }
        HashSet<String> names2 = new HashSet<String>(Arrays.asList(Pipe.names(flowTails)));
        for (String name2 : flowDef.getCheckpoints().keySet()) {
            if (!names2.contains(name2)) {
                throw new PlannerException("checkpoint name not found in assembly: '" + name2 + "'");
            }
            HashSet<Pipe> pipes = new HashSet<Pipe>(Arrays.asList(Pipe.named(name2, flowTails)));
            int count2 = 0;
            for (Pipe pipe : pipes) {
                if (!(pipe instanceof Checkpoint)) continue;
                ++count2;
            }
            if (count2 == 0) {
                throw new PlannerException("no checkpoint with name found in assembly: '" + name2 + "'");
            }
            if (count2 <= true) continue;
            throw new PlannerException("more than one checkpoint with name found in assembly: '" + name2 + "'");
        }
    }

    private void verifyNotSourcesSinks(Map<String, Tap> taps, Map<String, Tap> sources, Map<String, Tap> sinks, String role) {
        Collection<Tap> sourceTaps = sources.values();
        Collection<Tap> sinkTaps = sinks.values();
        for (Tap tap : taps.values()) {
            if (sourceTaps.contains(tap)) {
                throw new PlannerException("tap may not be used as both a " + role + " and a source in the same Flow: " + tap);
            }
            if (!sinkTaps.contains(tap)) continue;
            throw new PlannerException("tap may not be used as both a " + role + " and a sink in the same Flow: " + tap);
        }
    }

    protected void failOnLoneGroupAssertion(ElementGraph elementGraph) {
        List<Group> groups = elementGraph.findAllGroups();
        for (Group group2 : groups) {
            for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsFrom(group2)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                int everies = 0;
                int assertions = 0;
                for (FlowElement flowElement : flowElements) {
                    if (flowElement instanceof Group) continue;
                    if (!(flowElement instanceof Every)) break;
                    ++everies;
                    Every every = (Every)flowElement;
                    if (every.getPlannerLevel() == null) continue;
                    ++assertions;
                }
                if (everies == 0 || everies != assertions) continue;
                throw new PlannerException("group assertions must be accompanied by aggregator operations");
            }
        }
    }

    protected void failOnMissingGroup(ElementGraph elementGraph) {
        List<Every> everies = elementGraph.findAllEveries();
        for (Every every : everies) {
            block1: for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsTo(every)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                Collections.reverse(flowElements);
                for (FlowElement flowElement : flowElements) {
                    if (flowElement instanceof Every || flowElement.getClass() == Pipe.class) continue;
                    if (flowElement instanceof GroupBy || flowElement instanceof CoGroup) continue block1;
                    throw new PlannerException((Pipe)flowElement, "Every may only be preceded by another Every or a Group pipe, found: " + flowElement);
                }
            }
        }
    }

    protected void failOnMisusedBuffer(ElementGraph elementGraph) {
        List<Every> everies = elementGraph.findAllEveries();
        for (Every every : everies) {
            block1: for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsTo(every)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                Collections.reverse(flowElements);
                Every last2 = null;
                boolean foundBuffer = false;
                int foundEveries = -1;
                for (FlowElement flowElement : flowElements) {
                    if (flowElement instanceof Each) {
                        throw new PlannerException((Pipe)flowElement, "Every may only be preceded by another Every or a GroupBy or CoGroup pipe, found: " + flowElement);
                    }
                    if (flowElement instanceof Every) {
                        boolean isBuffer = ((Every)flowElement).isBuffer();
                        if (++foundEveries != 0 && (isBuffer || foundBuffer)) {
                            throw new PlannerException((Pipe)flowElement, "Only one Every with a Buffer may follow a GroupBy or CoGroup pipe, no other Every instances are allowed immediately before or after, found: " + flowElement + " before: " + last2);
                        }
                        if (!foundBuffer) {
                            foundBuffer = isBuffer;
                        }
                        last2 = (Every)flowElement;
                    }
                    if (!(flowElement instanceof Group)) continue;
                    continue block1;
                }
            }
        }
    }

    protected void failOnGroupEverySplit(ElementGraph elementGraph) {
        ArrayList groups = new ArrayList();
        elementGraph.findAllOfType(1, 2, Group.class, groups);
        for (Group group2 : groups) {
            Set<FlowElement> children2 = elementGraph.getAllChildrenNotExactlyType(group2, Pipe.class);
            for (FlowElement flowElement : children2) {
                if (!(flowElement instanceof Every)) continue;
                throw new PlannerException((Every)flowElement, "Every instances may not split after a GroupBy or CoGroup pipe, found: " + flowElement + " after: " + group2);
            }
        }
    }

    protected PlannerException handleExceptionDuringPlanning(Exception exception, ElementGraph elementGraph) {
        if (exception instanceof PlannerException) {
            ((PlannerException)exception).elementGraph = elementGraph;
            return (PlannerException)exception;
        }
        if (exception instanceof ElementGraphException) {
            Throwable cause = exception.getCause();
            if (cause == null) {
                cause = exception;
            }
            String message = String.format("could not build flow from assembly: [%s]", cause.getMessage());
            if (cause instanceof OperatorException) {
                return new PlannerException(message, cause, elementGraph);
            }
            if (cause instanceof TapException) {
                return new PlannerException(message, cause, elementGraph);
            }
            return new PlannerException(((ElementGraphException)exception).getPipe(), message, cause, elementGraph);
        }
        String message = String.format("could not build flow from assembly: [%s]", exception.getMessage());
        return new PlannerException(message, exception, elementGraph);
    }

    protected void handleNonSafeOperations(ElementGraph elementGraph) {
        while (!this.internalNonSafeOperations(elementGraph)) {
        }
    }

    private boolean internalNonSafeOperations(ElementGraph elementGraph) {
        HashSet<Pipe> tapInsertions = new HashSet<Pipe>();
        List<Pipe> splits = elementGraph.findAllPipeSplits();
        for (Pipe split2 : splits) {
            List<GraphPath<FlowElement, Scope>> paths = elementGraph.getAllShortestPathsTo(split2);
            block1: for (GraphPath<FlowElement, Scope> path : paths) {
                List<FlowElement> elements = Graphs.getPathVertexList(path);
                Collections.reverse(elements);
                for (FlowElement element : elements) {
                    if (!(element instanceof Each) && element.getClass() != Pipe.class) break;
                    if (element.getClass() == Pipe.class || ((Each)element).getOperation().isSafe()) continue;
                    tapInsertions.add(split2);
                    continue block1;
                }
            }
        }
        for (Pipe pipe : tapInsertions) {
            this.insertTempTapAfter(elementGraph, pipe);
        }
        return tapInsertions.isEmpty();
    }

    protected void insertTempTapAfter(ElementGraph graph, Pipe pipe) {
        LOG.debug("inserting tap after: {}", (Object)pipe);
        Tap checkpointTap = graph.getCheckpointsMap().get(pipe.getName());
        if (checkpointTap != null) {
            LOG.info("found checkpoint: {}, using tap: {}", (Object)pipe.getName(), (Object)checkpointTap);
            checkpointTap = this.decorateTap(pipe, checkpointTap, "cascading.flowconnector.checkpoint_tap.decorator.classname");
        }
        if (checkpointTap == null) {
            if (pipe instanceof Checkpoint) {
                checkpointTap = this.makeTempTap(this.checkpointRootPath, pipe.getName());
                checkpointTap = this.decorateTap(pipe, checkpointTap, "cascading.flowconnector.checkpoint_tap.decorator.classname");
                checkpointTap.getConfigDef().setProperty(ConfigDef.Mode.DEFAULT, "cascading.checkpoint", "true");
            } else {
                checkpointTap = this.makeTempTap(pipe.getName());
            }
        }
        checkpointTap = this.decorateTap(pipe, checkpointTap, "cascading.flowconnector.temporary_tap.decorator.classname");
        graph.insertFlowElementAfter(pipe, checkpointTap);
    }

    private Tap decorateTap(Pipe pipe, Tap tempTap, String decoratorClass) {
        String decoratorClassName = PropertyUtil.getProperty(this.properties, pipe, decoratorClass);
        if (Util.isEmpty(decoratorClassName)) {
            return tempTap;
        }
        LOG.info("found decorator: {}, wrapping tap: {}", (Object)decoratorClass, (Object)tempTap);
        tempTap = (Tap)Util.newInstance(decoratorClassName, tempTap);
        return tempTap;
    }

    protected Tap makeTempTap(String name2) {
        return this.makeTempTap(null, name2);
    }

    protected abstract Tap makeTempTap(String var1, String var2);

    protected void handleJobPartitioning(ElementGraph elementGraph) {
        while (!this.internalJobPartitioning(elementGraph)) {
        }
    }

    private boolean internalJobPartitioning(ElementGraph elementGraph) {
        for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsBetweenExtents()) {
            List<FlowElement> flowElements = Graphs.getPathVertexList(path);
            ArrayList<Pipe> tapInsertions = new ArrayList<Pipe>();
            boolean foundGroup = false;
            for (int i = 0; i < flowElements.size(); ++i) {
                FlowElement flowElement = flowElements.get(i);
                if (flowElement instanceof ElementGraph.Extent || flowElement instanceof Tap && flowElements.get(i - 1) instanceof ElementGraph.Extent) continue;
                if (flowElement instanceof Group && !foundGroup) {
                    foundGroup = true;
                    continue;
                }
                if (flowElement instanceof Splice && foundGroup) {
                    tapInsertions.add((Pipe)flowElements.get(i - 1));
                    if (flowElement instanceof Group) continue;
                    foundGroup = false;
                    continue;
                }
                if (flowElement instanceof Checkpoint) {
                    if (flowElements.get(i + 1) instanceof Tap) continue;
                    tapInsertions.add((Pipe)flowElement);
                    foundGroup = false;
                    continue;
                }
                if (!(flowElement instanceof Tap)) continue;
                foundGroup = false;
            }
            for (Pipe pipe : tapInsertions) {
                this.insertTempTapAfter(elementGraph, pipe);
            }
            if (tapInsertions.isEmpty()) continue;
            return false;
        }
        return true;
    }

    protected void handleJoins(ElementGraph elementGraph) {
        while (!this.internalJoins(elementGraph)) {
        }
    }

    private boolean internalJoins(ElementGraph elementGraph) {
        List<GraphPath<FlowElement, Scope>> paths = elementGraph.getAllShortestPathsBetweenExtents();
        Collections.reverse(paths);
        for (GraphPath<FlowElement, Scope> path : paths) {
            List<FlowElement> flowElements = Graphs.getPathVertexList(path);
            ArrayList<Pipe> tapInsertions = new ArrayList<Pipe>();
            ArrayList<HashJoin> joins = new ArrayList<HashJoin>();
            ArrayList<Merge> merges = new ArrayList<Merge>();
            FlowElement lastSourceElement = null;
            for (int i = 0; i < flowElements.size(); ++i) {
                FlowElement flowElement = flowElements.get(i);
                if (flowElement instanceof Merge) {
                    merges.add((Merge)flowElement);
                    continue;
                }
                if (flowElement instanceof HashJoin) {
                    int joinPos;
                    int mergePos;
                    HashJoin join2 = (HashJoin)flowElement;
                    Map<Integer, Integer> pathCounts = ElementGraphs.countOrderedDirectPathsBetween(elementGraph, lastSourceElement, join2, true);
                    int pathPosition = ElementGraphs.pathPositionInto(path, join2);
                    boolean thisPathIsStreamed = pathPosition == 0;
                    boolean isAccumulatedAndStreamed = ElementGraphs.isBothAccumulatedAndStreamedPath(pathCounts);
                    int pathCount = ElementGraphs.countPaths(pathCounts);
                    int priorJoins = ElementGraphs.countTypesBetween(elementGraph, lastSourceElement, join2, HashJoin.class);
                    if (priorJoins == 0) {
                        if (pathCount == 2 && isAccumulatedAndStreamed && !thisPathIsStreamed) {
                            tapInsertions.add((Pipe)flowElements.get(flowElements.indexOf(join2) - 1));
                            break;
                        }
                        if (pathCount > 2 && isAccumulatedAndStreamed && thisPathIsStreamed) {
                            tapInsertions.add((Pipe)flowElements.get(flowElements.indexOf(join2) - 1));
                            break;
                        }
                    }
                    if (!merges.isEmpty() && (mergePos = this.nearest(flowElements, joinPos = flowElements.indexOf(join2), merges)) != -1 && joinPos > mergePos && (isAccumulatedAndStreamed && thisPathIsStreamed || !thisPathIsStreamed)) {
                        tapInsertions.add((Pipe)flowElements.get(flowElements.indexOf(join2) - 1));
                        break;
                    }
                    joins.add((HashJoin)flowElement);
                    continue;
                }
                if (!(flowElement instanceof Tap) && !(flowElement instanceof Group)) continue;
                if (flowElement instanceof Group && !joins.isEmpty()) {
                    ArrayList<Splice> splices = new ArrayList<Splice>();
                    splices.addAll(merges);
                    splices.add((Splice)flowElement);
                    Collections.reverse(splices);
                    for (Splice splice : splices) {
                        Map<Integer, Integer> pathCounts = ElementGraphs.countOrderedDirectPathsBetween(elementGraph, lastSourceElement, splice, true);
                        if (!ElementGraphs.isBothAccumulatedAndStreamedPath(pathCounts)) continue;
                        tapInsertions.add((Pipe)flowElements.get(flowElements.indexOf(splice) - 1));
                        break;
                    }
                    if (!tapInsertions.isEmpty()) break;
                }
                for (int j = 0; j < joins.size(); ++j) {
                    HashJoin join3 = (HashJoin)joins.get(j);
                    int pathPosition = ElementGraphs.pathPositionInto(path, join3);
                    boolean thisPathIsStreamed = pathPosition == 0;
                    Map<Integer, Integer> pathCounts = ElementGraphs.countOrderedDirectPathsBetween(elementGraph, lastSourceElement, join3, true);
                    boolean isAccumulatedAndStreamed = ElementGraphs.isBothAccumulatedAndStreamedPath(pathCounts);
                    int pathCount = ElementGraphs.countPaths(pathCounts);
                    if (pathCount >= 2 && isAccumulatedAndStreamed && thisPathIsStreamed) {
                        tapInsertions.add((Pipe)flowElements.get(flowElements.indexOf(join3) - 1));
                        break;
                    }
                    if (thisPathIsStreamed) continue;
                    if (j == 0) break;
                    tapInsertions.add((Pipe)flowElements.get(flowElements.indexOf(join3) - 1));
                    break;
                }
                if (!tapInsertions.isEmpty()) break;
                lastSourceElement = flowElement;
                merges.clear();
                joins.clear();
            }
            for (Pipe pipe : tapInsertions) {
                this.insertTempTapAfter(elementGraph, pipe);
            }
            if (tapInsertions.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private int nearest(List<FlowElement> flowElements, int index2, List<Merge> merges) {
        ArrayList<Merge> reversed2 = new ArrayList<Merge>(merges);
        Collections.reverse(reversed2);
        for (Merge merge2 : reversed2) {
            int pos = flowElements.indexOf(merge2);
            if (pos >= index2) continue;
            return pos;
        }
        return -1;
    }
}

