/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.FlowElement;
import cascading.flow.planner.Scope;
import cascading.pipe.Group;
import cascading.pipe.Splice;
import cascading.tap.Tap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.SimpleDirectedGraph;

public class ElementGraphs {
    public static List<GraphPath<FlowElement, Scope>> getAllShortestPathsBetween(SimpleDirectedGraph<FlowElement, Scope> graph, FlowElement from2, FlowElement to2) {
        List<GraphPath<FlowElement, Scope>> paths = new KShortestPaths<FlowElement, Scope>(graph, from2, Integer.MAX_VALUE).getPaths(to2);
        if (paths == null) {
            return new ArrayList<GraphPath<FlowElement, Scope>>();
        }
        return paths;
    }

    public static List<List<FlowElement>> asPathList(List<GraphPath<FlowElement, Scope>> paths) {
        LinkedList<List<FlowElement>> results2 = new LinkedList<List<FlowElement>>();
        if (paths == null) {
            return results2;
        }
        for (GraphPath<FlowElement, Scope> path : paths) {
            results2.add(Graphs.getPathVertexList(path));
        }
        return results2;
    }

    public static List<GraphPath<FlowElement, Scope>> getAllDirectPathsBetween(SimpleDirectedGraph<FlowElement, Scope> graph, FlowElement from2, FlowElement to2) {
        List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllShortestPathsBetween(graph, from2, to2);
        ArrayList<GraphPath<FlowElement, Scope>> results2 = new ArrayList<GraphPath<FlowElement, Scope>>(paths);
        block0: for (GraphPath<FlowElement, Scope> path : paths) {
            List<FlowElement> pathVertexList = Graphs.getPathVertexList(path);
            for (int i = 1; i < pathVertexList.size() - 1; ++i) {
                FlowElement flowElement = pathVertexList.get(i);
                if (!(flowElement instanceof Tap) && !(flowElement instanceof Group)) continue;
                results2.remove(path);
                continue block0;
            }
        }
        return results2;
    }

    public static int countTypesBetween(SimpleDirectedGraph<FlowElement, Scope> graph, FlowElement from2, Splice to2, Class type) {
        List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllDirectPathsBetween(graph, from2, to2);
        int count2 = 0;
        for (GraphPath<FlowElement, Scope> path : paths) {
            if (ElementGraphs.hasIntermediateTap(path, from2)) continue;
            List<FlowElement> flowElements = Graphs.getPathVertexList(path);
            for (FlowElement flowElement : flowElements) {
                if (!type.isInstance(flowElement) || flowElement == to2) continue;
                ++count2;
            }
        }
        return count2;
    }

    public static Map<Integer, Integer> countOrderedDirectPathsBetween(SimpleDirectedGraph<FlowElement, Scope> graph, FlowElement from2, Splice to2) {
        return ElementGraphs.countOrderedDirectPathsBetween(graph, from2, to2, false);
    }

    public static Map<Integer, Integer> countOrderedDirectPathsBetween(SimpleDirectedGraph<FlowElement, Scope> graph, FlowElement from2, Splice to2, boolean skipTaps) {
        List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllDirectPathsBetween(graph, from2, to2);
        HashMap<Integer, Integer> results2 = new HashMap<Integer, Integer>();
        for (GraphPath<FlowElement, Scope> path : paths) {
            if (skipTaps && ElementGraphs.hasIntermediateTap(path, from2)) continue;
            ElementGraphs.pathPositionInto(results2, path, to2);
        }
        return results2;
    }

    public static boolean isBothAccumulatedAndStreamedPath(Map<Integer, Integer> pathCounts) {
        return pathCounts.size() > 1 && pathCounts.containsKey(0);
    }

    public static boolean isOnlyStreamedPath(Map<Integer, Integer> pathCounts) {
        return pathCounts.size() == 1 && pathCounts.containsKey(0);
    }

    public static boolean isOnlyAccumulatedPath(Map<Integer, Integer> pathCounts) {
        return pathCounts.size() >= 1 && !pathCounts.containsKey(0);
    }

    public static int countPaths(Map<Integer, Integer> pathCounts) {
        int count2 = 0;
        for (Integer integer : pathCounts.values()) {
            count2 += integer.intValue();
        }
        return count2;
    }

    private static boolean hasIntermediateTap(GraphPath<FlowElement, Scope> path, FlowElement from2) {
        List<FlowElement> flowElements = Graphs.getPathVertexList(path);
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof Tap) || flowElement == from2) continue;
            return true;
        }
        return false;
    }

    public static int pathPositionInto(GraphPath<FlowElement, Scope> path, Splice to2) {
        List<FlowElement> flowElements = Graphs.getPathVertexList(path);
        List<Scope> scopes = path.getEdgeList();
        int index2 = flowElements.indexOf(to2);
        return to2.getPipePos().get(scopes.get(index2 - 1).getName());
    }

    private static Map<Integer, Integer> pathPositionInto(Map<Integer, Integer> results2, GraphPath<FlowElement, Scope> path, Splice to2) {
        List<Scope> scopes = path.getEdgeList();
        Scope lastScope = scopes.get(scopes.size() - 1);
        Integer pos = to2.getPipePos().get(lastScope.getName());
        if (results2.containsKey(pos)) {
            results2.put(pos, results2.get(pos) + 1);
        } else {
            results2.put(pos, 1);
        }
        return results2;
    }
}

