/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.FlowElement;
import cascading.flow.planner.ElementGraphException;
import cascading.flow.planner.ElementGraphs;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.operation.PlannedOperation;
import cascading.operation.PlannerLevel;
import cascading.pipe.Checkpoint;
import cascading.pipe.CoGroup;
import cascading.pipe.Each;
import cascading.pipe.Every;
import cascading.pipe.Group;
import cascading.pipe.Operator;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.pipe.SubAssembly;
import cascading.tap.Tap;
import cascading.util.Util;
import cascading.util.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.ext.EdgeNameProvider;
import org.jgrapht.ext.IntegerNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementGraph
extends SimpleDirectedGraph<FlowElement, Scope> {
    private static final Logger LOG = LoggerFactory.getLogger(ElementGraph.class);
    public static final Extent head = new Extent("head");
    public static final Extent tail = new Extent("tail");
    private boolean resolved;
    private PlatformInfo platformInfo;
    private Map<String, Tap> sources;
    private Map<String, Tap> sinks;
    private Map<String, Tap> traps;
    private Map<String, Tap> checkpoints;
    private boolean requireUniqueCheckpoints;
    private PlannerLevel[] plannerLevels;

    ElementGraph() {
        super(Scope.class);
    }

    public ElementGraph(ElementGraph elementGraph) {
        this();
        this.platformInfo = elementGraph.platformInfo;
        this.sources = elementGraph.sources;
        this.sinks = elementGraph.sinks;
        this.traps = elementGraph.traps;
        this.checkpoints = elementGraph.checkpoints;
        this.plannerLevels = elementGraph.plannerLevels;
        this.requireUniqueCheckpoints = elementGraph.requireUniqueCheckpoints;
        Graphs.addAllVertices(this, elementGraph.vertexSet());
        Graphs.addAllEdges(this, elementGraph, elementGraph.edgeSet());
    }

    public ElementGraph(PlatformInfo platformInfo, Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks, Map<String, Tap> traps, Map<String, Tap> checkpoints, boolean requireUniqueCheckpoints, PlannerLevel ... plannerLevels) {
        super(Scope.class);
        this.platformInfo = platformInfo;
        this.sources = sources;
        this.sinks = sinks;
        this.traps = traps;
        this.checkpoints = checkpoints;
        this.requireUniqueCheckpoints = requireUniqueCheckpoints;
        this.plannerLevels = plannerLevels;
        this.assembleGraph(pipes, sources, sinks);
        this.verifyGraph();
    }

    public Map<String, Tap> getSourceMap() {
        return this.sources;
    }

    public Map<String, Tap> getSinkMap() {
        return this.sinks;
    }

    public Map<String, Tap> getTrapMap() {
        return this.traps;
    }

    public Map<String, Tap> getCheckpointsMap() {
        return this.checkpoints;
    }

    public Collection<Tap> getSources() {
        return this.sources.values();
    }

    public Collection<Tap> getSinks() {
        return this.sinks.values();
    }

    public Collection<Tap> getTraps() {
        return this.traps.values();
    }

    private void assembleGraph(Pipe[] pipes, Map<String, Tap> sources, Map<String, Tap> sinks) {
        HashMap<String, Tap> sourcesCopy = new HashMap<String, Tap>(sources);
        HashMap<String, Tap> sinksCopy = new HashMap<String, Tap>(sinks);
        for (Pipe pipe : pipes) {
            this.makeGraph(pipe, sourcesCopy, sinksCopy);
        }
        this.addExtents(sources, sinks);
    }

    private void verifyGraph() {
        if (this.vertexSet().isEmpty()) {
            return;
        }
        HashSet<String> checkpointNames = new HashSet<String>();
        TopologicalOrderIterator<FlowElement, Scope> iterator2 = this.getTopologicalIterator();
        FlowElement flowElement = null;
        while (iterator2.hasNext()) {
            try {
                flowElement = (FlowElement)iterator2.next();
            }
            catch (IllegalArgumentException exception) {
                if (flowElement == null) {
                    throw new ElementGraphException("unable to traverse to the first element");
                }
                throw new ElementGraphException(flowElement, "unable to traverse to the next element after " + flowElement);
            }
            if (this.requireUniqueCheckpoints && flowElement instanceof Checkpoint) {
                String name2 = ((Checkpoint)flowElement).getName();
                if (checkpointNames.contains(name2)) {
                    throw new ElementGraphException((Pipe)flowElement, "may not have duplicate checkpoint names in assembly, found: " + name2);
                }
                checkpointNames.add(name2);
            }
            if (this.incomingEdgesOf(flowElement).size() != 0 && this.outgoingEdgesOf(flowElement).size() != 0 || flowElement instanceof Extent) continue;
            if (flowElement instanceof Pipe) {
                if (this.incomingEdgesOf(flowElement).size() == 0) {
                    throw new ElementGraphException((Pipe)flowElement, "no Tap connected to head Pipe: " + flowElement + ", possible ambiguous branching, try explicitly naming heads");
                }
                throw new ElementGraphException((Pipe)flowElement, "no Tap connected to tail Pipe: " + flowElement + ", possible ambiguous branching, try explicitly naming tails");
            }
            if (flowElement instanceof Tap) {
                throw new ElementGraphException((Tap)flowElement, "no Pipe connected to Tap: " + flowElement);
            }
            throw new ElementGraphException(flowElement, "unknown element type: " + flowElement);
        }
    }

    public ElementGraph copyElementGraph() {
        ElementGraph copy = new ElementGraph();
        Graphs.addGraph(copy, this);
        copy.traps = new HashMap<String, Tap>(this.traps);
        return copy;
    }

    private void addExtents(Map<String, Tap> sources, Map<String, Tap> sinks) {
        Scope scope;
        this.addVertex(head);
        for (String source2 : sources.keySet()) {
            scope = (Scope)this.addEdge(head, sources.get(source2));
            if (scope == null) continue;
            scope.setName(source2);
        }
        this.addVertex(tail);
        for (String sink2 : sinks.keySet()) {
            try {
                scope = (Scope)this.addEdge(sinks.get(sink2), tail);
            }
            catch (IllegalArgumentException exception) {
                throw new ElementGraphException("missing pipe for sink tap: [" + sink2 + "]");
            }
            if (scope == null) {
                throw new ElementGraphException("cannot sink to the same path from multiple branches: [" + Util.join(sinks.values()) + "]");
            }
            scope.setName(sink2);
        }
    }

    private void makeGraph(Pipe current, Map<String, Tap> sources, Map<String, Tap> sinks) {
        Tap source2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("adding pipe: " + current);
        }
        if (current instanceof SubAssembly) {
            for (Pipe pipe : SubAssembly.unwind(current.getPrevious())) {
                this.makeGraph(pipe, sources, sinks);
            }
            return;
        }
        if (this.containsVertex(current)) {
            return;
        }
        this.addVertex(current);
        Tap sink2 = sinks.remove(current.getName());
        if (sink2 != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding sink: " + sink2);
            }
            this.addVertex(sink2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding edge: " + current + " -> " + sink2);
            }
            ((Scope)this.addEdge(current, sink2)).setName(current.getName());
        }
        if (SubAssembly.unwind(current.getPrevious()).length == 0 && (source2 = sources.remove(current.getName())) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding source: " + source2);
            }
            this.addVertex(source2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding edge: " + source2 + " -> " + current);
            }
            ((Scope)this.addEdge(source2, current)).setName(current.getName());
        }
        for (Pipe previous : SubAssembly.unwind(current.getPrevious())) {
            this.makeGraph(previous, sources, sinks);
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding edge: " + previous + " -> " + current);
            }
            if (this.getEdge(previous, current) != null) {
                throw new ElementGraphException(previous, "cannot distinguish pipe branches, give pipe unique name: " + previous);
            }
            ((Scope)this.addEdge(previous, current)).setName(previous.getName());
        }
    }

    public TopologicalOrderIterator<FlowElement, Scope> getTopologicalIterator() {
        return new TopologicalOrderIterator<FlowElement, Scope>(this);
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsFrom(FlowElement flowElement) {
        return ElementGraphs.getAllShortestPathsBetween(this, flowElement, tail);
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsTo(FlowElement flowElement) {
        return ElementGraphs.getAllShortestPathsBetween(this, head, flowElement);
    }

    public List<GraphPath<FlowElement, Scope>> getAllShortestPathsBetweenExtents() {
        List<GraphPath<FlowElement, Scope>> paths = new KShortestPaths<Extent, Scope>(this, head, Integer.MAX_VALUE).getPaths(tail);
        if (paths == null) {
            return new ArrayList<GraphPath<FlowElement, Scope>>();
        }
        return paths;
    }

    public DepthFirstIterator<FlowElement, Scope> getDepthFirstIterator() {
        return new DepthFirstIterator<FlowElement, Scope>(this, head);
    }

    private SimpleDirectedGraph<FlowElement, Scope> copyWithTraps() {
        ElementGraph copy = this.copyElementGraph();
        copy.addTraps();
        return copy;
    }

    private void addTraps() {
        DepthFirstIterator<FlowElement, Scope> iterator2 = this.getDepthFirstIterator();
        while (iterator2.hasNext()) {
            Pipe pipe;
            Tap trap;
            FlowElement element = (FlowElement)iterator2.next();
            if (!(element instanceof Pipe) || (trap = this.traps.get((pipe = (Pipe)element).getName())) == null) continue;
            this.addVertex(trap);
            if (LOG.isDebugEnabled()) {
                LOG.debug("adding trap edge: " + pipe + " -> " + trap);
            }
            if (this.getEdge(pipe, trap) != null) continue;
            ((Scope)this.addEdge(pipe, trap)).setName(pipe.getName());
        }
    }

    public void writeDOT(String filename) {
        this.printElementGraph(filename, this.copyWithTraps());
    }

    protected void printElementGraph(String filename, final SimpleDirectedGraph<FlowElement, Scope> graph) {
        try {
            File parentFile = new File(filename).getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            FileWriter writer = new FileWriter(filename);
            Util.writeDOT(writer, graph, new IntegerNameProvider(), new VertexNameProvider<FlowElement>(){

                @Override
                public String getVertexName(FlowElement object) {
                    if (graph.incomingEdgesOf(object).isEmpty()) {
                        String result2 = object.toString().replaceAll("\"", "'");
                        String versionString = Version.getRelease();
                        if (ElementGraph.this.platformInfo != null) {
                            versionString = (versionString == null ? "" : versionString + "\\n") + ElementGraph.this.platformInfo;
                        }
                        return versionString == null ? result2 : result2 + "\\n" + versionString;
                    }
                    if (object instanceof Tap || object instanceof Extent) {
                        return object.toString().replaceAll("\"", "'");
                    }
                    Scope scope = (Scope)graph.outgoingEdgesOf(object).iterator().next();
                    return ((Pipe)object).print(scope).replaceAll("\"", "'");
                }
            }, new EdgeNameProvider<Scope>(){

                @Override
                public String getEdgeName(Scope object) {
                    return object.toString().replaceAll("\"", "'").replaceAll("\n", "\\\\n");
                }
            });
            ((Writer)writer).close();
        }
        catch (IOException exception) {
            LOG.error("failed printing graph to: {}, with exception: {}", (Object)filename, (Object)exception);
        }
    }

    public void removeUnnecessaryPipes() {
        while (!this.internalRemoveUnnecessaryPipes()) {
        }
        int numPipes = 0;
        for (FlowElement flowElement : this.vertexSet()) {
            if (!(flowElement instanceof Pipe)) continue;
            ++numPipes;
        }
        if (numPipes == 0) {
            throw new ElementGraphException("resulting graph has no pipe elements after removing empty Pipe, assertions, and SubAssembly containers");
        }
    }

    private boolean internalRemoveUnnecessaryPipes() {
        DepthFirstIterator<FlowElement, Scope> iterator2 = this.getDepthFirstIterator();
        while (iterator2.hasNext()) {
            FlowElement flowElement = (FlowElement)iterator2.next();
            if (flowElement.getClass() != Pipe.class && flowElement.getClass() != Checkpoint.class && !(flowElement instanceof SubAssembly) && !this.testPlannerLevel(flowElement)) continue;
            this.removeElement(flowElement);
            return false;
        }
        return true;
    }

    private void removeElement(FlowElement flowElement) {
        LOG.debug("removing: " + flowElement);
        Set incomingScopes = this.incomingEdgesOf(flowElement);
        if (incomingScopes.size() != 1) {
            throw new IllegalStateException("flow element:" + flowElement + ", has multiple input paths: " + incomingScopes.size());
        }
        Scope incoming = (Scope)incomingScopes.iterator().next();
        Set outgoingScopes = this.outgoingEdgesOf(flowElement);
        FlowElement source2 = (FlowElement)this.getEdgeSource(incoming);
        for (Scope outgoing : outgoingScopes) {
            FlowElement target = (FlowElement)this.getEdgeTarget(outgoing);
            this.addEdge(source2, target, new Scope(outgoing));
        }
        this.removeVertex(flowElement);
    }

    private boolean testPlannerLevel(FlowElement flowElement) {
        if (!(flowElement instanceof Operator)) {
            return false;
        }
        Operator operator = (Operator)flowElement;
        if (!operator.hasPlannerLevel()) {
            return false;
        }
        for (PlannerLevel plannerLevel : this.plannerLevels) {
            if (!((PlannedOperation)operator.getOperation()).supportsPlannerLevel(plannerLevel)) continue;
            return operator.getPlannerLevel().isStricterThan(plannerLevel);
        }
        throw new IllegalStateException("encountered unsupported planner level: " + operator.getPlannerLevel().getClass().getName());
    }

    public void resolveFields() {
        if (this.resolved) {
            throw new IllegalStateException("element graph already resolved");
        }
        TopologicalOrderIterator<FlowElement, Scope> iterator2 = this.getTopologicalIterator();
        while (iterator2.hasNext()) {
            this.resolveFields((FlowElement)iterator2.next());
        }
        this.resolved = true;
    }

    private void resolveFields(FlowElement source2) {
        if (source2 instanceof Extent) {
            return;
        }
        Set<Scope> incomingScopes = this.incomingEdgesOf(source2);
        Set outgoingScopes = this.outgoingEdgesOf(source2);
        List<FlowElement> flowElements = Graphs.successorListOf(this, source2);
        if (flowElements.size() == 0) {
            throw new IllegalStateException("unable to find next elements in pipeline from: " + source2.toString());
        }
        Scope outgoingScope = source2.outgoingScopeFor(incomingScopes);
        if (LOG.isDebugEnabled() && outgoingScope != null) {
            LOG.debug("for modifier: " + source2);
            if (outgoingScope.getArgumentsSelector() != null) {
                LOG.debug("setting outgoing arguments: " + outgoingScope.getArgumentsSelector());
            }
            if (outgoingScope.getOperationDeclaredFields() != null) {
                LOG.debug("setting outgoing declared: " + outgoingScope.getOperationDeclaredFields());
            }
            if (outgoingScope.getKeySelectors() != null) {
                LOG.debug("setting outgoing group: " + outgoingScope.getKeySelectors());
            }
            if (outgoingScope.getOutValuesSelector() != null) {
                LOG.debug("setting outgoing values: " + outgoingScope.getOutValuesSelector());
            }
        }
        for (Scope scope : outgoingScopes) {
            scope.copyFields(outgoingScope);
        }
    }

    public List<Group> findAllMergeJoinGroups() {
        return this.findAllOfType(2, 1, Group.class, new LinkedList());
    }

    public List<Splice> findAllMergeJoinSplices() {
        return this.findAllOfType(2, 1, Splice.class, new LinkedList());
    }

    public List<CoGroup> findAllCoGroups() {
        return this.findAllOfType(2, 1, CoGroup.class, new LinkedList());
    }

    public List<Group> findAllGroups() {
        return this.findAllOfType(1, 1, Group.class, new LinkedList());
    }

    public List<Every> findAllEveries() {
        return this.findAllOfType(1, 1, Every.class, new LinkedList());
    }

    public List<Tap> findAllTaps() {
        return this.findAllOfType(1, 1, Tap.class, new LinkedList());
    }

    public List<Each> findAllEachSplits() {
        return this.findAllOfType(1, 2, Each.class, new LinkedList());
    }

    public List<Pipe> findAllPipeSplits() {
        return this.findAllOfType(1, 2, Pipe.class, new LinkedList());
    }

    public <P> List<P> findAllOfType(int minInDegree, int minOutDegree, Class<P> type, List<P> results2) {
        TopologicalOrderIterator<FlowElement, Scope> topoIterator = this.getTopologicalIterator();
        while (topoIterator.hasNext()) {
            FlowElement flowElement = (FlowElement)topoIterator.next();
            if (!type.isInstance(flowElement) || this.inDegreeOf(flowElement) < minInDegree || this.outDegreeOf(flowElement) < minOutDegree) continue;
            results2.add(flowElement);
        }
        return results2;
    }

    public void insertFlowElementAfter(FlowElement previousElement, FlowElement flowElement) {
        HashSet outgoing = new HashSet(this.outgoingEdgesOf(previousElement));
        this.addVertex(flowElement);
        String name2 = previousElement.toString();
        if (previousElement instanceof Pipe) {
            name2 = ((Pipe)previousElement).getName();
        }
        this.addEdge(previousElement, flowElement, new Scope(name2));
        for (Scope scope : outgoing) {
            FlowElement target = (FlowElement)this.getEdgeTarget(scope);
            this.removeEdge(previousElement, target);
            this.addEdge(flowElement, target, scope);
        }
    }

    public SimpleDirectedGraph<Tap, Integer> makeTapGraph() {
        SimpleDirectedGraph<Tap, Integer> tapGraph = new SimpleDirectedGraph<Tap, Integer>(Integer.class);
        List<GraphPath<FlowElement, Scope>> paths = this.getAllShortestPathsBetweenExtents();
        int count2 = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug("found num paths: " + paths.size());
        }
        for (GraphPath<FlowElement, Scope> element : paths) {
            List<Scope> path = element.getEdgeList();
            Tap lastTap = null;
            for (Scope scope : path) {
                FlowElement target = (FlowElement)this.getEdgeTarget(scope);
                if (target instanceof Extent || !(target instanceof Tap)) continue;
                tapGraph.addVertex((Tap)target);
                if (lastTap != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("adding tap edge: " + lastTap + " -> " + target);
                    }
                    if (tapGraph.getEdge(lastTap, (Tap)target) == null && !tapGraph.addEdge(lastTap, (Tap)target, count2++)) {
                        throw new ElementGraphException("could not add graph edge: " + lastTap + " -> " + target);
                    }
                }
                lastTap = (Tap)target;
            }
        }
        return tapGraph;
    }

    public int getMaxNumPathsBetweenElementAndGroupingMergeJoin(FlowElement flowElement) {
        List<Group> groups = this.findAllMergeJoinGroups();
        int maxPaths = 0;
        if (groups == null) {
            return 0;
        }
        for (Group group2 : groups) {
            List<GraphPath<FlowElement, Scope>> paths;
            if (flowElement == group2 || (paths = ElementGraphs.getAllShortestPathsBetween(this, flowElement, group2)) == null) continue;
            maxPaths = Math.max(maxPaths, paths.size());
        }
        return maxPaths;
    }

    public List<FlowElement> getAllSuccessors(FlowElement element) {
        return Graphs.successorListOf(this, element);
    }

    public void replaceElementWith(FlowElement element, FlowElement replacement) {
        HashSet incoming = new HashSet(this.incomingEdgesOf(element));
        HashSet outgoing = new HashSet(this.outgoingEdgesOf(element));
        if (!this.containsVertex(replacement)) {
            this.addVertex(replacement);
        }
        for (Scope scope : incoming) {
            FlowElement source2 = (FlowElement)this.getEdgeSource(scope);
            this.removeEdge(source2, element);
            if (source2 == replacement) continue;
            this.addEdge(source2, replacement, scope);
        }
        for (Scope scope : outgoing) {
            FlowElement target = (FlowElement)this.getEdgeTarget(scope);
            this.removeEdge(element, target);
            if (target == replacement) continue;
            this.addEdge(replacement, target, scope);
        }
        this.removeVertex(element);
    }

    public <A extends FlowElement> Set<A> getAllChildrenOfType(FlowElement flowElement, Class<A> type) {
        HashSet allChildren = new HashSet();
        this.getAllChildrenOfType(allChildren, flowElement, type);
        return allChildren;
    }

    private <A extends FlowElement> void getAllChildrenOfType(Set<A> allSuccessors, FlowElement flowElement, Class<A> type) {
        List<FlowElement> successors = this.getAllSuccessors(flowElement);
        for (FlowElement successor : successors) {
            if (type.isInstance(successor)) {
                allSuccessors.add(successor);
                continue;
            }
            this.getAllChildrenOfType(allSuccessors, successor, type);
        }
    }

    public Set<FlowElement> getAllChildrenNotExactlyType(FlowElement flowElement, Class<? extends FlowElement> type) {
        HashSet<FlowElement> allChildren = new HashSet<FlowElement>();
        this.getAllChildrenNotExactlyType(allChildren, flowElement, type);
        return allChildren;
    }

    private void getAllChildrenNotExactlyType(Set<FlowElement> allSuccessors, FlowElement flowElement, Class<? extends FlowElement> type) {
        List<FlowElement> successors = this.getAllSuccessors(flowElement);
        for (FlowElement successor : successors) {
            if (type != successor.getClass()) {
                allSuccessors.add(successor);
                continue;
            }
            this.getAllChildrenNotExactlyType(allSuccessors, successor, type);
        }
    }

    public static class Extent
    extends Pipe {
        public Extent(String name2) {
            super(name2);
        }

        @Override
        public Scope outgoingScopeFor(Set<Scope> scopes) {
            return new Scope();
        }

        @Override
        public String toString() {
            return "[" + this.getName() + "]";
        }

        @Override
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            return this.getName().equals(((Pipe)object).getName());
        }
    }
}

