/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.planner;

import cascading.flow.Flow;
import cascading.flow.FlowElement;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowStep;
import cascading.flow.FlowStepListener;
import cascading.flow.planner.FlowStepJob;
import cascading.flow.planner.Scope;
import cascading.management.CascadingServices;
import cascading.management.state.ClientState;
import cascading.operation.Operation;
import cascading.pipe.Group;
import cascading.pipe.HashJoin;
import cascading.pipe.Merge;
import cascading.pipe.Operator;
import cascading.pipe.Pipe;
import cascading.property.ConfigDef;
import cascading.stats.FlowStepStats;
import cascading.tap.Tap;
import cascading.util.Util;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFlowStep<Config>
implements Serializable,
FlowStep<Config> {
    private static final Logger LOG = LoggerFactory.getLogger(FlowStep.class);
    private transient Flow<Config> flow;
    private String flowName;
    private String flowID;
    private transient Config conf;
    private int submitPriority = 5;
    String name;
    private String id;
    private final int stepNum;
    private List<SafeFlowStepListener> listeners;
    private final SimpleDirectedGraph<FlowElement, Scope> graph = new SimpleDirectedGraph(Scope.class);
    protected final Map<Tap, Set<String>> sources = new HashMap<Tap, Set<String>>();
    protected final Map<Tap, Set<String>> sinks = new HashMap<Tap, Set<String>>();
    protected Tap tempSink;
    private final List<Group> groups = new ArrayList<Group>();
    protected final Map<HashJoin, Tap> streamedSourceByJoin = new LinkedHashMap<HashJoin, Tap>();
    protected final Map<HashJoin, Set<Tap>> accumulatedSourcesByJoin = new LinkedHashMap<HashJoin, Set<Tap>>();
    private transient FlowStepJob<Config> flowStepJob;

    protected BaseFlowStep(String name2, int stepNum) {
        this.setName(name2);
        this.stepNum = stepNum;
    }

    @Override
    public String getID() {
        if (this.id == null) {
            this.id = Util.createUniqueID();
        }
        return this.id;
    }

    @Override
    public int getStepNum() {
        return this.stepNum;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name2) {
        if (name2 == null || name2.isEmpty()) {
            throw new IllegalArgumentException("step name may not be null or empty");
        }
        this.name = name2;
    }

    public void setFlow(Flow<Config> flow) {
        this.flow = flow;
        this.flowID = flow.getID();
        this.flowName = flow.getName();
    }

    @Override
    public Flow<Config> getFlow() {
        return this.flow;
    }

    @Override
    public String getFlowID() {
        return this.flowID;
    }

    @Override
    public String getFlowName() {
        return this.flowName;
    }

    protected void setFlowName(String flowName) {
        this.flowName = flowName;
    }

    @Override
    public Config getConfig() {
        return this.conf;
    }

    protected void setConf(Config conf) {
        this.conf = conf;
    }

    @Override
    public String getStepDisplayName() {
        return this.getStepDisplayName(Util.ID_LENGTH);
    }

    protected String getStepDisplayName(int idLength) {
        if (idLength > Util.ID_LENGTH) {
            idLength = Util.ID_LENGTH;
        }
        String flowID = this.getFlowID().substring(0, idLength);
        String stepID = this.getID().substring(0, idLength);
        return String.format("[%s/%s] %s/%s", flowID, stepID, this.getFlowName(), this.getName());
    }

    @Override
    public int getSubmitPriority() {
        return this.submitPriority;
    }

    @Override
    public void setSubmitPriority(int submitPriority) {
        if (submitPriority < 1 || submitPriority > 10) {
            throw new IllegalArgumentException("submitPriority must be between 1 and 10 inclusive, was: " + submitPriority);
        }
        this.submitPriority = submitPriority;
    }

    @Override
    public FlowStepStats getFlowStepStats() {
        return this.flowStepJob.getStepStats();
    }

    public SimpleDirectedGraph<FlowElement, Scope> getGraph() {
        return this.graph;
    }

    @Override
    public Group getGroup() {
        if (this.groups.isEmpty()) {
            return null;
        }
        if (this.groups.size() > 1) {
            throw new IllegalStateException("more than one group");
        }
        return this.groups.get(0);
    }

    @Override
    public List<Group> getGroups() {
        return this.groups;
    }

    public void addGroup(Group group2) {
        if (!this.groups.contains(group2)) {
            this.groups.add(group2);
        }
    }

    @Override
    public Map<HashJoin, Tap> getStreamedSourceByJoin() {
        return this.streamedSourceByJoin;
    }

    public void addStreamedSourceFor(HashJoin join2, Tap streamedSource) {
        this.streamedSourceByJoin.put(join2, streamedSource);
    }

    @Override
    public Set<Tap> getAllAccumulatedSources() {
        HashSet<Tap> set2 = new HashSet<Tap>();
        for (Set<Tap> taps : this.accumulatedSourcesByJoin.values()) {
            set2.addAll(taps);
        }
        return set2;
    }

    public void addAccumulatedSourceFor(HashJoin join2, Tap accumulatedSource) {
        if (!this.accumulatedSourcesByJoin.containsKey(join2)) {
            this.accumulatedSourcesByJoin.put(join2, new HashSet());
        }
        this.accumulatedSourcesByJoin.get(join2).add(accumulatedSource);
    }

    public void addSource(String name2, Tap source2) {
        if (!this.sources.containsKey(source2)) {
            this.sources.put(source2, new HashSet());
        }
        this.sources.get(source2).add(name2);
    }

    public void addSink(String name2, Tap sink2) {
        if (!this.sinks.containsKey(sink2)) {
            this.sinks.put(sink2, new HashSet());
        }
        this.sinks.get(sink2).add(name2);
    }

    @Override
    public Set<Tap> getSources() {
        return Collections.unmodifiableSet(new HashSet<Tap>(this.sources.keySet()));
    }

    @Override
    public Set<Tap> getSinks() {
        return Collections.unmodifiableSet(new HashSet<Tap>(this.sinks.keySet()));
    }

    @Override
    public Tap getSink() {
        if (this.sinks.size() != 1) {
            throw new IllegalStateException("more than one sink");
        }
        return this.sinks.keySet().iterator().next();
    }

    @Override
    public Set<String> getSourceName(Tap source2) {
        return Collections.unmodifiableSet(this.sources.get(source2));
    }

    @Override
    public Set<String> getSinkName(Tap sink2) {
        return Collections.unmodifiableSet(this.sinks.get(sink2));
    }

    @Override
    public Tap getSourceWith(String identifier2) {
        for (Tap tap : this.sources.keySet()) {
            if (!tap.getIdentifier().equalsIgnoreCase(identifier2)) continue;
            return tap;
        }
        return null;
    }

    @Override
    public Tap getSinkWith(String identifier2) {
        for (Tap tap : this.sinks.keySet()) {
            if (!tap.getIdentifier().equalsIgnoreCase(identifier2)) continue;
            return tap;
        }
        return null;
    }

    boolean allSourcesExist() throws IOException {
        for (Tap tap : this.sources.keySet()) {
            if (tap.resourceExists(this.getConfig())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areSourcesNewer(long sinkModified) throws IOException {
        Config config2 = this.getConfig();
        Iterator<Tap> values2 = this.sources.keySet().iterator();
        long sourceModified = 0L;
        try {
            sourceModified = Util.getSourceModified(config2, values2, sinkModified);
            if (sinkModified < sourceModified) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (LOG.isInfoEnabled()) {
                this.logInfo("source modification date at: " + new Date(sourceModified));
            }
        }
    }

    long getSinkModified() throws IOException {
        long sinkModified = Util.getSinkModified(this.getConfig(), this.sinks.keySet());
        if (LOG.isInfoEnabled()) {
            if (sinkModified == -1L) {
                this.logInfo("at least one sink is marked for delete");
            }
            if (sinkModified == 0L) {
                this.logInfo("at least one sink does not exist");
            } else {
                this.logInfo("sink oldest modified date: " + new Date(sinkModified));
            }
        }
        return sinkModified;
    }

    protected Throwable commitSinks() {
        Throwable throwable2 = null;
        for (Tap tap : this.sinks.keySet()) {
            if (throwable2 != null) {
                this.rollbackResource(tap);
                continue;
            }
            throwable2 = this.commitResource(tap);
        }
        return throwable2;
    }

    private Throwable commitResource(Tap tap) {
        FlowException throwable2 = null;
        try {
            if (!tap.commitResource(this.getConfig())) {
                String message = "unable to commit sink: " + tap.getFullIdentifier(this.getConfig());
                this.logError(message, null);
                throwable2 = new FlowException(message);
            }
        }
        catch (Throwable exception) {
            String message = "unable to commit sink: " + tap.getFullIdentifier(this.getConfig());
            this.logError(message, exception);
            throwable2 = new FlowException(message, exception);
        }
        return throwable2;
    }

    private Throwable rollbackResource(Tap tap) {
        FlowException throwable2 = null;
        try {
            if (!tap.rollbackResource(this.getConfig())) {
                String message = "unable to rollback sink: " + tap.getFullIdentifier(this.getConfig());
                this.logError(message, null);
                throwable2 = new FlowException(message);
            }
        }
        catch (Throwable exception) {
            String message = "unable to rollback sink: " + tap.getFullIdentifier(this.getConfig());
            this.logError(message, exception);
            throwable2 = new FlowException(message, exception);
        }
        return throwable2;
    }

    protected Throwable rollbackSinks() {
        Throwable throwable2 = null;
        for (Tap tap : this.sinks.keySet()) {
            if (throwable2 != null) {
                this.rollbackResource(tap);
                continue;
            }
            throwable2 = this.rollbackResource(tap);
        }
        return throwable2;
    }

    protected abstract Config getInitializedConfig(FlowProcess<Config> var1, Config var2);

    public Set<Scope> getPreviousScopes(FlowElement flowElement) {
        return this.getGraph().incomingEdgesOf(flowElement);
    }

    public Scope getNextScope(FlowElement flowElement) {
        Set set2 = this.getGraph().outgoingEdgesOf(flowElement);
        if (set2.size() != 1) {
            throw new IllegalStateException("should only be one scope after current flow element: " + flowElement + " found: " + set2.size());
        }
        return (Scope)set2.iterator().next();
    }

    public Scope getScopeFor(FlowElement sourceElement, FlowElement targetElement) {
        return (Scope)this.getGraph().getEdge(sourceElement, targetElement);
    }

    public Set<Scope> getNextScopes(FlowElement flowElement) {
        return this.getGraph().outgoingEdgesOf(flowElement);
    }

    public FlowElement getNextFlowElement(Scope scope) {
        return (FlowElement)this.getGraph().getEdgeTarget(scope);
    }

    public TopologicalOrderIterator<FlowElement, Scope> getTopologicalOrderIterator() {
        return new TopologicalOrderIterator<FlowElement, Scope>(this.graph);
    }

    public List<FlowElement> getSuccessors(FlowElement element) {
        return Graphs.successorListOf(this.graph, element);
    }

    public Set<Tap> getJoinTributariesBetween(FlowElement from2, FlowElement to2) {
        HashSet<HashJoin> joins = new HashSet<HashJoin>();
        HashSet<Merge> merges = new HashSet<Merge>();
        List<GraphPath<FlowElement, Scope>> paths = this.getPathsBetween(from2, to2);
        for (GraphPath<FlowElement, Scope> path : paths) {
            for (FlowElement flowElement : Graphs.getPathVertexList(path)) {
                if (flowElement instanceof HashJoin) {
                    joins.add((HashJoin)flowElement);
                }
                if (!(flowElement instanceof Merge)) continue;
                merges.add((Merge)flowElement);
            }
        }
        HashSet<Tap> tributaries = new HashSet<Tap>();
        for (HashJoin join2 : joins) {
            for (Tap source2 : this.sources.keySet()) {
                LinkedList<GraphPath<FlowElement, Scope>> joinPaths = new LinkedList<GraphPath<FlowElement, Scope>>(this.getPathsBetween(source2, join2));
                ListIterator iterator2 = joinPaths.listIterator();
                while (iterator2.hasNext()) {
                    GraphPath joinPath = (GraphPath)iterator2.next();
                    if (Collections.disjoint(Graphs.getPathVertexList(joinPath), merges)) continue;
                    iterator2.remove();
                }
                if (joinPaths.isEmpty()) continue;
                tributaries.add(source2);
            }
        }
        return tributaries;
    }

    private List<GraphPath<FlowElement, Scope>> getPathsBetween(FlowElement from2, FlowElement to2) {
        KShortestPaths<FlowElement, Scope> paths = new KShortestPaths<FlowElement, Scope>(this.graph, from2, Integer.MAX_VALUE);
        List<GraphPath<FlowElement, Scope>> results2 = paths.getPaths(to2);
        if (results2 == null) {
            return Collections.EMPTY_LIST;
        }
        return results2;
    }

    public Collection<Operation> getAllOperations() {
        Set vertices = this.getGraph().vertexSet();
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (FlowElement vertex : vertices) {
            if (!(vertex instanceof Operator)) continue;
            operations.add(((Operator)vertex).getOperation());
        }
        return operations;
    }

    @Override
    public boolean containsPipeNamed(String pipeName) {
        Set vertices = this.getGraph().vertexSet();
        for (FlowElement vertex : vertices) {
            if (!(vertex instanceof Pipe) || !((Pipe)vertex).getName().equals(pipeName)) continue;
            return true;
        }
        return false;
    }

    public void clean() {
        this.clean(this.getConfig());
    }

    public abstract void clean(Config var1);

    List<SafeFlowStepListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<SafeFlowStepListener>();
        }
        return this.listeners;
    }

    @Override
    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    @Override
    public void addListener(FlowStepListener flowStepListener) {
        this.getListeners().add(new SafeFlowStepListener(flowStepListener));
    }

    @Override
    public boolean removeListener(FlowStepListener flowStepListener) {
        return this.getListeners().remove(new SafeFlowStepListener(flowStepListener));
    }

    protected void fireOnCompleted() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onCompleted event: " + this.getListeners().size());
            }
            for (SafeFlowStepListener flowStepListener : this.getListeners()) {
                ((FlowStepListener)flowStepListener).onStepCompleted(this);
            }
        }
    }

    protected void fireOnThrowable(Throwable throwable2) {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onThrowable event: " + this.getListeners().size());
            }
            for (SafeFlowStepListener flowStepListener : this.getListeners()) {
                ((FlowStepListener)flowStepListener).onStepThrowable(this, throwable2);
            }
        }
    }

    protected void fireOnStopping() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStopping event: " + this.getListeners());
            }
            for (SafeFlowStepListener flowStepListener : this.getListeners()) {
                ((FlowStepListener)flowStepListener).onStepStopping(this);
            }
        }
    }

    protected void fireOnStarting() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onStarting event: " + this.getListeners().size());
            }
            for (SafeFlowStepListener flowStepListener : this.getListeners()) {
                ((FlowStepListener)flowStepListener).onStepStarting(this);
            }
        }
    }

    protected void fireOnRunning() {
        if (this.hasListeners()) {
            if (LOG.isDebugEnabled()) {
                this.logDebug("firing onRunning event: " + this.getListeners().size());
            }
            for (SafeFlowStepListener flowStepListener : this.getListeners()) {
                ((FlowStepListener)flowStepListener).onStepRunning(this);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BaseFlowStep flowStep = (BaseFlowStep)object;
        return !(this.name != null ? !this.name.equals(flowStep.name) : flowStep.name != null);
    }

    protected ClientState createClientState(FlowProcess flowProcess) {
        CascadingServices services = flowProcess.getCurrentSession().getCascadingServices();
        return services.createClientState(this.getID());
    }

    public FlowStepJob<Config> getFlowStepJob(FlowProcess<Config> flowProcess, Config parentConfig) {
        if (this.flowStepJob != null) {
            return this.flowStepJob;
        }
        if (flowProcess == null) {
            return null;
        }
        this.flowStepJob = this.createFlowStepJob(flowProcess, parentConfig);
        return this.flowStepJob;
    }

    protected abstract FlowStepJob createFlowStepJob(FlowProcess<Config> var1, Config var2);

    protected void initConfFromProcessConfigDef(ConfigDef.Setter setter2) {
        for (ConfigDef.Mode mode2 : ConfigDef.Mode.values()) {
            TopologicalOrderIterator<FlowElement, Scope> iterator2 = this.getTopologicalOrderIterator();
            while (iterator2.hasNext()) {
                FlowElement element = (FlowElement)iterator2.next();
                while (element != null) {
                    if (element.hasStepConfigDef()) {
                        element.getStepConfigDef().apply(mode2, setter2);
                    }
                    if (element instanceof Pipe) {
                        element = ((Pipe)element).getParent();
                        continue;
                    }
                    element = null;
                }
            }
        }
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        StringBuffer buffer2 = new StringBuffer();
        buffer2.append(this.getClass().getSimpleName());
        buffer2.append("[name: ").append(this.getName()).append("]");
        return buffer2.toString();
    }

    public final boolean isInfoEnabled() {
        return LOG.isInfoEnabled();
    }

    public final boolean isDebugEnabled() {
        return LOG.isDebugEnabled();
    }

    public void logDebug(String message) {
        LOG.debug("[" + Util.truncate(this.getFlowName(), 25) + "] " + message);
    }

    public void logInfo(String message) {
        LOG.info("[" + Util.truncate(this.getFlowName(), 25) + "] " + message);
    }

    public void logWarn(String message) {
        LOG.warn("[" + Util.truncate(this.getFlowName(), 25) + "] " + message);
    }

    public void logWarn(String message, Throwable throwable2) {
        LOG.warn("[" + Util.truncate(this.getFlowName(), 25) + "] " + message, throwable2);
    }

    public void logError(String message, Throwable throwable2) {
        LOG.error("[" + Util.truncate(this.getFlowName(), 25) + "] " + message, throwable2);
    }

    private class SafeFlowStepListener
    implements FlowStepListener {
        final FlowStepListener flowStepListener;
        Throwable throwable;

        private SafeFlowStepListener(FlowStepListener flowStepListener) {
            this.flowStepListener = flowStepListener;
        }

        @Override
        public void onStepStarting(FlowStep flowStep) {
            try {
                this.flowStepListener.onStepStarting(flowStep);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onStepStopping(FlowStep flowStep) {
            try {
                this.flowStepListener.onStepStopping(flowStep);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onStepCompleted(FlowStep flowStep) {
            try {
                this.flowStepListener.onStepCompleted(flowStep);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public void onStepRunning(FlowStep flowStep) {
            try {
                this.flowStepListener.onStepRunning(flowStep);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
            }
        }

        @Override
        public boolean onStepThrowable(FlowStep flowStep, Throwable flowStepThrowable) {
            try {
                return this.flowStepListener.onStepThrowable(flowStep, flowStepThrowable);
            }
            catch (Throwable throwable2) {
                this.handleThrowable(throwable2);
                return false;
            }
        }

        private void handleThrowable(Throwable throwable2) {
            this.throwable = throwable2;
            BaseFlowStep.this.logWarn(String.format("flow step listener %s threw throwable", this.flowStepListener), throwable2);
        }

        public boolean equals(Object object) {
            if (object instanceof SafeFlowStepListener) {
                return this.flowStepListener.equals(((SafeFlowStepListener)object).flowStepListener);
            }
            return this.flowStepListener.equals(object);
        }

        public int hashCode() {
            return this.flowStepListener.hashCode();
        }
    }
}

