/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local.stream;

import cascading.flow.FlowElement;
import cascading.flow.FlowProcess;
import cascading.flow.local.LocalFlowProcess;
import cascading.flow.local.LocalFlowStep;
import cascading.flow.local.stream.LocalGroupByGate;
import cascading.flow.local.stream.SyncMergeStage;
import cascading.flow.stream.Duct;
import cascading.flow.stream.Gate;
import cascading.flow.stream.MemoryCoGroupGate;
import cascading.flow.stream.SinkStage;
import cascading.flow.stream.SourceStage;
import cascading.flow.stream.StepStreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.GroupBy;
import cascading.pipe.Merge;
import cascading.property.PropertyUtil;
import cascading.tap.Tap;
import java.util.List;
import java.util.Properties;

public class LocalStepStreamGraph
extends StepStreamGraph {
    public LocalStepStreamGraph(FlowProcess<Properties> flowProcess, LocalFlowStep step) {
        super(flowProcess, step);
        this.buildGraph();
        this.setTraps();
        this.setScopes();
        this.printGraph(step.getID(), "local", 0);
        this.bind();
    }

    protected void buildGraph() {
        for (Tap rhsElement : this.step.getSources()) {
            SourceStage rhsDuct = new SourceStage((FlowProcess)this.tapFlowProcess(rhsElement), rhsElement);
            this.addHead(rhsDuct);
            this.handleDuct(rhsElement, rhsDuct);
        }
    }

    @Override
    protected Gate createCoGroupGate(CoGroup element) {
        return new MemoryCoGroupGate(this.flowProcess, element);
    }

    @Override
    protected Gate createGroupByGate(GroupBy element) {
        return new LocalGroupByGate(this.flowProcess, element);
    }

    @Override
    protected Duct createMergeStage(Merge merge2) {
        return new SyncMergeStage(this.flowProcess, merge2);
    }

    @Override
    protected SinkStage createSinkStage(Tap element) {
        return new SinkStage((FlowProcess)this.tapFlowProcess(element), element);
    }

    private LocalFlowProcess tapFlowProcess(Tap tap) {
        Properties defaultProperties = ((LocalFlowProcess)this.flowProcess).getConfigCopy();
        Properties tapProperties = ((LocalFlowStep)this.step).getPropertiesMap().get(tap);
        tapProperties = PropertyUtil.createProperties(tapProperties, defaultProperties);
        return new LocalFlowProcess((LocalFlowProcess)this.flowProcess, tapProperties);
    }

    @Override
    protected boolean stopOnElement(FlowElement lhsElement, List<FlowElement> successors) {
        if (successors.isEmpty()) {
            if (!(lhsElement instanceof Tap)) {
                throw new IllegalStateException("expected a Tap instance");
            }
            return true;
        }
        return false;
    }
}

