/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local.stream;

import cascading.flow.FlowProcess;
import cascading.flow.stream.Duct;
import cascading.flow.stream.MemorySpliceGate;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LocalGroupByGate
extends MemorySpliceGate {
    private ListMultimap<Tuple, Tuple> valueMap;

    public LocalGroupByGate(FlowProcess flowProcess, Splice splice) {
        super(flowProcess, splice);
    }

    @Override
    protected boolean isBlockingStreamed() {
        return true;
    }

    private ListMultimap<Tuple, Tuple> initNewValueMap() {
        return Multimaps.synchronizedListMultimap(ArrayListMultimap.create());
    }

    @Override
    public void prepare() {
        super.prepare();
        this.valueMap = this.initNewValueMap();
    }

    @Override
    public void start(Duct previous) {
    }

    @Override
    public void receive(Duct previous, TupleEntry incomingEntry) {
        Tuple valuesTuple = incomingEntry.getTupleCopy();
        Tuple groupTuple = this.keyBuilder[0].makeResult(valuesTuple, null);
        groupTuple = this.getDelegatedTuple(groupTuple);
        this.keys.add(groupTuple);
        this.valueMap.put(groupTuple, valuesTuple);
    }

    @Override
    public void complete(Duct previous) {
        if (this.count.decrementAndGet() != 0) {
            return;
        }
        this.next.start(this);
        Iterator iterator2 = this.keys.iterator();
        while (iterator2.hasNext()) {
            Tuple groupTuple = (Tuple)iterator2.next();
            iterator2.remove();
            this.keyEntry.setTuple(groupTuple);
            List<Tuple> tuples = this.valueMap.get(groupTuple);
            if (this.valueComparators != null) {
                Collections.sort(tuples, this.valueComparators[0]);
            }
            this.tupleEntryIterator.reset(tuples.iterator());
            this.next.receive(this, this.grouping);
            tuples.clear();
        }
        this.keys = this.createKeySet();
        this.valueMap = this.initNewValueMap();
        this.count.set(this.numIncomingPaths);
        this.next.complete(this);
    }
}

