/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local.planner;

import cascading.flow.FlowProcess;
import cascading.flow.local.LocalFlowStep;
import cascading.flow.local.stream.LocalStepStreamGraph;
import cascading.flow.stream.Duct;
import cascading.flow.stream.StreamGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStepRunner
implements Callable<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStepRunner.class);
    private final FlowProcess<Properties> flowProcess;
    private boolean complete = false;
    private boolean successful = false;
    private final StreamGraph graph;
    private final Collection<Duct> heads;
    private Throwable throwable = null;

    public LocalStepRunner(FlowProcess<Properties> flowProcess, LocalFlowStep step) {
        this.flowProcess = flowProcess;
        this.graph = new LocalStepStreamGraph(this.flowProcess, step);
        this.heads = this.graph.getHeads();
    }

    public FlowProcess<Properties> getFlowProcess() {
        return this.flowProcess;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Throwable call() throws Exception {
        boolean attemptedCleanup = false;
        try {
            block28: {
                try {
                    this.graph.prepare();
                }
                catch (Throwable currentThrowable) {
                    if (!(currentThrowable instanceof OutOfMemoryError)) {
                        LOG.error("unable to prepare operation graph", currentThrowable);
                    }
                    this.complete = true;
                    this.successful = false;
                    Throwable throwable2 = this.throwable = currentThrowable;
                    try {
                        if (!attemptedCleanup) {
                            this.graph.cleanup();
                        }
                    }
                    catch (Throwable currentThrowable2) {
                        if (!(currentThrowable2 instanceof OutOfMemoryError)) {
                            LOG.error("unable to cleanup operation graph", currentThrowable2);
                        }
                        if (this.throwable == null) {
                            this.throwable = currentThrowable2;
                        }
                        this.successful = false;
                    }
                    return throwable2;
                }
                try {
                    List<Future<Throwable>> futures = this.spawnHeads();
                    for (Future<Throwable> future : futures) {
                        this.throwable = future.get();
                        if (this.throwable == null) continue;
                        break;
                    }
                }
                catch (Throwable currentThrowable) {
                    if (!(currentThrowable instanceof OutOfMemoryError)) {
                        LOG.error("unable to complete step", currentThrowable);
                    }
                    this.throwable = currentThrowable;
                }
                try {
                    attemptedCleanup = true;
                    if (!(this.throwable instanceof OutOfMemoryError)) {
                        this.graph.cleanup();
                    }
                }
                catch (Throwable currentThrowable) {
                    if (!(currentThrowable instanceof OutOfMemoryError)) {
                        LOG.error("unable to cleanup operation graph", currentThrowable);
                    }
                    if (this.throwable != null) break block28;
                    this.throwable = currentThrowable;
                }
            }
            this.complete = true;
            this.successful = this.throwable == null;
            Throwable throwable3 = this.throwable;
            return throwable3;
        }
        finally {
            try {
                if (!attemptedCleanup) {
                    this.graph.cleanup();
                }
            }
            catch (Throwable currentThrowable) {
                if (!(currentThrowable instanceof OutOfMemoryError)) {
                    LOG.error("unable to cleanup operation graph", currentThrowable);
                }
                if (this.throwable == null) {
                    this.throwable = currentThrowable;
                }
                this.successful = false;
            }
        }
    }

    private List<Future<Throwable>> spawnHeads() {
        ExecutorService executors = Executors.newFixedThreadPool(this.heads.size());
        ArrayList<Future<Throwable>> futures = new ArrayList<Future<Throwable>>();
        for (Duct head2 : this.heads) {
            futures.add(executors.submit((Callable)((Object)head2)));
        }
        executors.shutdown();
        return futures;
    }
}

