/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local.planner;

import cascading.flow.FlowStep;
import cascading.flow.local.LocalFlowStep;
import cascading.flow.planner.ElementGraph;
import cascading.flow.planner.FlowStepGraph;
import cascading.tap.Tap;
import java.util.Map;
import org.jgrapht.Graphs;

public class LocalStepGraph
extends FlowStepGraph {
    public LocalStepGraph(String flowName, ElementGraph elementGraph) {
        super(flowName, elementGraph);
    }

    protected FlowStep createFlowStep(String stepName, int stepNum) {
        return new LocalFlowStep(stepName, stepNum);
    }

    @Override
    protected void makeStepGraph(String flowName, ElementGraph elementGraph) {
        LocalFlowStep step = (LocalFlowStep)this.createFlowStep("local", 1);
        this.addVertex(step);
        for (Map.Entry<String, Tap> entry2 : elementGraph.getSourceMap().entrySet()) {
            step.addSource(entry2.getKey(), entry2.getValue());
        }
        for (Map.Entry<String, Tap> entry2 : elementGraph.getSinkMap().entrySet()) {
            step.addSink(entry2.getKey(), entry2.getValue());
        }
        step.getTrapMap().putAll(elementGraph.getTrapMap());
        Graphs.addGraph(step.getGraph(), elementGraph);
        step.getGraph().removeVertex(ElementGraph.head);
        step.getGraph().removeVertex(ElementGraph.tail);
        step.getGroups().addAll(elementGraph.findAllGroups());
    }
}

