/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local.planner;

import cascading.flow.FlowStep;
import cascading.flow.local.LocalFlowProcess;
import cascading.flow.local.LocalFlowStep;
import cascading.flow.local.planner.LocalStepRunner;
import cascading.flow.planner.FlowStepJob;
import cascading.management.state.ClientState;
import cascading.stats.FlowStepStats;
import cascading.stats.local.LocalStepStats;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFlowStepJob
extends FlowStepJob<Properties> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFlowStepJob.class);
    private final LocalStepRunner stackRunner;
    private Future<Throwable> future;

    public LocalFlowStepJob(ClientState clientState, LocalFlowProcess flowProcess, LocalFlowStep flowStep) {
        super(clientState, flowStep, 200L, 1000L);
        flowProcess.setStepStats((LocalStepStats)this.flowStepStats);
        this.stackRunner = new LocalStepRunner(flowProcess, flowStep);
    }

    @Override
    public Properties getConfig() {
        return (Properties)this.flowStep.getConfig();
    }

    @Override
    protected FlowStepStats createStepStats(ClientState clientState) {
        return new LocalStepStats((FlowStep<Properties>)this.flowStep, clientState);
    }

    @Override
    protected boolean isRemoteExecution() {
        return false;
    }

    @Override
    protected String internalJobId() {
        return "flow";
    }

    @Override
    protected void internalNonBlockingStart() throws IOException {
        ExecutorService executors = Executors.newFixedThreadPool(1);
        this.future = executors.submit(this.stackRunner);
        executors.shutdown();
    }

    @Override
    protected boolean internalIsStarted() {
        return this.future != null;
    }

    @Override
    protected boolean internalNonBlockingIsComplete() throws IOException {
        return this.stackRunner.isComplete();
    }

    @Override
    protected Throwable getThrowable() {
        return this.stackRunner.getThrowable();
    }

    @Override
    protected boolean internalNonBlockingIsSuccessful() throws IOException {
        return this.stackRunner.isSuccessful();
    }

    @Override
    protected void internalBlockOnStop() throws IOException {
    }

    @Override
    protected void dumpDebugInfo() {
    }
}

