/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local;

import cascading.flow.FlowProcess;
import cascading.flow.local.LocalFlowProcess;
import cascading.flow.local.planner.LocalFlowStepJob;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.FlowStepJob;
import cascading.property.ConfigDef;
import cascading.tap.Tap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class LocalFlowStep
extends BaseFlowStep<Properties> {
    private final Map<String, Tap> traps = new HashMap<String, Tap>();
    private final Map<Tap, Properties> tapProperties = new HashMap<Tap, Properties>();

    public LocalFlowStep(String name2, int id) {
        super(name2, id);
    }

    @Override
    public Properties getInitializedConfig(FlowProcess<Properties> flowProcess, Properties parentConfig) {
        Properties currentProperties = parentConfig == null ? new Properties() : new Properties(parentConfig);
        this.initTaps(flowProcess, currentProperties, this.getSources(), false);
        this.initTaps(flowProcess, currentProperties, this.getSinks(), true);
        this.initTaps(flowProcess, currentProperties, this.getTraps(), true);
        this.initFromProcessConfigDef(currentProperties);
        return currentProperties;
    }

    protected void initTaps(FlowProcess<Properties> flowProcess, Properties conf, Set<Tap> taps, boolean isSink) {
        if (!taps.isEmpty()) {
            for (Tap tap : taps) {
                Properties confCopy = flowProcess.copyConfig(conf);
                this.tapProperties.put(tap, confCopy);
                if (isSink) {
                    tap.sinkConfInit(flowProcess, confCopy);
                    continue;
                }
                tap.sourceConfInit(flowProcess, confCopy);
            }
        }
    }

    private void initFromProcessConfigDef(Properties properties) {
        this.initConfFromProcessConfigDef(this.getSetterFor(properties));
    }

    private ConfigDef.Setter getSetterFor(final Properties properties) {
        return new ConfigDef.Setter(){

            @Override
            public String set(String key, String value2) {
                String oldValue = this.get(key);
                properties.setProperty(key, value2);
                return oldValue;
            }

            @Override
            public String update(String key, String value2) {
                String oldValue = this.get(key);
                if (oldValue == null) {
                    properties.setProperty(key, value2);
                } else if (!oldValue.contains(value2)) {
                    properties.setProperty(key, oldValue + "," + value2);
                }
                return oldValue;
            }

            @Override
            public String get(String key) {
                String value2 = properties.getProperty(key);
                if (value2 == null || value2.isEmpty()) {
                    return null;
                }
                return value2;
            }
        };
    }

    @Override
    public void clean(Properties config2) {
    }

    @Override
    protected FlowStepJob<Properties> createFlowStepJob(FlowProcess<Properties> flowProcess, Properties parentConfig) {
        this.setConf(this.getInitializedConfig((FlowProcess<Properties>)flowProcess, parentConfig));
        flowProcess = new LocalFlowProcess(flowProcess.getCurrentSession(), (Properties)this.getConfig());
        return new LocalFlowStepJob(this.createClientState(flowProcess), flowProcess, this);
    }

    public Map<String, Tap> getTrapMap() {
        return this.traps;
    }

    public Map<Tap, Properties> getPropertiesMap() {
        return this.tapProperties;
    }

    @Override
    public Set<Tap> getTraps() {
        return Collections.unmodifiableSet(new HashSet<Tap>(this.traps.values()));
    }

    @Override
    public Tap getTrap(String name2) {
        return this.getTrapMap().get(name2);
    }
}

