/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.stats.local.LocalStepStats;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;

public class LocalFlowProcess
extends FlowProcess<Properties> {
    private final Properties config;
    private LocalStepStats stepStats;

    public LocalFlowProcess() {
        this.config = new Properties();
    }

    public LocalFlowProcess(Properties config2) {
        this.config = config2;
    }

    public LocalFlowProcess(FlowSession flowSession, Properties config2) {
        super(flowSession);
        this.config = config2;
    }

    public LocalFlowProcess(LocalFlowProcess flowProcess, Properties properties) {
        super(flowProcess.getCurrentSession());
        this.config = properties;
        this.stepStats = flowProcess.stepStats;
    }

    public void setStepStats(LocalStepStats stepStats) {
        this.stepStats = stepStats;
    }

    @Override
    public int getNumProcessSlices() {
        return 1;
    }

    @Override
    public int getCurrentSliceNum() {
        return 0;
    }

    @Override
    public Object getProperty(String key) {
        return this.config.getProperty(key);
    }

    @Override
    public Collection<String> getPropertyKeys() {
        return Collections.unmodifiableSet(this.config.stringPropertyNames());
    }

    @Override
    public Object newInstance(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            Class<?> type = LocalFlowProcess.class.getClassLoader().loadClass(className.toString());
            return type.newInstance();
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + className.toString(), exception);
        }
        catch (InstantiationException exception) {
            throw new CascadingException("unable to instantiate class: " + className.toString(), exception);
        }
        catch (IllegalAccessException exception) {
            throw new CascadingException("unable to access class: " + className.toString(), exception);
        }
    }

    @Override
    public void keepAlive() {
    }

    @Override
    public void increment(Enum counter2, long amount) {
        this.stepStats.increment(counter2, amount);
    }

    @Override
    public void increment(String group2, String counter2, long amount) {
        this.stepStats.increment(group2, counter2, amount);
    }

    @Override
    public void setStatus(String status) {
    }

    @Override
    public boolean isCounterStatusInitialized() {
        return true;
    }

    @Override
    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead(this);
    }

    @Override
    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite(this, null);
    }

    @Override
    public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
        return trap.openForWrite(this, null);
    }

    @Override
    public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
        return null;
    }

    @Override
    public FlowProcess copyWith(Properties object) {
        return new LocalFlowProcess(object);
    }

    @Override
    public Properties getConfigCopy() {
        return new Properties(this.config);
    }

    @Override
    public Properties copyConfig(Properties config2) {
        return new Properties(config2);
    }

    @Override
    public Map<String, String> diffConfigIntoMap(Properties defaultConfig, Properties updatedConfig) {
        return null;
    }

    @Override
    public Properties mergeMapIntoConfig(Properties defaultConfig, Map<String, String> map2) {
        return null;
    }
}

