/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.local;

import cascading.flow.BaseFlow;
import cascading.flow.FlowDef;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.local.LocalFlowProcess;
import cascading.flow.planner.PlatformInfo;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Properties;

public class LocalFlow
extends BaseFlow<Properties> {
    private Properties config;

    public LocalFlow(PlatformInfo platformInfo, Map<Object, Object> properties, Properties config2, FlowDef flowDef) {
        super(platformInfo, properties, config2, flowDef);
        this.initFromProperties(properties);
    }

    @Override
    protected void initConfig(Map<Object, Object> properties, Properties parentConfig) {
        this.config = this.createConfig(properties, parentConfig);
    }

    @Override
    protected void setConfigProperty(Properties properties, Object key, Object value2) {
        properties.setProperty(key.toString(), value2.toString());
    }

    @Override
    protected Properties newConfig(Properties defaultConfig) {
        return defaultConfig == null ? new Properties() : new Properties(defaultConfig);
    }

    @Override
    public Properties getConfig() {
        return this.config;
    }

    @Override
    public Properties getConfigCopy() {
        return new Properties(this.config);
    }

    @Override
    public Map<Object, Object> getConfigAsProperties() {
        return this.config;
    }

    @Override
    public String getProperty(String key) {
        return this.config.getProperty(key);
    }

    @Override
    public FlowProcess<Properties> getFlowProcess() {
        return new LocalFlowProcess(this.getFlowSession(), this.config);
    }

    @Override
    protected void internalStart() {
        try {
            this.deleteSinksIfReplace();
            this.deleteTrapsIfReplace();
        }
        catch (IOException exception) {
            throw new FlowException("unable to delete sinks", exception);
        }
    }

    @Override
    protected Thread createFlowThread(String threadName) {
        Thread flowThread = super.createFlowThread(threadName);
        flowThread.setContextClassLoader(this.createClassPathClassloader(flowThread.getContextClassLoader()));
        return flowThread;
    }

    private ClassLoader createClassPathClassloader(ClassLoader classLoader) {
        if (this.getClassPath() == null || this.getClassPath().isEmpty()) {
            return classLoader;
        }
        URL[] urls = new URL[this.getClassPath().size()];
        for (int i = 0; i < this.getClassPath().size(); ++i) {
            String path = this.getClassPath().get(i);
            File file = new File(path).getAbsoluteFile();
            if (!file.exists()) {
                throw new FlowException("path does not exist: " + file);
            }
            try {
                urls[i] = file.toURI().toURL();
                continue;
            }
            catch (MalformedURLException exception) {
                throw new FlowException("bad path: " + file, exception);
            }
        }
        return new URLClassLoader(urls, classLoader);
    }

    @Override
    protected void internalClean(boolean stop) {
    }

    @Override
    public boolean stepsAreLocal() {
        return false;
    }

    @Override
    protected int getMaxNumParallelSteps() {
        return 0;
    }

    @Override
    protected void internalShutdown() {
    }
}

