/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.util;

import cascading.flow.FlowException;
import cascading.flow.hadoop.util.ObjectSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class JavaObjectSerializer
implements ObjectSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> byte[] serialize(T object, boolean compress) throws IOException {
        if (object instanceof Map) {
            return this.serializeMap((Map)object, compress);
        }
        if (object instanceof List) {
            return this.serializeList((List)object, compress);
        }
        ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(compress ? new GZIPOutputStream(bytes2) : bytes2);
        try {
            out.writeObject(object);
        }
        finally {
            out.close();
        }
        return bytes2.toByteArray();
    }

    @Override
    public <T> T deserialize(byte[] bytes2, Class<T> type, boolean decompress) throws IOException {
        if (Map.class.isAssignableFrom(type)) {
            return (T)this.deserializeMap(bytes2, decompress);
        }
        if (List.class.isAssignableFrom(type)) {
            return (T)this.deserializeList(bytes2, decompress);
        }
        ObjectInputStream in = null;
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes2);
            in = new ObjectInputStream(decompress ? new GZIPInputStream(byteStream) : byteStream){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException exception) {
                        return super.resolveClass(desc);
                    }
                }
            };
            Object object = in.readObject();
            return (T)object;
        }
        catch (ClassNotFoundException exception) {
            throw new FlowException("unable to deserialize data", exception);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public <T> boolean accepts(Class<T> type) {
        return Serializable.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || List.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] serializeMap(Map<String, T> map2, boolean compress) throws IOException {
        ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(compress ? new GZIPOutputStream(bytes2) : bytes2);
        Class tClass = map2.size() == 0 ? Object.class : map2.values().iterator().next().getClass();
        try {
            out.writeInt(map2.size());
            out.writeUTF(tClass.getName());
            for (Map.Entry<String, T> entry2 : map2.entrySet()) {
                out.writeUTF(entry2.getKey());
                byte[] itemBytes = this.serialize(entry2.getValue(), false);
                out.writeInt(itemBytes.length);
                out.write(itemBytes);
            }
        }
        finally {
            out.close();
        }
        return bytes2.toByteArray();
    }

    public <T> Map<String, T> deserializeMap(byte[] bytes2, boolean decompress) throws IOException {
        ObjectInputStream in = null;
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes2);
            in = new ObjectInputStream(decompress ? new GZIPInputStream(byteStream) : byteStream);
            int mapSize = in.readInt();
            Class<?> tClass = Class.forName(in.readUTF());
            HashMap map2 = new HashMap(mapSize);
            for (int j = 0; j < mapSize; ++j) {
                String key = in.readUTF();
                byte[] valBytes = new byte[in.readInt()];
                in.readFully(valBytes);
                map2.put(key, this.deserialize(valBytes, tClass, false));
            }
            HashMap hashMap = map2;
            return hashMap;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] serializeList(List<T> list2, boolean compress) throws IOException {
        ByteArrayOutputStream bytes2 = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(compress ? new GZIPOutputStream(bytes2) : bytes2);
        Class tClass = list2.size() == 0 ? Object.class : list2.get(0).getClass();
        try {
            out.writeInt(list2.size());
            out.writeUTF(tClass.getName());
            for (T item : list2) {
                byte[] itemBytes = this.serialize(item, false);
                out.writeInt(itemBytes.length);
                out.write(itemBytes);
            }
        }
        finally {
            out.close();
        }
        return bytes2.toByteArray();
    }

    public <T> List<T> deserializeList(byte[] bytes2, boolean decompress) throws IOException {
        ObjectInputStream in = null;
        try {
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes2);
            in = new ObjectInputStream(decompress ? new GZIPInputStream(byteStream) : byteStream);
            int listSize = in.readInt();
            Class<?> tClass = Class.forName(in.readUTF());
            ArrayList list2 = new ArrayList(listSize);
            for (int i = 0; i < listSize; ++i) {
                byte[] itemBytes = new byte[in.readInt()];
                in.readFully(itemBytes);
                list2.add(this.deserialize(itemBytes, tClass, false));
            }
            ArrayList arrayList = list2;
            return arrayList;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

