/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.util;

import cascading.flow.FlowException;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.util.JavaObjectSerializer;
import cascading.flow.hadoop.util.ObjectSerializer;
import cascading.flow.planner.PlatformInfo;
import cascading.scheme.Scheme;
import cascading.scheme.hadoop.TextLine;
import cascading.tap.SinkMode;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.Lfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import cascading.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtil.class);
    private static final String ENCODING = "US-ASCII";
    private static final Class<?> DEFAULT_OBJECT_SERIALIZER = JavaObjectSerializer.class;
    private static PlatformInfo platformInfo;

    public static void initLog4j(JobConf jobConf) {
        String[] elements;
        String values2 = jobConf.get("log4j.logger", null);
        if (values2 == null || values2.length() == 0) {
            return;
        }
        if (!Util.hasClass("org.apache.log4j.Logger")) {
            LOG.info("org.apache.log4j.Logger is not in the current CLASSPATH, not setting log4j.logger properties");
            return;
        }
        for (String element : elements = values2.split(",")) {
            HadoopUtil.setLogLevel(element.split("="));
        }
    }

    private static void setLogLevel(String[] logger) {
        Object loggerObject = Util.invokeStaticMethod("org.apache.log4j.Logger", "getLogger", new Object[]{logger[0]}, new Class[]{String.class});
        Object levelObject = Util.invokeStaticMethod("org.apache.log4j.Level", "toLevel", new Object[]{logger[1]}, new Class[]{String.class});
        Util.invokeInstanceMethod(loggerObject, "setLevel", new Object[]{levelObject}, new Class[]{levelObject.getClass()});
    }

    public static JobConf copyJobConf(JobConf parentJobConf) {
        if (parentJobConf == null) {
            throw new NullPointerException("parentJobConf");
        }
        Configuration configurationCopy = new Configuration((Configuration)parentJobConf);
        JobConf jobConf = new JobConf(configurationCopy);
        jobConf.getCredentials().addAll(parentJobConf.getCredentials());
        return jobConf;
    }

    public static JobConf createJobConf(Map<Object, Object> properties, JobConf defaultJobconf) {
        JobConf jobConf;
        JobConf jobConf2 = jobConf = defaultJobconf == null ? new JobConf() : HadoopUtil.copyJobConf(defaultJobconf);
        if (properties == null) {
            return jobConf;
        }
        HashSet<Object> keys2 = new HashSet<Object>(properties.keySet());
        if (properties instanceof Properties) {
            keys2.addAll(((Properties)properties).stringPropertyNames());
        }
        for (Object e : keys2) {
            Object value2 = properties.get(e);
            if (value2 == null && properties instanceof Properties && e instanceof String) {
                value2 = ((Properties)properties).getProperty((String)e);
            }
            if (value2 == null || value2 instanceof Class || value2 instanceof JobConf) continue;
            jobConf.set(e.toString(), value2.toString());
        }
        return jobConf;
    }

    public static Map<Object, Object> createProperties(Configuration jobConf) {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        if (jobConf == null) {
            return properties;
        }
        for (Map.Entry entry2 : jobConf) {
            properties.put(entry2.getKey(), entry2.getValue());
        }
        return properties;
    }

    public static Thread getHDFSShutdownHook() {
        Exception caughtException;
        try {
            FileSystem.getLocal((Configuration)new JobConf());
            Field field2 = FileSystem.class.getDeclaredField("clientFinalizer");
            field2.setAccessible(true);
            Thread finalizer = (Thread)field2.get(null);
            if (finalizer != null) {
                Runtime.getRuntime().removeShutdownHook(finalizer);
            }
            return finalizer;
        }
        catch (NoSuchFieldException exception) {
            caughtException = exception;
        }
        catch (IllegalAccessException exception) {
            caughtException = exception;
        }
        catch (IOException exception) {
            caughtException = exception;
        }
        LOG.debug("unable to find and remove client hdfs shutdown hook, received exception: {}", (Object)caughtException.getClass().getName());
        return null;
    }

    public static String encodeBytes(byte[] bytes2) {
        try {
            return new String(Base64.encodeBase64(bytes2), ENCODING);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] decodeBytes(String string2) {
        try {
            byte[] bytes2 = string2.getBytes(ENCODING);
            return Base64.decodeBase64(bytes2);
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <T> ObjectSerializer instantiateSerializer(Configuration conf, Class<T> type) throws ClassNotFoundException {
        ObjectSerializer objectSerializer;
        String serializerClassName = conf.get("cascading.util.serializer");
        Class<?> flowSerializerClass = serializerClassName == null || serializerClassName.length() == 0 ? DEFAULT_OBJECT_SERIALIZER : Class.forName(serializerClassName);
        try {
            objectSerializer = (ObjectSerializer)flowSerializerClass.newInstance();
            if (objectSerializer instanceof Configurable) {
                ((Configurable)objectSerializer).setConf(conf);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Unable to instantiate serializer \"" + flowSerializerClass.getName() + "\" for class: " + type.getName());
        }
        if (!objectSerializer.accepts(type)) {
            throw new IllegalArgumentException(serializerClassName + " won't accept objects of class " + type.toString());
        }
        return objectSerializer;
    }

    public static <T> String serializeBase64(T object, JobConf conf) throws IOException {
        return HadoopUtil.serializeBase64(object, conf, true);
    }

    public static <T> String serializeBase64(T object, JobConf conf, boolean compress) throws IOException {
        ObjectSerializer objectSerializer;
        try {
            objectSerializer = HadoopUtil.instantiateSerializer((Configuration)conf, object.getClass());
        }
        catch (ClassNotFoundException exception) {
            throw new IOException(exception);
        }
        return HadoopUtil.encodeBytes(objectSerializer.serialize(object, compress));
    }

    public static <T> T deserializeBase64(String string2, Configuration conf, Class<T> type) throws IOException {
        return HadoopUtil.deserializeBase64(string2, conf, type, true);
    }

    public static <T> T deserializeBase64(String string2, Configuration conf, Class<T> type, boolean decompress) throws IOException {
        ObjectSerializer objectSerializer;
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        try {
            objectSerializer = HadoopUtil.instantiateSerializer(conf, type);
        }
        catch (ClassNotFoundException exception) {
            throw new IOException(exception);
        }
        return objectSerializer.deserialize(HadoopUtil.decodeBytes(string2), type, decompress);
    }

    public static Class findMainClass(Class defaultType) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!stackTraceElement.getMethodName().equals("main") || stackTraceElement.getClassName().startsWith("org.apache.hadoop")) continue;
            try {
                LOG.info("resolving application jar from found main method on: {}", (Object)stackTraceElement.getClassName());
                return Thread.currentThread().getContextClassLoader().loadClass(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException exception) {
                LOG.warn("unable to load class while discovering application jar: {}", (Object)stackTraceElement.getClassName(), (Object)exception);
            }
        }
        LOG.info("using default application jar, may cause class not found exceptions on the cluster");
        return defaultType;
    }

    public static Map<String, String> getConfig(JobConf defaultConf, JobConf updatedConf) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (Map.Entry entry2 : updatedConf) {
            configs.put((String)entry2.getKey(), (String)entry2.getValue());
        }
        for (Map.Entry entry2 : defaultConf) {
            if (entry2.getValue() == null) continue;
            String updatedValue = (String)configs.get(entry2.getKey());
            if (updatedValue == null && entry2.getValue() == null) {
                configs.remove(entry2.getKey());
            }
            if (updatedValue != null && updatedValue.equals(entry2.getValue())) {
                configs.remove(entry2.getKey());
            }
            configs.remove("mapred.working.dir");
            configs.remove("mapreduce.job.working.dir");
        }
        return configs;
    }

    public static JobConf[] getJobConfs(JobConf job, List<Map<String, String>> configs) {
        JobConf[] jobConfs = new JobConf[configs.size()];
        for (int i = 0; i < jobConfs.length; ++i) {
            jobConfs[i] = HadoopUtil.mergeConf(job, configs.get(i), false);
        }
        return jobConfs;
    }

    public static JobConf mergeConf(JobConf job, Map<String, String> config2, boolean directly) {
        JobConf currentConf = directly ? job : HadoopUtil.copyJobConf(job);
        for (String key : config2.keySet()) {
            LOG.debug("merging key: {} value: {}", (Object)key, (Object)config2.get(key));
            currentConf.set(key, config2.get(key));
        }
        return currentConf;
    }

    public static JobConf removePropertiesFrom(JobConf jobConf, String ... keys2) {
        Map<Object, Object> properties = HadoopUtil.createProperties((Configuration)jobConf);
        for (String key : keys2) {
            properties.remove(key);
        }
        return HadoopUtil.createJobConf(properties, null);
    }

    public static boolean removeStateFromDistCache(JobConf conf, String path) throws IOException {
        return new Hfs(new TextLine(), path).deleteResource(conf);
    }

    public static String writeStateToDistCache(JobConf conf, String id, String stepState) {
        LOG.info("writing step state to dist cache, too large for job conf, size: {}", (Object)stepState.length());
        String statePath = Hfs.getTempPath(conf) + "/step-state-" + id;
        Hfs temp = new Hfs(new TextLine(), statePath, SinkMode.REPLACE);
        try {
            TupleEntryCollector writer = temp.openForWrite(new HadoopFlowProcess(conf));
            writer.add(new Tuple(stepState));
            writer.close();
        }
        catch (IOException exception) {
            throw new FlowException("unable to write step state to Hadoop FS: " + temp.getIdentifier());
        }
        URI uri = new Path(statePath).toUri();
        DistributedCache.addCacheFile((URI)uri, (Configuration)conf);
        LOG.info("using step state path: {}", (Object)uri);
        return statePath;
    }

    public static String readStateFromDistCache(JobConf jobConf, String id) throws IOException {
        Path[] files2 = DistributedCache.getLocalCacheFiles((Configuration)jobConf);
        Path stepStatePath = null;
        for (Path file : files2) {
            if (!file.toString().contains("step-state-" + id)) continue;
            stepStatePath = file;
            break;
        }
        if (stepStatePath == null) {
            throw new FlowException("unable to find step state from distributed cache");
        }
        LOG.info("reading step state from local path: {}", (Object)stepStatePath);
        Lfs temp = new Lfs((Scheme)new TextLine(new Fields(new Comparable[]{"line"})), stepStatePath.toString());
        TupleEntryIterator reader = null;
        try {
            reader = temp.openForRead(new HadoopFlowProcess(jobConf));
            if (!reader.hasNext()) {
                throw new FlowException("step state path is empty: " + temp.getIdentifier());
            }
            String i$ = ((TupleEntry)reader.next()).getString(Integer.valueOf(0));
            return i$;
        }
        catch (IOException exception) {
            throw new FlowException("unable to find state path: " + temp.getIdentifier(), exception);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException exception) {
                LOG.warn("error closing state path reader", exception);
            }
        }
    }

    public static PlatformInfo getPlatformInfo() {
        if (platformInfo == null) {
            platformInfo = HadoopUtil.getPlatformInfoInternal();
        }
        return platformInfo;
    }

    private static PlatformInfo getPlatformInfoInternal() {
        Manifest manifest2;
        URL url = JobConf.class.getResource(JobConf.class.getSimpleName() + ".class");
        if (url == null || !url.toString().startsWith("jar")) {
            return new PlatformInfo("Hadoop", null, null);
        }
        String path = url.toString();
        String manifestPath = path.substring(0, path.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            manifest2 = new Manifest(new URL(manifestPath).openStream());
        }
        catch (IOException exception) {
            LOG.warn("unable to get manifest from {}", (Object)manifestPath, (Object)exception);
            return new PlatformInfo("Hadoop", null, null);
        }
        Attributes attributes = manifest2.getAttributes("org/apache/hadoop");
        if (attributes == null) {
            LOG.debug("unable to get Hadoop manifest attributes");
            return new PlatformInfo("Hadoop", null, null);
        }
        String vendor = attributes.getValue("Implementation-Vendor");
        String version = attributes.getValue("Implementation-Version");
        return new PlatformInfo("Hadoop", vendor, version);
    }

    public static Map<Path, Path> addToClassPath(JobConf config2, List<String> classpath) {
        if (classpath == null) {
            return null;
        }
        HashMap<String, Path> localPaths2 = new HashMap<String, Path>();
        HashMap<String, Path> remotePaths = new HashMap<String, Path>();
        HadoopUtil.resolvePaths(config2, classpath, localPaths2, remotePaths);
        try {
            LocalFileSystem localFS = HadoopUtil.getLocalFS(config2);
            for (String path : localPaths2.keySet()) {
                if (remotePaths.containsKey(path)) continue;
                Path artifact = (Path)localPaths2.get(path);
                DistributedCache.addFileToClassPath((Path)artifact.makeQualified((FileSystem)localFS), (Configuration)config2);
            }
            FileSystem defaultFS = HadoopUtil.getDefaultFS(config2);
            for (String path : remotePaths.keySet()) {
                Path artifact = (Path)remotePaths.get(path);
                DistributedCache.addFileToClassPath((Path)artifact.makeQualified(defaultFS), (Configuration)config2);
            }
        }
        catch (IOException exception) {
            throw new FlowException("unable to set distributed cache paths", exception);
        }
        return HadoopUtil.getCommonPaths(localPaths2, remotePaths);
    }

    public static void syncPaths(JobConf config2, Map<Path, Path> commonPaths) {
        if (commonPaths == null) {
            return;
        }
        Map<Path, Path> copyPaths = HadoopUtil.getCopyPaths(config2, commonPaths);
        FileSystem remoteFS = HadoopUtil.getDefaultFS(config2);
        for (Map.Entry<Path, Path> entry2 : copyPaths.entrySet()) {
            Path localPath = entry2.getKey();
            Path remotePath = entry2.getValue();
            try {
                LOG.info("copying from: {}, to: {}", (Object)localPath, (Object)remotePath);
                remoteFS.copyFromLocalFile(localPath, remotePath);
            }
            catch (IOException exception) {
                throw new FlowException("unable to copy local: " + localPath + " to remote: " + remotePath);
            }
        }
    }

    private static Map<Path, Path> getCommonPaths(Map<String, Path> localPaths2, Map<String, Path> remotePaths) {
        HashMap<Path, Path> commonPaths = new HashMap<Path, Path>();
        for (Map.Entry<String, Path> entry2 : localPaths2.entrySet()) {
            if (!remotePaths.containsKey(entry2.getKey())) continue;
            commonPaths.put(entry2.getValue(), remotePaths.get(entry2.getKey()));
        }
        return commonPaths;
    }

    private static Map<Path, Path> getCopyPaths(JobConf config2, Map<Path, Path> commonPaths) {
        HashMap<Path, Path> copyPaths = new HashMap<Path, Path>();
        FileSystem remoteFS = HadoopUtil.getDefaultFS(config2);
        LocalFileSystem localFS = HadoopUtil.getLocalFS(config2);
        for (Map.Entry<Path, Path> entry2 : commonPaths.entrySet()) {
            Path localPath = entry2.getKey();
            Path remotePath = entry2.getValue();
            try {
                long remoteModTime;
                long localModTime;
                boolean localExists = localFS.exists(localPath);
                boolean remoteExist = remoteFS.exists(remotePath);
                if (localExists && !remoteExist) {
                    copyPaths.put(localPath, remotePath);
                    continue;
                }
                if (!localExists || (localModTime = localFS.getFileStatus(localPath).getModificationTime()) <= (remoteModTime = remoteFS.getFileStatus(remotePath).getModificationTime())) continue;
                copyPaths.put(localPath, remotePath);
            }
            catch (IOException exception) {
                throw new FlowException("unable to get handle to underlying filesystem", exception);
            }
        }
        return copyPaths;
    }

    private static void resolvePaths(JobConf config2, List<String> classpath, Map<String, Path> localPaths2, Map<String, Path> remotePaths) {
        FileSystem defaultFS = HadoopUtil.getDefaultFS(config2);
        LocalFileSystem localFS = HadoopUtil.getLocalFS(config2);
        boolean defaultIsLocal = defaultFS.equals(localFS);
        for (String stringPath : classpath) {
            URI uri = URI.create(stringPath);
            Path path = new Path(uri.toString());
            if (uri.getScheme() == null && !defaultIsLocal) {
                Path localPath = path.makeQualified((FileSystem)localFS);
                if (!HadoopUtil.exists((FileSystem)localFS, localPath)) {
                    throw new FlowException("path not found: " + localPath);
                }
                localPaths2.put(stringPath, localPath);
                remotePaths.put(stringPath, path.makeQualified(defaultFS));
                continue;
            }
            if (localFS.equals(HadoopUtil.getFileSystem(config2, path))) {
                if (!HadoopUtil.exists((FileSystem)localFS, path)) {
                    throw new FlowException("path not found: " + path);
                }
                localPaths2.put(stringPath, path);
                continue;
            }
            if (!HadoopUtil.exists(defaultFS, path)) {
                throw new FlowException("path not found: " + path);
            }
            remotePaths.put(stringPath, path);
        }
    }

    private static boolean exists(FileSystem fileSystem, Path path) {
        try {
            return fileSystem.exists(path);
        }
        catch (IOException exception) {
            throw new FlowException("could not test file exists: " + path);
        }
    }

    private static FileSystem getFileSystem(JobConf config2, Path path) {
        try {
            return path.getFileSystem((Configuration)config2);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get handle to underlying filesystem", exception);
        }
    }

    private static LocalFileSystem getLocalFS(JobConf config2) {
        try {
            return FileSystem.getLocal((Configuration)config2);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get handle to underlying filesystem", exception);
        }
    }

    private static FileSystem getDefaultFS(JobConf config2) {
        try {
            return FileSystem.get((Configuration)config2);
        }
        catch (IOException exception) {
            throw new FlowException("unable to get handle to underlying filesystem", exception);
        }
    }

    public static boolean isLocal(JobConf conf) {
        String frameworkName = conf.get("mapreduce.framework.name");
        if (frameworkName != null) {
            return frameworkName.equals("local");
        }
        return conf.get("mapred.job.tracker").equals("local");
    }

    public static void setLocal(JobConf conf) {
        conf.set("mapred.job.tracker", "local");
        conf.set("mapreduce.framework.name", "local");
    }
}

