/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.flow.FlowElement;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.hadoop.stream.HadoopCoGroupGate;
import cascading.flow.hadoop.stream.HadoopGroupByGate;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.hadoop.stream.HadoopSinkStage;
import cascading.flow.stream.Gate;
import cascading.flow.stream.SinkStage;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StepStreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.Group;
import cascading.pipe.GroupBy;
import cascading.pipe.HashJoin;
import cascading.tap.Tap;
import java.util.List;

public class HadoopReduceStreamGraph
extends StepStreamGraph {
    public HadoopReduceStreamGraph(HadoopFlowProcess flowProcess, HadoopFlowStep step) {
        super(flowProcess, step);
        this.buildGraph();
        this.setTraps();
        this.setScopes();
        this.printGraph(step.getID(), "reduce", flowProcess.getCurrentSliceNum());
        this.bind();
    }

    protected void buildGraph() {
        Group group2 = this.step.getGroup();
        HadoopGroupGate rhsDuct = group2.isGroupBy() ? new HadoopGroupByGate(this.flowProcess, (GroupBy)group2, SpliceGate.Role.source) : new HadoopCoGroupGate(this.flowProcess, (CoGroup)group2, SpliceGate.Role.source);
        this.addHead(rhsDuct);
        this.handleDuct(group2, rhsDuct);
    }

    @Override
    protected SinkStage createSinkStage(Tap element) {
        return new HadoopSinkStage(this.flowProcess, element);
    }

    @Override
    protected Gate createCoGroupGate(CoGroup element) {
        throw new IllegalStateException("should not happen");
    }

    @Override
    protected Gate createGroupByGate(GroupBy element) {
        throw new IllegalStateException("should not happen");
    }

    @Override
    protected Gate createHashJoinGate(HashJoin join2) {
        throw new IllegalStateException("should not happen");
    }

    @Override
    protected boolean stopOnElement(FlowElement lhsElement, List<FlowElement> successors) {
        if (successors.isEmpty()) {
            if (!(lhsElement instanceof Tap)) {
                throw new IllegalStateException("expected a Tap instance");
            }
            return true;
        }
        return false;
    }
}

