/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopGroupByClosure;
import cascading.flow.stream.Duct;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StreamGraph;
import cascading.pipe.Splice;
import cascading.pipe.joiner.BufferJoin;
import cascading.tap.hadoop.util.MeasuredOutputCollector;
import cascading.tuple.Tuple;
import java.util.Iterator;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class HadoopGroupGate
extends SpliceGate {
    protected HadoopGroupByClosure closure;
    protected OutputCollector collector;

    public HadoopGroupGate(FlowProcess flowProcess, Splice splice, SpliceGate.Role role) {
        super(flowProcess, splice, role);
    }

    @Override
    public void bind(StreamGraph streamGraph) {
        this.allPrevious = this.getAllPreviousFor(streamGraph);
        if (this.role != SpliceGate.Role.sink) {
            this.next = this.getNextFor(streamGraph);
        }
    }

    @Override
    public void prepare() {
        this.collector = new MeasuredOutputCollector(this.flowProcess, SliceCounters.Write_Duration, ((HadoopFlowProcess)this.flowProcess).getOutputCollector());
    }

    @Override
    public void start(Duct previous) {
        if (this.next != null) {
            super.start(previous);
        }
    }

    @Override
    public void complete(Duct previous) {
        if (this.next != null) {
            super.complete(previous);
        }
    }

    public void run(Tuple key, Iterator values2) {
        key = this.unwrapGrouping(key);
        this.closure.reset(key, values2);
        if (!(this.splice.getJoiner() instanceof BufferJoin)) {
            values2 = this.splice.getJoiner().getIterator(this.closure);
        }
        this.keyEntry.setTuple(this.closure.getGroupTuple(key));
        this.tupleEntryIterator.reset(values2);
        this.next.receive(this, this.grouping);
    }

    protected abstract Tuple unwrapGrouping(Tuple var1);
}

