/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopGroupByClosure;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.stream.Duct;
import cascading.flow.stream.DuctException;
import cascading.flow.stream.SpliceGate;
import cascading.pipe.GroupBy;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.io.TuplePair;

public class HadoopGroupByGate
extends HadoopGroupGate {
    public HadoopGroupByGate(FlowProcess flowProcess, GroupBy groupBy2, SpliceGate.Role role) {
        super(flowProcess, groupBy2, role);
    }

    @Override
    public void prepare() {
        super.prepare();
        if (this.role != SpliceGate.Role.sink) {
            this.closure = new HadoopGroupByClosure(this.flowProcess, this.keyFields, this.valuesFields);
        }
        if (this.grouping != null && this.splice.getJoinDeclaredFields() != null && this.splice.getJoinDeclaredFields().isNone()) {
            this.grouping.joinerClosure = this.closure;
        }
    }

    @Override
    public void receive(Duct previous, TupleEntry incomingEntry) {
        Tuple groupTuple = this.keyBuilder[0].makeResult(incomingEntry.getTuple(), null);
        Tuple sortTuple = this.sortFields == null ? null : this.sortBuilder[0].makeResult(incomingEntry.getTuple(), null);
        Tuple valuesTuple = this.valuesBuilder[0].makeResult(incomingEntry.getTuple(), null);
        Tuple groupKey = sortTuple == null ? groupTuple : new TuplePair(groupTuple, sortTuple);
        try {
            this.collector.collect((Object)groupKey, (Object)valuesTuple);
            this.flowProcess.increment(SliceCounters.Tuples_Written, 1L);
        }
        catch (OutOfMemoryError error2) {
            this.handleReThrowableException("out of memory, try increasing task memory allocation", error2);
        }
        catch (CascadingException exception) {
            this.handleException(exception, incomingEntry);
        }
        catch (Throwable throwable2) {
            this.handleException(new DuctException("internal error: " + incomingEntry.getTuple().print(), throwable2), incomingEntry);
        }
    }

    @Override
    protected Tuple unwrapGrouping(Tuple key) {
        return this.sortFields == null ? key : ((TuplePair)key).getLhs();
    }
}

