/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.planner;

import cascading.flow.FlowElement;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.planner.ElementGraph;
import cascading.flow.planner.ElementGraphs;
import cascading.flow.planner.FlowStepGraph;
import cascading.flow.planner.PlannerException;
import cascading.flow.planner.Scope;
import cascading.pipe.Group;
import cascading.pipe.HashJoin;
import cascading.pipe.Pipe;
import cascading.pipe.Splice;
import cascading.tap.Tap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.mapred.JobConf;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStepGraph
extends FlowStepGraph<JobConf> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStepGraph.class);

    public HadoopStepGraph() {
    }

    public HadoopStepGraph(String flowName, ElementGraph elementGraph) {
        super(flowName, elementGraph);
    }

    @Override
    protected FlowStep<JobConf> createFlowStep(String stepName, int stepNum) {
        return new HadoopFlowStep(stepName, stepNum);
    }

    @Override
    protected void makeStepGraph(String flowName, ElementGraph elementGraph) {
        SimpleDirectedGraph<Tap, Integer> tapGraph = elementGraph.makeTapGraph();
        int numJobs = this.countNumJobs(tapGraph);
        LinkedHashMap steps = new LinkedHashMap();
        TopologicalOrderIterator<Tap, Integer> iterator2 = new TopologicalOrderIterator<Tap, Integer>(tapGraph);
        int count2 = 0;
        while (iterator2.hasNext()) {
            Tap source2 = (Tap)iterator2.next();
            LOG.debug("handling source: {}", (Object)source2);
            List<Tap> sinks = Graphs.successorListOf(tapGraph, source2);
            for (Tap sink2 : sinks) {
                LOG.debug("handling path: {} -> {}", (Object)source2, (Object)sink2);
                HadoopFlowStep step = (HadoopFlowStep)this.getCreateFlowStep(steps, sink2, numJobs);
                this.addVertex(step);
                if (steps.containsKey(source2)) {
                    this.addEdge(steps.get(source2), step, count2++);
                }
                this.populateStep(elementGraph, source2, sink2, step);
            }
        }
    }

    private void populateStep(ElementGraph elementGraph, Tap source2, Tap sink2, HadoopFlowStep step) {
        Map<String, Tap> traps = elementGraph.getTrapMap();
        List<GraphPath<FlowElement, Scope>> paths = ElementGraphs.getAllShortestPathsBetween(elementGraph, source2, sink2);
        for (GraphPath<FlowElement, Scope> path : paths) {
            if (this.pathContainsTap(path)) continue;
            List<Scope> scopes = path.getEdgeList();
            String sourceName = scopes.get(0).getName();
            String sinkName = scopes.get(scopes.size() - 1).getName();
            step.addSource(sourceName, source2);
            step.addSink(sinkName, sink2);
            FlowElement lhs = source2;
            step.getGraph().addVertex(lhs);
            boolean onMapSide = true;
            for (Scope scope : scopes) {
                FlowElement rhs = (FlowElement)elementGraph.getEdgeTarget(scope);
                step.getGraph().addVertex(rhs);
                step.getGraph().addEdge(lhs, rhs, scope);
                if (rhs instanceof Group) {
                    step.addGroup((Group)rhs);
                    onMapSide = false;
                } else if (rhs instanceof HashJoin) {
                    if (!onMapSide) {
                        throw new PlannerException("joins must not present Reduce side");
                    }
                    Map<Integer, Integer> sourcePaths = ElementGraphs.countOrderedDirectPathsBetween(elementGraph, source2, (Splice)rhs);
                    boolean isStreamed = ElementGraphs.isOnlyStreamedPath(sourcePaths);
                    boolean isAccumulated = ElementGraphs.isOnlyAccumulatedPath(sourcePaths);
                    boolean isBoth = ElementGraphs.isBothAccumulatedAndStreamedPath(sourcePaths);
                    if (isStreamed || isBoth) {
                        step.addStreamedSourceFor((HashJoin)rhs, source2);
                    }
                    if (isAccumulated || isBoth) {
                        step.addAccumulatedSourceFor((HashJoin)rhs, source2);
                    }
                } else if (rhs instanceof Pipe) {
                    String name2 = ((Pipe)rhs).getName();
                    if (traps.containsKey(name2)) {
                        if (onMapSide) {
                            step.getMapperTraps().put(name2, traps.get(name2));
                        } else {
                            step.getReducerTraps().put(name2, traps.get(name2));
                        }
                    }
                } else if (rhs instanceof Tap) {
                    if (onMapSide) {
                        step.getMapperTraps().putAll(traps);
                    } else {
                        step.getReducerTraps().putAll(traps);
                    }
                }
                lhs = rhs;
            }
        }
    }

    private int countNumJobs(SimpleDirectedGraph<Tap, Integer> tapGraph) {
        Set vertices = tapGraph.vertexSet();
        int count2 = 0;
        for (Tap vertex : vertices) {
            if (tapGraph.inDegreeOf(vertex) == 0) continue;
            ++count2;
        }
        return count2;
    }
}

