/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.planner;

import cascading.flow.FlowConnector;
import cascading.flow.FlowDef;
import cascading.flow.FlowElement;
import cascading.flow.hadoop.HadoopFlow;
import cascading.flow.hadoop.planner.HadoopStepGraph;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.ElementGraph;
import cascading.flow.planner.ElementGraphs;
import cascading.flow.planner.FlowPlanner;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.pipe.CoGroup;
import cascading.pipe.Every;
import cascading.pipe.Group;
import cascading.pipe.Pipe;
import cascading.property.AppProps;
import cascading.property.PropertyUtil;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import cascading.tap.hadoop.util.TempHfs;
import cascading.util.Util;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.mapred.JobConf;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopPlanner
extends FlowPlanner<HadoopFlow, JobConf> {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopPlanner.class);
    private JobConf jobConf;
    private Class intermediateSchemeClass;

    public static void copyJobConf(Map<Object, Object> properties, JobConf jobConf) {
        for (Map.Entry entry2 : jobConf) {
            properties.put(entry2.getKey(), entry2.getValue());
        }
    }

    public static JobConf createJobConf(Map<Object, Object> properties) {
        JobConf conf = new JobConf();
        HadoopPlanner.copyProperties(conf, properties);
        return conf;
    }

    public static void copyProperties(JobConf jobConf, Map<Object, Object> properties) {
        if (properties instanceof Properties) {
            Properties props = (Properties)properties;
            Set<String> keys2 = props.stringPropertyNames();
            for (String key : keys2) {
                jobConf.set(key, props.getProperty(key));
            }
        } else {
            for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
                if (entry2.getValue() == null) continue;
                jobConf.set(entry2.getKey().toString(), entry2.getValue().toString());
            }
        }
    }

    @Deprecated
    public static void setNormalizeHeterogeneousSources(Map<Object, Object> properties, boolean doNormalize) {
        properties.put("cascading.multimapreduceplanner.normalizesources", Boolean.toString(doNormalize));
    }

    @Deprecated
    public static boolean getNormalizeHeterogeneousSources(Map<Object, Object> properties) {
        return Boolean.parseBoolean(PropertyUtil.getProperty(properties, "cascading.multimapreduceplanner.normalizesources", "false"));
    }

    public static void setCollapseAdjacentTaps(Map<Object, Object> properties, boolean collapseAdjacent) {
        properties.put("cascading.multimapreduceplanner.collapseadjacentaps", Boolean.toString(collapseAdjacent));
    }

    public static boolean getCollapseAdjacentTaps(Map<Object, Object> properties) {
        return Boolean.parseBoolean(PropertyUtil.getProperty(properties, "cascading.multimapreduceplanner.collapseadjacentaps", "true"));
    }

    @Override
    public JobConf getConfig() {
        return this.jobConf;
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return HadoopUtil.getPlatformInfo();
    }

    @Override
    public void initialize(FlowConnector flowConnector, Map<Object, Object> properties) {
        super.initialize(flowConnector, properties);
        this.jobConf = HadoopUtil.createJobConf(properties, HadoopPlanner.createJobConf(properties));
        this.intermediateSchemeClass = flowConnector.getIntermediateSchemeClass(properties);
        Class type = AppProps.getApplicationJarClass(properties);
        if (this.jobConf.getJar() == null && type != null) {
            this.jobConf.setJarByClass(type);
        }
        String path = AppProps.getApplicationJarPath(properties);
        if (this.jobConf.getJar() == null && path != null) {
            this.jobConf.setJar(path);
        }
        if (this.jobConf.getJar() == null) {
            this.jobConf.setJarByClass(HadoopUtil.findMainClass(HadoopPlanner.class));
        }
        AppProps.setApplicationJarPath(properties, this.jobConf.getJar());
        LOG.info("using application jar: {}", (Object)this.jobConf.getJar());
    }

    @Override
    protected HadoopFlow createFlow(FlowDef flowDef) {
        return new HadoopFlow(this.getPlatformInfo(), this.getProperties(), this.getConfig(), flowDef);
    }

    @Override
    public HadoopFlow buildFlow(FlowDef flowDef) {
        ElementGraph elementGraph = null;
        try {
            this.verifyAllTaps(flowDef);
            HadoopFlow flow = this.createFlow(flowDef);
            Pipe[] tails2 = this.resolveTails(flowDef, flow);
            this.verifyAssembly(flowDef, tails2);
            elementGraph = this.createElementGraph(flowDef, tails2);
            this.failOnLoneGroupAssertion(elementGraph);
            this.failOnMissingGroup(elementGraph);
            this.failOnMisusedBuffer(elementGraph);
            this.failOnGroupEverySplit(elementGraph);
            this.handleWarnEquivalentPaths(elementGraph);
            this.handleSplit(elementGraph);
            this.handleJobPartitioning(elementGraph);
            this.handleJoins(elementGraph);
            this.handleNonSafeOperations(elementGraph);
            if (HadoopPlanner.getNormalizeHeterogeneousSources(this.properties)) {
                this.handleHeterogeneousSources(elementGraph);
            }
            elementGraph.removeUnnecessaryPipes();
            elementGraph.resolveFields();
            elementGraph = flow.updateSchemes(elementGraph);
            if (HadoopPlanner.getCollapseAdjacentTaps(this.properties)) {
                this.handleAdjacentTaps(elementGraph);
            }
            HadoopStepGraph flowStepGraph = new HadoopStepGraph(flowDef.getName(), elementGraph);
            flow.initialize(elementGraph, flowStepGraph);
            return flow;
        }
        catch (Exception exception) {
            throw this.handleExceptionDuringPlanning(exception, elementGraph);
        }
    }

    private void handleWarnEquivalentPaths(ElementGraph elementGraph) {
        List<CoGroup> coGroups = elementGraph.findAllCoGroups();
        for (CoGroup coGroup : coGroups) {
            List<GraphPath<FlowElement, Scope>> graphPaths = elementGraph.getAllShortestPathsTo(coGroup);
            List<List<FlowElement>> paths = ElementGraphs.asPathList(graphPaths);
            if (!this.areEquivalentPaths(elementGraph, paths)) continue;
            LOG.warn("found equivalent paths from: {} to: {}", (Object)paths.get(0).get(1), (Object)coGroup);
        }
    }

    private boolean areEquivalentPaths(ElementGraph elementGraph, List<List<FlowElement>> paths) {
        int length = this.sameLength(paths);
        if (length == -1) {
            return false;
        }
        TreeSet<FlowElement> elements = new TreeSet<FlowElement>(new EquivalenceComparator(elementGraph));
        for (int i = 0; i < length; ++i) {
            elements.clear();
            for (List<FlowElement> path : paths) {
                elements.add(path.get(i));
            }
            if (elements.size() == 1) continue;
            return false;
        }
        return true;
    }

    private int sameLength(List<List<FlowElement>> paths) {
        int lastSize = paths.get(0).size();
        for (int i = 1; i < paths.size(); ++i) {
            if (paths.get(i).size() == lastSize) continue;
            return -1;
        }
        return lastSize;
    }

    private void handleSplit(ElementGraph elementGraph) {
        while (!this.internalSplit(elementGraph)) {
        }
    }

    private boolean internalSplit(ElementGraph elementGraph) {
        List<GraphPath<FlowElement, Scope>> paths = elementGraph.getAllShortestPathsBetweenExtents();
        for (GraphPath<FlowElement, Scope> path : paths) {
            List<FlowElement> flowElements = Graphs.getPathVertexList(path);
            HashSet<Pipe> tapInsertions = new HashSet<Pipe>();
            FlowElement lastInsertable = null;
            for (int i = 0; i < flowElements.size(); ++i) {
                int maxPaths;
                FlowElement flowElement = flowElements.get(i);
                if (flowElement instanceof ElementGraph.Extent) continue;
                if (flowElement instanceof Tap || flowElement instanceof Group || flowElement instanceof Every) {
                    lastInsertable = flowElement;
                }
                if (flowElement.getClass() == Pipe.class && flowElements.get(i - 1) instanceof Tap || flowElement instanceof Tap || elementGraph.outDegreeOf(flowElement) <= 1 || (maxPaths = elementGraph.getMaxNumPathsBetweenElementAndGroupingMergeJoin(flowElement)) <= 1 && lastInsertable instanceof Tap) continue;
                tapInsertions.add((Pipe)flowElement);
            }
            for (Pipe pipe : tapInsertions) {
                this.insertTempTapAfter(elementGraph, pipe);
            }
            if (tapInsertions.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void handleAdjacentTaps(ElementGraph elementGraph) {
        while (!this.internalAdjacentTaps(elementGraph)) {
        }
    }

    private boolean internalAdjacentTaps(ElementGraph elementGraph) {
        List<Tap> taps = elementGraph.findAllTaps();
        for (Tap tap : taps) {
            if (!tap.isTemporary()) continue;
            for (FlowElement successor : elementGraph.getAllSuccessors(tap)) {
                URI successorURIScheme;
                URI tempURIScheme;
                Hfs successorTap;
                if (!(successor instanceof Hfs) || !(successorTap = (Hfs)successor).getScheme().isSymmetrical() || !(tempURIScheme = this.getDefaultURIScheme(tap)).equals(successorURIScheme = this.getURIScheme(successorTap)) || !tap.getSourceFields().equals(successorTap.getSourceFields())) continue;
                elementGraph.replaceElementWith(tap, successor);
                return false;
            }
        }
        return true;
    }

    private URI getDefaultURIScheme(Tap tap) {
        return ((Hfs)tap).getDefaultFileSystemURIScheme(this.jobConf);
    }

    private URI getURIScheme(Tap tap) {
        return ((Hfs)tap).getURIScheme(this.jobConf);
    }

    private void handleHeterogeneousSources(ElementGraph elementGraph) {
        while (!this.internalHeterogeneousSources(elementGraph)) {
        }
    }

    private boolean internalHeterogeneousSources(ElementGraph elementGraph) {
        Set<Tap> taps;
        List<Group> groups = elementGraph.findAllMergeJoinGroups();
        HashMap<Group, Set<Tap>> normalizeGroups = new HashMap<Group, Set<Tap>>();
        block0: for (Group group2 : groups) {
            taps = new HashSet();
            block1: for (GraphPath<FlowElement, Scope> path : elementGraph.getAllShortestPathsTo(group2)) {
                List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                Collections.reverse(flowElements);
                for (FlowElement previousElement : flowElements) {
                    if (!(previousElement instanceof Tap)) continue;
                    taps.add((Tap)previousElement);
                    continue block1;
                }
            }
            if (taps.size() == 1) continue;
            Iterator iterator2 = taps.iterator();
            Tap commonTap = (Tap)iterator2.next();
            while (iterator2.hasNext()) {
                Tap tap = (Tap)iterator2.next();
                if (this.getSchemeClass(tap) == this.getSchemeClass(commonTap)) continue;
                normalizeGroups.put(group2, taps);
                continue block0;
            }
        }
        for (Group group2 : normalizeGroups.keySet()) {
            taps = (Set)normalizeGroups.get(group2);
            for (Tap tap : taps) {
                if (tap.isTemporary() || this.getSchemeClass(tap).equals(this.intermediateSchemeClass)) continue;
                for (GraphPath<FlowElement, Scope> path : ElementGraphs.getAllShortestPathsBetween(elementGraph, tap, group2)) {
                    List<FlowElement> flowElements = Graphs.getPathVertexList(path);
                    Collections.reverse(flowElements);
                    FlowElement flowElement = flowElements.get(1);
                    if (flowElement instanceof Tap && ((Tap)flowElement).isTemporary()) continue;
                    LOG.warn("inserting step to normalize incompatible sources: {}", (Object)tap);
                    this.insertTempTapAfter(elementGraph, (Pipe)flowElement);
                    return false;
                }
            }
        }
        return normalizeGroups.isEmpty();
    }

    @Override
    protected Tap makeTempTap(String prefix, String name2) {
        return new TempHfs(this.jobConf, Util.makePath(prefix, name2), this.intermediateSchemeClass, prefix == null);
    }

    private Class getSchemeClass(Tap tap) {
        if (tap.isTemporary()) {
            return ((TempHfs)tap).getSchemeClass();
        }
        return tap.getScheme().getClass();
    }

    private class EquivalenceComparator
    implements Comparator<FlowElement> {
        private final ElementGraph elementGraph;

        public EquivalenceComparator(ElementGraph elementGraph) {
            this.elementGraph = elementGraph;
        }

        @Override
        public int compare(FlowElement lhs, FlowElement rhs) {
            boolean sameOutgoing;
            boolean areEquivalent = lhs.isEquivalentTo(rhs);
            boolean sameIncoming = this.elementGraph.inDegreeOf(lhs) == this.elementGraph.inDegreeOf(rhs);
            boolean bl = sameOutgoing = this.elementGraph.outDegreeOf(lhs) == this.elementGraph.outDegreeOf(rhs);
            if (areEquivalent && sameIncoming && sameOutgoing) {
                return 0;
            }
            return System.identityHashCode(lhs) - System.identityHashCode(rhs);
        }
    }
}

