/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.planner;

import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.FlowStepJob;
import cascading.management.state.ClientState;
import cascading.stats.FlowStepStats;
import cascading.stats.hadoop.HadoopStepStats;
import java.io.IOException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;

public class HadoopFlowStepJob
extends FlowStepJob<JobConf> {
    private static Throwable localError;
    private final JobConf currentConf;
    private JobClient jobClient;
    private RunningJob runningJob;

    private static long getStoreInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.stats.store.interval", 60000L);
    }

    public static long getJobPollingInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.flow.job.pollinginterval", 5000L);
    }

    public HadoopFlowStepJob(ClientState clientState, BaseFlowStep flowStep, JobConf currentConf) {
        super(clientState, flowStep, HadoopFlowStepJob.getJobPollingInterval(currentConf), HadoopFlowStepJob.getStoreInterval(currentConf));
        this.currentConf = currentConf;
        if (flowStep.isDebugEnabled()) {
            flowStep.logDebug("using polling interval: " + this.pollingInterval);
        }
    }

    @Override
    public JobConf getConfig() {
        return this.currentConf;
    }

    @Override
    protected FlowStepStats createStepStats(ClientState clientState) {
        return new HadoopStepStats(this.flowStep, clientState){

            @Override
            public JobClient getJobClient() {
                return HadoopFlowStepJob.this.jobClient;
            }

            @Override
            public RunningJob getRunningJob() {
                return HadoopFlowStepJob.this.runningJob;
            }
        };
    }

    @Override
    protected void internalBlockOnStop() throws IOException {
        if (this.runningJob != null && !this.runningJob.isComplete()) {
            this.runningJob.killJob();
        }
    }

    @Override
    protected void internalNonBlockingStart() throws IOException {
        this.jobClient = new JobClient(this.currentConf);
        this.runningJob = this.jobClient.submitJob(this.currentConf);
        this.flowStep.logInfo("submitted hadoop job: " + this.runningJob.getID());
        if (this.runningJob.getTrackingURL() != null) {
            this.flowStep.logInfo("tracking url: " + this.runningJob.getTrackingURL());
        }
    }

    @Override
    protected boolean internalNonBlockingIsSuccessful() throws IOException {
        return this.runningJob != null && this.runningJob.isSuccessful();
    }

    @Override
    protected boolean isRemoteExecution() {
        return !((HadoopFlowStep)this.flowStep).isHadoopLocalMode(this.getConfig());
    }

    @Override
    protected Throwable getThrowable() {
        return localError;
    }

    @Override
    protected String internalJobId() {
        return this.runningJob.getJobID();
    }

    @Override
    protected boolean internalNonBlockingIsComplete() throws IOException {
        return this.runningJob.isComplete();
    }

    @Override
    protected void dumpDebugInfo() {
        try {
            if (this.runningJob == null) {
                return;
            }
            this.flowStep.logWarn("hadoop job " + this.runningJob.getID() + " state at " + JobStatus.getJobRunState((int)this.runningJob.getJobState()));
            this.flowStep.logWarn("failure info: " + this.runningJob.getFailureInfo());
            TaskCompletionEvent[] events2 = this.runningJob.getTaskCompletionEvents(0);
            this.flowStep.logWarn("task completion events identify failed tasks");
            this.flowStep.logWarn("task completion events count: " + events2.length);
            for (TaskCompletionEvent event : events2) {
                this.flowStep.logWarn("event = " + event);
            }
        }
        catch (IOException exception) {
            this.flowStep.logError("failed reading task completion events", exception);
        }
    }

    @Override
    protected boolean internalIsStarted() {
        if (this.runningJob == null) {
            return false;
        }
        try {
            return this.runningJob.mapProgress() > 0.0f;
        }
        catch (IOException exception) {
            this.flowStep.logWarn("unable to test for map progress", exception);
            return false;
        }
    }

    public static void reportLocalError(Throwable throwable2) {
        localError = throwable2;
    }
}

