/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.FlowProcess;
import cascading.pipe.joiner.JoinerClosure;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.util.TupleBuilder;
import cascading.tuple.util.TupleViews;
import java.util.Iterator;

public class HadoopGroupByClosure
extends JoinerClosure {
    protected Tuple grouping;
    protected Iterator values;

    public HadoopGroupByClosure(FlowProcess flowProcess, Fields[] groupingFields, Fields[] valueFields) {
        super(flowProcess, groupingFields, valueFields);
    }

    public Tuple getGrouping() {
        return this.grouping;
    }

    @Override
    public int size() {
        return 1;
    }

    public Iterator getIterator(int pos) {
        if (pos != 0) {
            throw new IllegalArgumentException("invalid group position: " + pos);
        }
        return this.makeIterator(0, this.values);
    }

    @Override
    public boolean isEmpty(int pos) {
        return this.values != null;
    }

    protected Iterator<Tuple> makeIterator(final int pos, final Iterator values2) {
        return new Iterator<Tuple>(){
            final int cleanPos;
            TupleBuilder[] valueBuilder;
            {
                this.cleanPos = HadoopGroupByClosure.this.valueFields.length == 1 ? 0 : pos;
                this.valueBuilder = new TupleBuilder[HadoopGroupByClosure.this.valueFields.length];
                for (int i = 0; i < HadoopGroupByClosure.this.valueFields.length; ++i) {
                    this.valueBuilder[i] = this.makeBuilder(HadoopGroupByClosure.this.valueFields[i], HadoopGroupByClosure.this.joinFields[i]);
                }
            }

            private TupleBuilder makeBuilder(final Fields valueField, final Fields joinField) {
                if (valueField.isUnknown() || joinField.isNone()) {
                    return new TupleBuilder(){

                        @Override
                        public Tuple makeResult(Tuple valueTuple, Tuple groupTuple) {
                            valueTuple.set(HadoopGroupByClosure.this.valueFields[cleanPos], HadoopGroupByClosure.this.joinFields[cleanPos], groupTuple);
                            return valueTuple;
                        }
                    };
                }
                return new TupleBuilder(){
                    Tuple result;
                    {
                        this.result = TupleViews.createOverride(valueField, joinField);
                    }

                    @Override
                    public Tuple makeResult(Tuple valueTuple, Tuple groupTuple) {
                        return TupleViews.reset(this.result, valueTuple, groupTuple);
                    }
                };
            }

            @Override
            public boolean hasNext() {
                return values2.hasNext();
            }

            @Override
            public Tuple next() {
                Tuple tuple = (Tuple)values2.next();
                return this.valueBuilder[this.cleanPos].makeResult(tuple, HadoopGroupByClosure.this.grouping);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    public void reset(Tuple grouping, Iterator values2) {
        this.grouping = grouping;
        this.values = values2;
    }

    @Override
    public Tuple getGroupTuple(Tuple keysTuple) {
        return keysTuple;
    }
}

