/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.hadoop.FlowMapper;
import cascading.flow.hadoop.FlowReducer;
import cascading.flow.hadoop.planner.HadoopFlowStepJob;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.FlowStepJob;
import cascading.flow.planner.PlatformInfo;
import cascading.flow.planner.Scope;
import cascading.property.ConfigDef;
import cascading.tap.Tap;
import cascading.tap.hadoop.io.MultiInputFormat;
import cascading.tap.hadoop.util.Hadoop18TapUtil;
import cascading.tap.hadoop.util.TempHfs;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.hadoop.TupleSerialization;
import cascading.tuple.hadoop.util.CoGroupingComparator;
import cascading.tuple.hadoop.util.CoGroupingPartitioner;
import cascading.tuple.hadoop.util.GroupingComparator;
import cascading.tuple.hadoop.util.GroupingPartitioner;
import cascading.tuple.hadoop.util.GroupingSortingComparator;
import cascading.tuple.hadoop.util.GroupingSortingPartitioner;
import cascading.tuple.hadoop.util.IndexTupleCoGroupingComparator;
import cascading.tuple.hadoop.util.ReverseGroupingSortingComparator;
import cascading.tuple.hadoop.util.ReverseTupleComparator;
import cascading.tuple.hadoop.util.TupleComparator;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TuplePair;
import cascading.util.Util;
import cascading.util.Version;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;

public class HadoopFlowStep
extends BaseFlowStep<JobConf> {
    private final Map<String, Tap> mapperTraps = new HashMap<String, Tap>();
    private final Map<String, Tap> reducerTraps = new HashMap<String, Tap>();

    public HadoopFlowStep(String name2, int stepNum) {
        super(name2, stepNum);
    }

    @Override
    public JobConf getInitializedConfig(FlowProcess<JobConf> flowProcess, JobConf parentConfig) {
        JobConf conf = parentConfig == null ? new JobConf() : HadoopUtil.copyJobConf(parentConfig);
        conf.setBoolean("mapred.used.genericoptionsparser", true);
        conf.setJobName(this.getStepDisplayName(conf.getInt("cascading.step.display.id.truncate", Util.ID_LENGTH)));
        conf.setOutputKeyClass(Tuple.class);
        conf.setOutputValueClass(Tuple.class);
        conf.setMapRunnerClass(FlowMapper.class);
        conf.setReducerClass(FlowReducer.class);
        TupleSerialization.setSerializations(conf);
        this.initFromSources(flowProcess, conf);
        this.initFromSink(flowProcess, conf);
        this.initFromTraps(flowProcess, conf);
        this.initFromProcessConfigDef(conf);
        if (this.getSink().getScheme().getNumSinkParts() != 0) {
            if (this.getGroup() != null) {
                conf.setNumReduceTasks(this.getSink().getScheme().getNumSinkParts());
            } else {
                conf.setNumMapTasks(this.getSink().getScheme().getNumSinkParts());
            }
        }
        conf.setOutputKeyComparatorClass(TupleComparator.class);
        if (this.getGroup() == null) {
            conf.setNumReduceTasks(0);
        } else {
            conf.setMapOutputKeyClass(Tuple.class);
            conf.setMapOutputValueClass(Tuple.class);
            conf.setPartitionerClass(GroupingPartitioner.class);
            if (this.getGroup().isSortReversed()) {
                conf.setOutputKeyComparatorClass(ReverseTupleComparator.class);
            }
            this.addComparators(conf, "cascading.group.comparator", this.getGroup().getKeySelectors());
            if (this.getGroup().isGroupBy()) {
                this.addComparators(conf, "cascading.sort.comparator", this.getGroup().getSortingSelectors());
            }
            if (!this.getGroup().isGroupBy()) {
                conf.setPartitionerClass(CoGroupingPartitioner.class);
                conf.setMapOutputKeyClass(IndexTuple.class);
                conf.setMapOutputValueClass(IndexTuple.class);
                conf.setOutputKeyComparatorClass(IndexTupleCoGroupingComparator.class);
                conf.setOutputValueGroupingComparator(CoGroupingComparator.class);
            }
            if (this.getGroup().isSorted()) {
                conf.setPartitionerClass(GroupingSortingPartitioner.class);
                conf.setMapOutputKeyClass(TuplePair.class);
                if (this.getGroup().isSortReversed()) {
                    conf.setOutputKeyComparatorClass(ReverseGroupingSortingComparator.class);
                } else {
                    conf.setOutputKeyComparatorClass(GroupingSortingComparator.class);
                }
                conf.setOutputValueGroupingComparator(GroupingComparator.class);
            }
        }
        String versionString = Version.getRelease();
        if (versionString != null) {
            conf.set("cascading.version", versionString);
        }
        conf.set("cascading.flow.step.id", this.getID());
        conf.set("cascading.flow.step.num", Integer.toString(this.getStepNum()));
        String stepState = this.pack(this, conf);
        int maxSize = Short.MAX_VALUE;
        if (this.isHadoopLocalMode(conf) || stepState.length() < maxSize) {
            conf.set("cascading.flow.step", stepState);
        } else {
            conf.set("cascading.flow.step.path", HadoopUtil.writeStateToDistCache(conf, this.getID(), stepState));
        }
        return conf;
    }

    public boolean isHadoopLocalMode(JobConf conf) {
        return HadoopUtil.isLocal(conf);
    }

    private String pack(Object object, JobConf conf) {
        try {
            return HadoopUtil.serializeBase64(object, conf, true);
        }
        catch (IOException exception) {
            throw new FlowException("unable to pack object: " + object.getClass().getCanonicalName(), exception);
        }
    }

    @Override
    protected FlowStepJob<JobConf> createFlowStepJob(FlowProcess<JobConf> flowProcess, JobConf parentConfig) {
        try {
            JobConf initializedConfig = this.getInitializedConfig(flowProcess, parentConfig);
            this.setConf(initializedConfig);
            return new HadoopFlowStepJob(this.createClientState(flowProcess), this, initializedConfig);
        }
        catch (NoClassDefFoundError error2) {
            PlatformInfo platformInfo = HadoopUtil.getPlatformInfo();
            String message = "unable to load platform specific class, please verify Hadoop cluster version: '%s', matches the Hadoop platform build dependency and associated FlowConnector, cascading-hadoop or cascading-hadoop2-mr1";
            this.logError(String.format(message, platformInfo.toString()), error2);
            throw error2;
        }
    }

    @Override
    public void clean(JobConf config2) {
        String stepStatePath = config2.get("cascading.flow.step.path");
        if (stepStatePath != null) {
            try {
                HadoopUtil.removeStateFromDistCache(config2, stepStatePath);
            }
            catch (IOException exception) {
                this.logWarn("unable to remove step state file: " + stepStatePath, exception);
            }
        }
        if (this.tempSink != null) {
            try {
                this.tempSink.deleteResource(config2);
            }
            catch (Exception exception) {
                this.logWarn("unable to remove temporary file: " + this.tempSink, exception);
            }
        }
        if (this.getSink().isTemporary() && (this.getFlow().getFlowStats().isSuccessful() || this.getFlow().getRunID() == null)) {
            try {
                this.getSink().deleteResource(config2);
            }
            catch (Exception exception) {
                this.logWarn("unable to remove temporary file: " + this.getSink(), exception);
            }
        } else {
            this.cleanTapMetaData(config2, this.getSink());
        }
        for (Tap tap : this.getMapperTraps().values()) {
            this.cleanTapMetaData(config2, tap);
        }
        for (Tap tap : this.getReducerTraps().values()) {
            this.cleanTapMetaData(config2, tap);
        }
    }

    private void cleanTapMetaData(JobConf jobConf, Tap tap) {
        try {
            Hadoop18TapUtil.cleanupTapMetaData(jobConf, tap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addComparators(JobConf conf, String property, Map<String, Fields> map2) {
        Iterator<Fields> fieldsIterator = map2.values().iterator();
        if (!fieldsIterator.hasNext()) {
            return;
        }
        Fields fields2 = fieldsIterator.next();
        if (fields2.hasComparators()) {
            conf.set(property, this.pack(fields2, conf));
            return;
        }
        Set<Scope> previousScopes = this.getPreviousScopes(this.getGroup());
        fields2 = previousScopes.iterator().next().getOutValuesFields();
        if (fields2.size() != 0) {
            conf.setInt(property + ".size", fields2.size());
        }
    }

    private void initFromTraps(FlowProcess<JobConf> flowProcess, JobConf conf, Map<String, Tap> traps) {
        if (!traps.isEmpty()) {
            JobConf trapConf = HadoopUtil.copyJobConf(conf);
            for (Tap tap : traps.values()) {
                tap.sinkConfInit(flowProcess, trapConf);
            }
        }
    }

    protected void initFromSources(FlowProcess<JobConf> flowProcess, JobConf conf) {
        Set<Tap> uniqueSources = this.getUniqueStreamedSources();
        JobConf[] streamedJobs = new JobConf[uniqueSources.size()];
        int i = 0;
        for (Tap tap : uniqueSources) {
            if (tap.getIdentifier() == null) {
                throw new IllegalStateException("tap may not have null identifier: " + tap.toString());
            }
            streamedJobs[i] = flowProcess.copyConfig(conf);
            streamedJobs[i].set("cascading.step.source", Tap.id(tap));
            tap.sourceConfInit(flowProcess, streamedJobs[i]);
            ++i;
        }
        Set<Tap> accumulatedSources = this.getAllAccumulatedSources();
        for (Tap tap : accumulatedSources) {
            JobConf accumulatedJob = flowProcess.copyConfig(conf);
            tap.sourceConfInit(flowProcess, accumulatedJob);
            Map<String, String> map2 = flowProcess.diffConfigIntoMap(conf, accumulatedJob);
            conf.set("cascading.step.accumulated.source.conf." + Tap.id(tap), this.pack(map2, conf));
            try {
                if (DistributedCache.getCacheFiles((Configuration)accumulatedJob) == null) continue;
                DistributedCache.setCacheFiles((URI[])DistributedCache.getCacheFiles((Configuration)accumulatedJob), (Configuration)conf);
            }
            catch (IOException exception) {
                throw new CascadingException(exception);
            }
        }
        MultiInputFormat.addInputFormat(conf, streamedJobs);
    }

    public Tap getTapForID(Set<Tap> taps, String id) {
        for (Tap tap : taps) {
            if (!Tap.id(tap).equals(id)) continue;
            return tap;
        }
        return null;
    }

    private void initFromProcessConfigDef(JobConf conf) {
        this.initConfFromProcessConfigDef(this.getSetterFor(conf));
    }

    private ConfigDef.Setter getSetterFor(final JobConf conf) {
        return new ConfigDef.Setter(){

            @Override
            public String set(String key, String value2) {
                String oldValue = this.get(key);
                conf.set(key, value2);
                return oldValue;
            }

            @Override
            public String update(String key, String value2) {
                String oldValue = this.get(key);
                if (oldValue == null) {
                    conf.set(key, value2);
                } else if (!oldValue.contains(value2)) {
                    conf.set(key, oldValue + "," + value2);
                }
                return oldValue;
            }

            @Override
            public String get(String key) {
                String value2 = conf.get(key);
                if (value2 == null || value2.isEmpty()) {
                    return null;
                }
                return value2;
            }
        };
    }

    private Set<Tap> getUniqueStreamedSources() {
        HashSet<Tap> set2 = new HashSet<Tap>(this.sources.keySet());
        set2.removeAll(this.getAllAccumulatedSources());
        return set2;
    }

    protected void initFromSink(FlowProcess<JobConf> flowProcess, JobConf conf) {
        if (this.getSink() != null) {
            this.getSink().sinkConfInit(flowProcess, conf);
        }
        if (FileOutputFormat.getOutputPath((JobConf)conf) == null) {
            this.tempSink = new TempHfs(conf, "tmp:/" + new Path(this.getSink().getIdentifier()).toUri().getPath(), true);
        }
        if (this.tempSink != null) {
            this.tempSink.sinkConfInit(flowProcess, conf);
        }
    }

    protected void initFromTraps(FlowProcess<JobConf> flowProcess, JobConf conf) {
        this.initFromTraps(flowProcess, conf, this.getMapperTraps());
        this.initFromTraps(flowProcess, conf, this.getReducerTraps());
    }

    @Override
    public Set<Tap> getTraps() {
        HashSet<Tap> set2 = new HashSet<Tap>();
        set2.addAll(this.mapperTraps.values());
        set2.addAll(this.reducerTraps.values());
        return Collections.unmodifiableSet(set2);
    }

    @Override
    public Tap getTrap(String name2) {
        Tap trap = this.getMapperTrap(name2);
        if (trap == null) {
            trap = this.getReducerTrap(name2);
        }
        return trap;
    }

    public Map<String, Tap> getMapperTraps() {
        return this.mapperTraps;
    }

    public Map<String, Tap> getReducerTraps() {
        return this.reducerTraps;
    }

    public Tap getMapperTrap(String name2) {
        return this.getMapperTraps().get(name2);
    }

    public Tap getReducerTrap(String name2) {
        return this.getReducerTraps().get(name2);
    }
}

