/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowSession;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import cascading.tuple.TupleEntry;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class HadoopFlowProcess
extends FlowProcess<JobConf> {
    final JobConf jobConf;
    private final boolean isMapper;
    Reporter reporter = Reporter.NULL;
    private OutputCollector outputCollector;

    public HadoopFlowProcess() {
        this.jobConf = new JobConf();
        this.isMapper = true;
    }

    public HadoopFlowProcess(JobConf jobConf) {
        this.jobConf = jobConf;
        this.isMapper = true;
    }

    public HadoopFlowProcess(FlowSession flowSession, JobConf jobConf) {
        super(flowSession);
        this.jobConf = jobConf;
        this.isMapper = true;
    }

    public HadoopFlowProcess(FlowSession flowSession, JobConf jobConf, boolean isMapper) {
        super(flowSession);
        this.jobConf = jobConf;
        this.isMapper = isMapper;
    }

    public HadoopFlowProcess(HadoopFlowProcess flowProcess, JobConf jobConf) {
        super(flowProcess.getCurrentSession());
        this.jobConf = jobConf;
        this.isMapper = flowProcess.isMapper();
        this.reporter = flowProcess.getReporter();
    }

    @Override
    public FlowProcess copyWith(JobConf jobConf) {
        return new HadoopFlowProcess(this, jobConf);
    }

    public JobConf getJobConf() {
        return this.jobConf;
    }

    @Override
    public JobConf getConfigCopy() {
        return HadoopUtil.copyJobConf(this.jobConf);
    }

    public boolean isMapper() {
        return this.isMapper;
    }

    public int getCurrentNumMappers() {
        return this.getJobConf().getNumMapTasks();
    }

    public int getCurrentNumReducers() {
        return this.getJobConf().getNumReduceTasks();
    }

    @Override
    public int getCurrentSliceNum() {
        return this.getJobConf().getInt("mapred.task.partition", 0);
    }

    @Override
    public int getNumProcessSlices() {
        if (this.isMapper()) {
            return this.getCurrentNumMappers();
        }
        return this.getCurrentNumReducers();
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter == null ? Reporter.NULL : reporter;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void setOutputCollector(OutputCollector outputCollector) {
        this.outputCollector = outputCollector;
    }

    public OutputCollector getOutputCollector() {
        return this.outputCollector;
    }

    @Override
    public Object getProperty(String key) {
        return this.jobConf.get(key);
    }

    @Override
    public Collection<String> getPropertyKeys() {
        HashSet keys2 = new HashSet();
        for (Map.Entry entry2 : this.jobConf) {
            keys2.add(entry2.getKey());
        }
        return Collections.unmodifiableSet(keys2);
    }

    @Override
    public Object newInstance(String className) {
        if (className == null || className.isEmpty()) {
            return null;
        }
        try {
            Class<?> type = HadoopFlowProcess.class.getClassLoader().loadClass(className.toString());
            return ReflectionUtils.newInstance(type, (Configuration)this.jobConf);
        }
        catch (ClassNotFoundException exception) {
            throw new CascadingException("unable to load class: " + className.toString(), exception);
        }
    }

    @Override
    public void keepAlive() {
        this.getReporter().progress();
    }

    @Override
    public void increment(Enum counter2, long amount) {
        this.getReporter().incrCounter(counter2, amount);
    }

    @Override
    public void increment(String group2, String counter2, long amount) {
        this.getReporter().incrCounter(group2, counter2, amount);
    }

    @Override
    public void setStatus(String status) {
        this.getReporter().setStatus(status);
    }

    @Override
    public boolean isCounterStatusInitialized() {
        return this.getReporter() != null;
    }

    @Override
    public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
        return tap.openForRead(this);
    }

    @Override
    public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
        return tap.openForWrite(this, null);
    }

    @Override
    public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
        JobConf jobConf = HadoopUtil.copyJobConf(this.getJobConf());
        int stepNum = jobConf.getInt("cascading.flow.step.num", 0);
        String partname = jobConf.getBoolean("mapred.task.is.map", true) ? String.format("-m-%05d-", stepNum) : String.format("-r-%05d-", stepNum);
        jobConf.set("cascading.tapcollector.partname", "%s%spart" + partname + "%05d");
        return trap.openForWrite(new HadoopFlowProcess(this, jobConf), null);
    }

    @Override
    public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
        return new TupleEntryCollector(Fields.size(2)){

            @Override
            protected void collect(TupleEntry tupleEntry) {
                try {
                    HadoopFlowProcess.this.getOutputCollector().collect(tupleEntry.getObject(0), tupleEntry.getObject(1));
                }
                catch (IOException exception) {
                    throw new CascadingException("failed collecting key and value", exception);
                }
            }
        };
    }

    @Override
    public JobConf copyConfig(JobConf jobConf) {
        return HadoopUtil.copyJobConf(jobConf);
    }

    @Override
    public Map<String, String> diffConfigIntoMap(JobConf defaultConfig, JobConf updatedConfig) {
        return HadoopUtil.getConfig(defaultConfig, updatedConfig);
    }

    @Override
    public JobConf mergeMapIntoConfig(JobConf defaultConfig, Map<String, String> map2) {
        return HadoopUtil.mergeConf(defaultConfig, map2, false);
    }
}

