/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.BaseFlow;
import cascading.flow.Flow;
import cascading.flow.FlowDef;
import cascading.flow.FlowException;
import cascading.flow.FlowProcess;
import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.PlatformInfo;
import cascading.property.PropertyUtil;
import cascading.tap.hadoop.io.HttpFileSystem;
import cascading.util.ShutdownUtil;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class HadoopFlow
extends BaseFlow<JobConf> {
    private static Thread hdfsShutdown = null;
    private static ShutdownUtil.Hook shutdownHook;
    private transient JobConf jobConf;
    private boolean preserveTemporaryFiles = false;
    private transient Map<Path, Path> syncPaths;

    protected HadoopFlow() {
    }

    static boolean getPreserveTemporaryFiles(Map<Object, Object> properties) {
        return Boolean.parseBoolean(PropertyUtil.getProperty(properties, "cascading.flow.preservetemporaryfiles", "false"));
    }

    static int getMaxConcurrentSteps(JobConf jobConf) {
        return jobConf.getInt("cascading.flow.maxconcurrentsteps", 0);
    }

    protected HadoopFlow(PlatformInfo platformInfo, Map<Object, Object> properties, JobConf jobConf, String name2, Map<String, String> flowDescriptor) {
        super(platformInfo, properties, jobConf, name2, flowDescriptor);
        this.initFromProperties(properties);
    }

    public HadoopFlow(PlatformInfo platformInfo, Map<Object, Object> properties, JobConf jobConf, FlowDef flowDef) {
        super(platformInfo, properties, jobConf, flowDef);
        this.initFromProperties(properties);
    }

    @Override
    protected void initFromProperties(Map<Object, Object> properties) {
        super.initFromProperties(properties);
        this.preserveTemporaryFiles = HadoopFlow.getPreserveTemporaryFiles(properties);
    }

    @Override
    protected void initConfig(Map<Object, Object> properties, JobConf parentConfig) {
        if (properties != null) {
            parentConfig = this.createConfig(properties, parentConfig);
        }
        if (parentConfig == null) {
            return;
        }
        this.jobConf = HadoopUtil.copyJobConf(parentConfig);
        this.jobConf.set("fs.http.impl", HttpFileSystem.class.getName());
        this.jobConf.set("fs.https.impl", HttpFileSystem.class.getName());
        this.syncPaths = HadoopUtil.addToClassPath(this.jobConf, this.getClassPath());
    }

    @Override
    protected void setConfigProperty(JobConf config2, Object key, Object value2) {
        if (value2 instanceof Class || value2 instanceof JobConf) {
            return;
        }
        config2.set(key.toString(), value2.toString());
    }

    @Override
    protected JobConf newConfig(JobConf defaultConfig) {
        return defaultConfig == null ? new JobConf() : HadoopUtil.copyJobConf(defaultConfig);
    }

    @Override
    public JobConf getConfig() {
        if (this.jobConf == null) {
            this.initConfig((Map<Object, Object>)null, new JobConf());
        }
        return this.jobConf;
    }

    @Override
    public JobConf getConfigCopy() {
        return HadoopUtil.copyJobConf(this.getConfig());
    }

    @Override
    public Map<Object, Object> getConfigAsProperties() {
        return HadoopUtil.createProperties((Configuration)this.getConfig());
    }

    @Override
    public String getProperty(String key) {
        return this.getConfig().get(key);
    }

    @Override
    public FlowProcess<JobConf> getFlowProcess() {
        return new HadoopFlowProcess(this.getFlowSession(), this.getConfig());
    }

    public boolean isPreserveTemporaryFiles() {
        return this.preserveTemporaryFiles;
    }

    @Override
    protected void internalStart() {
        try {
            this.copyToDistributedCache();
            this.deleteSinksIfReplace();
            this.deleteTrapsIfReplace();
            this.deleteCheckpointsIfReplace();
        }
        catch (IOException exception) {
            throw new FlowException("unable to delete sinks", exception);
        }
        HadoopFlow.registerHadoopShutdownHook(this);
    }

    private void copyToDistributedCache() {
        HadoopUtil.syncPaths(this.jobConf, this.syncPaths);
    }

    @Override
    public boolean stepsAreLocal() {
        return HadoopUtil.isLocal(this.getConfig());
    }

    private void cleanTemporaryFiles(boolean stop) {
        if (stop) {
            return;
        }
        for (FlowStep step : this.getFlowSteps()) {
            ((BaseFlowStep)step).clean();
        }
    }

    private static synchronized void registerHadoopShutdownHook(Flow flow) {
        if (!flow.isStopJobsOnExit()) {
            return;
        }
        if (shutdownHook != null) {
            return;
        }
        HadoopFlow.getHdfsShutdownHook();
        shutdownHook = new ShutdownUtil.Hook(){

            @Override
            public ShutdownUtil.Hook.Priority priority() {
                return ShutdownUtil.Hook.Priority.LAST;
            }

            @Override
            public void execute() {
                HadoopFlow.callHdfsShutdownHook();
            }
        };
        ShutdownUtil.addHook(shutdownHook);
    }

    private static synchronized void callHdfsShutdownHook() {
        if (hdfsShutdown != null) {
            hdfsShutdown.start();
        }
    }

    private static synchronized void getHdfsShutdownHook() {
        if (hdfsShutdown == null) {
            hdfsShutdown = HadoopUtil.getHDFSShutdownHook();
        }
    }

    @Override
    protected void internalClean(boolean stop) {
        if (!this.isPreserveTemporaryFiles()) {
            this.cleanTemporaryFiles(stop);
        }
    }

    @Override
    protected void internalShutdown() {
    }

    @Override
    protected int getMaxNumParallelSteps() {
        return this.stepsAreLocal() ? 1 : HadoopFlow.getMaxConcurrentSteps(this.getConfig());
    }
}

