/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.FlowProcess;
import cascading.flow.hadoop.HadoopGroupByClosure;
import cascading.flow.hadoop.util.FalseCollection;
import cascading.provider.FactoryLoader;
import cascading.tuple.Fields;
import cascading.tuple.Tuple;
import cascading.tuple.Tuples;
import cascading.tuple.collect.Spillable;
import cascading.tuple.collect.SpillableTupleList;
import cascading.tuple.collect.TupleCollectionFactory;
import cascading.tuple.hadoop.collect.HadoopTupleCollectionFactory;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.util.TupleViews;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopCoGroupClosure
extends HadoopGroupByClosure {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopCoGroupClosure.class);
    Collection<Tuple>[] collections;
    private final int numSelfJoins;
    private Tuple[] joinedTuplesArray;
    private final Tuple emptyTuple;
    private TupleBuilder joinedBuilder;
    private Tuple joinedTuple = new Tuple();
    private final TupleCollectionFactory<JobConf> tupleCollectionFactory;

    public HadoopCoGroupClosure(FlowProcess flowProcess, int numSelfJoins, Fields[] groupingFields, Fields[] valueFields) {
        super(flowProcess, groupingFields, valueFields);
        this.numSelfJoins = numSelfJoins;
        this.emptyTuple = Tuple.size(groupingFields[0].size());
        FactoryLoader loader = FactoryLoader.getInstance();
        this.tupleCollectionFactory = loader.loadFactoryFrom(flowProcess, "cascading.factory.tuple.collection.classname", HadoopTupleCollectionFactory.class);
        this.initLists();
    }

    @Override
    public int size() {
        return Math.max(this.joinFields.length, this.numSelfJoins + 1);
    }

    @Override
    public Iterator<Tuple> getIterator(int pos) {
        if (pos < 0 || pos >= this.collections.length) {
            throw new IllegalArgumentException("invalid group position: " + pos);
        }
        return this.makeIterator(pos, this.collections[pos].iterator());
    }

    @Override
    public Tuple getGroupTuple(Tuple keysTuple) {
        Tuples.asModifiable(this.joinedTuple);
        for (int i = 0; i < this.collections.length; ++i) {
            this.joinedTuplesArray[i] = this.collections[i].isEmpty() ? this.emptyTuple : keysTuple;
        }
        this.joinedTuple = this.joinedBuilder.makeResult(this.joinedTuplesArray);
        return this.joinedTuple;
    }

    @Override
    public boolean isEmpty(int pos) {
        return this.collections[pos].isEmpty();
    }

    @Override
    public void reset(Tuple grouping, Iterator values2) {
        super.reset(grouping, values2);
        this.build();
    }

    private void build() {
        this.clearGroups();
        if (this.collections[0] instanceof FalseCollection) {
            ((FalseCollection)this.collections[0]).setIterator(null);
        }
        while (this.values.hasNext()) {
            IndexTuple current = (IndexTuple)this.values.next();
            int pos = current.getIndex();
            if (this.numSelfJoins == 0 && pos == 0) {
                ((FalseCollection)this.collections[0]).setIterator(this.createIterator(current, this.values));
                break;
            }
            this.collections[pos].add(current.getTuple());
        }
    }

    private void clearGroups() {
        for (Collection<Tuple> collection2 : this.collections) {
            collection2.clear();
            if (!(collection2 instanceof Spillable)) continue;
            ((Spillable)((Object)collection2)).setGrouping(this.grouping);
        }
    }

    private void initLists() {
        this.collections = new Collection[this.size()];
        if (this.numSelfJoins != 0) {
            Arrays.fill(this.collections, this.createTupleCollection(this.joinFields[0]));
        } else {
            this.collections[0] = new FalseCollection();
            for (int i = 1; i < this.joinFields.length; ++i) {
                this.collections[i] = this.createTupleCollection(this.joinFields[i]);
            }
        }
        this.joinedBuilder = this.makeJoinedBuilder(this.joinFields);
        this.joinedTuplesArray = new Tuple[this.collections.length];
    }

    private TupleBuilder makeJoinedBuilder(Fields[] joinFields) {
        Object[] fields2;
        Object[] objectArray = fields2 = this.isSelfJoin() ? new Fields[this.size()] : joinFields;
        if (this.isSelfJoin()) {
            Arrays.fill(fields2, 0, fields2.length, joinFields[0]);
        }
        return new TupleBuilder((Fields[])fields2){
            Tuple result;
            final /* synthetic */ Fields[] val$fields;
            {
                this.val$fields = fieldsArray;
                this.result = TupleViews.createComposite(this.val$fields);
            }

            @Override
            public Tuple makeResult(Tuple[] tuples) {
                return TupleViews.reset(this.result, tuples);
            }
        };
    }

    private Collection<Tuple> createTupleCollection(Fields joinField) {
        Collection collection2 = (Collection)this.tupleCollectionFactory.create(this.flowProcess);
        if (collection2 instanceof Spillable) {
            ((Spillable)((Object)collection2)).setSpillListener(this.createListener(joinField));
        }
        return collection2;
    }

    private Spillable.SpillListener createListener(Fields joinField) {
        return new SpillListener(this.flowProcess, joinField);
    }

    public Iterator<Tuple> createIterator(final IndexTuple current, final Iterator<IndexTuple> values2) {
        return new Iterator<Tuple>(){
            IndexTuple value;
            {
                this.value = current;
            }

            @Override
            public boolean hasNext() {
                return this.value != null;
            }

            @Override
            public Tuple next() {
                if (this.value == null && !values2.hasNext()) {
                    throw new NoSuchElementException();
                }
                Tuple result2 = this.value.getTuple();
                this.value = values2.hasNext() ? (IndexTuple)values2.next() : null;
                return result2;
            }

            @Override
            public void remove() {
            }
        };
    }

    static interface TupleBuilder {
        public Tuple makeResult(Tuple[] var1);
    }

    private class SpillListener
    implements Spillable.SpillListener {
        private final FlowProcess flowProcess;
        private final Fields joinField;

        public SpillListener(FlowProcess flowProcess, Fields joinField) {
            this.flowProcess = flowProcess;
            this.joinField = joinField;
        }

        @Override
        public void notifyWriteSpillBegin(Spillable spillable, int spillSize, String spillReason) {
            int numFiles = spillable.spillCount();
            if (numFiles % 10 == 0) {
                LOG.info("spilling group: {}, on grouping: {}, num times: {}, with reason: {}", this.joinField.printVerbose(), spillable.getGrouping().print(), numFiles + 1, spillReason);
                Runtime runtime = Runtime.getRuntime();
                long freeMem = runtime.freeMemory() / 1024L / 1024L;
                long maxMem = runtime.maxMemory() / 1024L / 1024L;
                long totalMem = runtime.totalMemory() / 1024L / 1024L;
                LOG.info("mem on spill (mb), free: " + freeMem + ", total: " + totalMem + ", max: " + maxMem);
            }
            LOG.info("spilling {} tuples in list to file number {}", (Object)spillSize, (Object)(numFiles + 1));
            this.flowProcess.increment(Spill.Num_Spills_Written, 1L);
            this.flowProcess.increment(Spill.Num_Tuples_Spilled, spillSize);
        }

        @Override
        public void notifyWriteSpillEnd(SpillableTupleList spillableTupleList, long duration) {
            this.flowProcess.increment(Spill.Duration_Millis_Written, duration);
        }

        @Override
        public void notifyReadSpillBegin(Spillable spillable) {
            this.flowProcess.increment(Spill.Num_Spills_Read, 1L);
        }
    }

    public static enum Spill {
        Num_Spills_Written,
        Num_Spills_Read,
        Num_Tuples_Spilled,
        Duration_Millis_Written;

    }
}

