/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowException;
import cascading.flow.FlowSession;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.hadoop.planner.HadoopFlowStepJob;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.hadoop.stream.HadoopReduceStreamGraph;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.hadoop.util.TimedIterator;
import cascading.flow.stream.Duct;
import cascading.flow.stream.ElementDuct;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowReducer
extends MapReduceBase
implements Reducer {
    private static final Logger LOG = LoggerFactory.getLogger(FlowReducer.class);
    private HadoopReduceStreamGraph streamGraph;
    private HadoopFlowProcess currentProcess;
    private TimedIterator timedIterator;
    private boolean calledPrepare = false;
    private HadoopGroupGate group;

    public void configure(JobConf jobConf) {
        try {
            super.configure(jobConf);
            HadoopUtil.initLog4j(jobConf);
            LOG.info("cascading version: {}", (Object)jobConf.get("cascading.version", ""));
            LOG.info("child jvm opts: {}", (Object)jobConf.get("mapred.child.java.opts", ""));
            this.currentProcess = new HadoopFlowProcess(new FlowSession(), jobConf, false);
            this.timedIterator = new TimedIterator(this.currentProcess, SliceCounters.Read_Duration, SliceCounters.Tuples_Read);
            String stepState = jobConf.getRaw("cascading.flow.step");
            if (stepState == null) {
                stepState = HadoopUtil.readStateFromDistCache(jobConf, jobConf.get("cascading.flow.step.id"));
            }
            HadoopFlowStep step = HadoopUtil.deserializeBase64(stepState, (Configuration)jobConf, HadoopFlowStep.class);
            this.streamGraph = new HadoopReduceStreamGraph(this.currentProcess, step);
            this.group = (HadoopGroupGate)this.streamGraph.getHeads().iterator().next();
            for (Duct head2 : this.streamGraph.getHeads()) {
                LOG.info("sourcing from: " + ((ElementDuct)((Object)head2)).getFlowElement());
            }
            for (Duct tail : this.streamGraph.getTails()) {
                LOG.info("sinking to: " + ((ElementDuct)((Object)tail)).getFlowElement());
            }
            for (Tap trap : step.getReducerTraps().values()) {
                LOG.info("trapping to: " + trap);
            }
        }
        catch (Throwable throwable2) {
            this.reportIfLocal(throwable2);
            if (throwable2 instanceof CascadingException) {
                throw (CascadingException)throwable2;
            }
            throw new FlowException("internal error during reducer configuration", throwable2);
        }
    }

    public void reduce(Object key, Iterator values2, OutputCollector output, Reporter reporter) throws IOException {
        this.currentProcess.setReporter(reporter);
        this.currentProcess.setOutputCollector(output);
        this.timedIterator.reset(values2);
        if (!this.calledPrepare) {
            this.currentProcess.increment(SliceCounters.Process_Begin_Time, System.currentTimeMillis());
            this.streamGraph.prepare();
            this.calledPrepare = true;
            this.group.start(this.group);
        }
        try {
            this.group.run((Tuple)key, this.timedIterator);
        }
        catch (OutOfMemoryError error2) {
            throw error2;
        }
        catch (Throwable throwable2) {
            this.reportIfLocal(throwable2);
            if (throwable2 instanceof CascadingException) {
                throw (CascadingException)throwable2;
            }
            throw new FlowException("internal error during reducer execution", throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.calledPrepare) {
                this.group.complete(this.group);
                this.streamGraph.cleanup();
            }
            super.close();
        }
        finally {
            if (this.currentProcess != null) {
                this.currentProcess.increment(SliceCounters.Process_End_Time, System.currentTimeMillis());
            }
        }
    }

    private void reportIfLocal(Throwable throwable2) {
        if (HadoopUtil.isLocal(this.currentProcess.getJobConf())) {
            HadoopFlowStepJob.reportLocalError(throwable2);
        }
    }
}

