/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.CascadingException;
import cascading.flow.FlowException;
import cascading.flow.FlowSession;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopFlowProcess;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.hadoop.planner.HadoopFlowStepJob;
import cascading.flow.hadoop.stream.HadoopMapStreamGraph;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.stream.Duct;
import cascading.flow.stream.ElementDuct;
import cascading.flow.stream.SourceStage;
import cascading.tap.Tap;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapRunnable;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowMapper
implements MapRunnable {
    private static final Logger LOG = LoggerFactory.getLogger(FlowMapper.class);
    private HadoopMapStreamGraph streamGraph;
    private HadoopFlowProcess currentProcess;

    public void configure(JobConf jobConf) {
        try {
            HadoopUtil.initLog4j(jobConf);
            LOG.info("cascading version: {}", (Object)jobConf.get("cascading.version", ""));
            LOG.info("child jvm opts: {}", (Object)jobConf.get("mapred.child.java.opts", ""));
            this.currentProcess = new HadoopFlowProcess(new FlowSession(), jobConf, true);
            String stepState = jobConf.getRaw("cascading.flow.step");
            if (stepState == null) {
                stepState = HadoopUtil.readStateFromDistCache(jobConf, jobConf.get("cascading.flow.step.id"));
            }
            HadoopFlowStep step = HadoopUtil.deserializeBase64(stepState, (Configuration)jobConf, HadoopFlowStep.class);
            Tap source2 = step.getTapForID(step.getSources(), jobConf.get("cascading.step.source"));
            this.streamGraph = new HadoopMapStreamGraph(this.currentProcess, step, source2);
            for (Duct head2 : this.streamGraph.getHeads()) {
                LOG.info("sourcing from: " + ((ElementDuct)((Object)head2)).getFlowElement());
            }
            for (Duct tail : this.streamGraph.getTails()) {
                LOG.info("sinking to: " + ((ElementDuct)((Object)tail)).getFlowElement());
            }
            for (Tap trap : step.getMapperTraps().values()) {
                LOG.info("trapping to: " + trap);
            }
        }
        catch (Throwable throwable2) {
            this.reportIfLocal(throwable2);
            if (throwable2 instanceof CascadingException) {
                throw (CascadingException)throwable2;
            }
            throw new FlowException("internal error during mapper configuration", throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RecordReader input2, OutputCollector output, Reporter reporter) throws IOException {
        this.currentProcess.setReporter(reporter);
        this.currentProcess.increment(SliceCounters.Process_Begin_Time, System.currentTimeMillis());
        this.currentProcess.setOutputCollector(output);
        this.streamGraph.prepare();
        SourceStage streamedHead = this.streamGraph.getStreamedHead();
        Iterator<Duct> iterator2 = this.streamGraph.getHeads().iterator();
        try {
            try {
                while (iterator2.hasNext()) {
                    Duct next2 = iterator2.next();
                    if (next2 == streamedHead) continue;
                    ((SourceStage)next2).run(null);
                }
                streamedHead.run(input2);
            }
            catch (OutOfMemoryError error2) {
                throw error2;
            }
            catch (IOException exception) {
                this.reportIfLocal(exception);
                throw exception;
            }
            catch (Throwable throwable2) {
                this.reportIfLocal(throwable2);
                if (throwable2 instanceof CascadingException) {
                    throw (CascadingException)throwable2;
                }
                throw new FlowException("internal error during mapper execution", throwable2);
            }
        }
        finally {
            try {
                this.streamGraph.cleanup();
            }
            finally {
                this.currentProcess.increment(SliceCounters.Process_End_Time, System.currentTimeMillis());
            }
        }
    }

    private void reportIfLocal(Throwable throwable2) {
        if (HadoopUtil.isLocal(this.currentProcess.getJobConf())) {
            HadoopFlowStepJob.reportLocalError(throwable2);
        }
    }
}

