/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow;

import cascading.flow.FlowSession;
import cascading.tap.Tap;
import cascading.tuple.TupleEntryCollector;
import cascading.tuple.TupleEntryIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class FlowProcess<Config> {
    public static FlowProcess NULL = new NullFlowProcess();
    private FlowSession currentSession = FlowSession.NULL;

    protected FlowProcess() {
    }

    protected FlowProcess(FlowSession currentSession) {
        this.setCurrentSession(currentSession);
    }

    public abstract FlowProcess copyWith(Config var1);

    public String getID() {
        return this.getStringProperty("cascading.flow.step.id");
    }

    public FlowSession getCurrentSession() {
        return this.currentSession;
    }

    public void setCurrentSession(FlowSession currentSession) {
        this.currentSession = currentSession;
        currentSession.setCurrentProcess(this);
    }

    public abstract int getNumProcessSlices();

    public abstract int getCurrentSliceNum();

    public abstract Object getProperty(String var1);

    public String getStringProperty(String key) {
        Object value2 = this.getProperty(key);
        if (value2 == null) {
            return null;
        }
        return value2.toString();
    }

    public Integer getIntegerProperty(String key) {
        String value2 = this.getStringProperty(key);
        if (value2 == null || value2.isEmpty()) {
            return null;
        }
        return Integer.valueOf(value2);
    }

    public abstract Collection<String> getPropertyKeys();

    public abstract Object newInstance(String var1);

    public abstract void keepAlive();

    public abstract void increment(Enum var1, long var2);

    public abstract void increment(String var1, String var2, long var3);

    public abstract void setStatus(String var1);

    public abstract boolean isCounterStatusInitialized();

    public abstract TupleEntryIterator openTapForRead(Tap var1) throws IOException;

    public abstract TupleEntryCollector openTapForWrite(Tap var1) throws IOException;

    public abstract TupleEntryCollector openTrapForWrite(Tap var1) throws IOException;

    public abstract TupleEntryCollector openSystemIntermediateForWrite() throws IOException;

    public abstract Config getConfigCopy();

    public abstract Config copyConfig(Config var1);

    public abstract Map<String, String> diffConfigIntoMap(Config var1, Config var2);

    public abstract Config mergeMapIntoConfig(Config var1, Map<String, String> var2);

    public static class NullFlowProcess
    extends FlowProcess<Object> {
        protected NullFlowProcess() {
        }

        @Override
        public FlowProcess copyWith(Object object) {
            return new NullFlowProcess();
        }

        @Override
        public Object getProperty(String key) {
            return null;
        }

        @Override
        public Collection<String> getPropertyKeys() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Object newInstance(String className) {
            return null;
        }

        @Override
        public void keepAlive() {
        }

        @Override
        public void increment(Enum counter2, long amount) {
        }

        @Override
        public void increment(String group2, String counter2, long amount) {
        }

        @Override
        public void setStatus(String status) {
        }

        @Override
        public boolean isCounterStatusInitialized() {
            return true;
        }

        @Override
        public int getNumProcessSlices() {
            return 1;
        }

        @Override
        public int getCurrentSliceNum() {
            return 0;
        }

        @Override
        public TupleEntryIterator openTapForRead(Tap tap) throws IOException {
            return tap.openForRead(this);
        }

        @Override
        public TupleEntryCollector openTapForWrite(Tap tap) throws IOException {
            return tap.openForWrite(this);
        }

        @Override
        public TupleEntryCollector openTrapForWrite(Tap trap) throws IOException {
            return trap.openForWrite(this);
        }

        @Override
        public TupleEntryCollector openSystemIntermediateForWrite() throws IOException {
            return null;
        }

        @Override
        public Object getConfigCopy() {
            return null;
        }

        @Override
        public Object copyConfig(Object config2) {
            return config2;
        }

        @Override
        public Map<String, String> diffConfigIntoMap(Object defaultConfig, Object updatedConfig) {
            return null;
        }

        @Override
        public Object mergeMapIntoConfig(Object defaultConfig, Map<String, String> map2) {
            return null;
        }
    }
}

